/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class SwitchStatementGenerator {
    private SwitchStatementGenerator() {
    }

    public static void generate(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrSwitchStatement switchStatement) {
        PsiType type;
        GrExpression condition = switchStatement.getCondition();
        GrCaseSection[] caseSections = switchStatement.getCaseSections();
        PsiType psiType = type = condition == null ? null : TypesUtil.unboxPrimitiveTypeWrapper(condition.getType());
        if (type == null || SwitchStatementGenerator.isValidTypeForSwitchSelector(type)) {
            SwitchStatementGenerator.generateSwitch(builder, context, condition, caseSections);
        } else {
            SwitchStatementGenerator.generateIfs(builder, context, condition, caseSections);
        }
    }

    private static boolean isValidTypeForSwitchSelector(@NotNull PsiType type) {
        if (TypeConversionUtil.getTypeRank((PsiType)type) <= 4) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        return aClass != null && aClass.isEnum();
    }

    private static void generateIfs(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition, @NotNull GrCaseSection[] caseSections) {
        GrExpression ref;
        if (condition instanceof GrReferenceExpression) {
            ref = condition;
        } else {
            String varName = SwitchStatementGenerator.generateConditionVar(builder, context, condition);
            ref = GroovyPsiElementFactory.getInstance(context.project).createExpressionFromText(varName);
        }
        GrExpression[] args = new GrExpression[]{ref};
        SwitchStatementGenerator.generateIfFromCaseSection(builder, context, caseSections, 0, args);
    }

    private static void generateIfFromCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, final @NotNull GrCaseSection[] caseSections, final int i, final @NotNull GrExpression[] args) {
        GenerationUtil.writeStatement(builder, context, null, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrCaseSection section;
                GrCaseLabel[] labels;
                boolean isCase;
                GrCaseLabel[] labels2;
                if (caseSections.length == 1 && (labels2 = caseSections[0].getCaseLabels()).length == 1 && labels2[0].isDefault()) {
                    builder.append("if(true)");
                }
                boolean bl = isCase = (labels = (section = caseSections[i]).getCaseLabels()).length > 1 || !labels[0].isDefault();
                if (isCase) {
                    SwitchStatementGenerator.writeCondition(builder, context, section, labels, args);
                }
                SwitchStatementGenerator.writeCaseBody(builder, context, i, caseSections);
                if (isCase && i != caseSections.length - 1) {
                    builder.append("\nelse ");
                    StringBuilder elseBuilder = new StringBuilder();
                    ExpressionContext elseContext = context.extend();
                    SwitchStatementGenerator.generateIfFromCaseSection(elseBuilder, elseContext, caseSections, i + 1, args);
                    GenerationUtil.insertStatementFromContextBefore(builder, elseContext);
                    builder.append((CharSequence)elseBuilder);
                }
                if (!context.myStatements.isEmpty()) {
                    context.setInsertCurlyBrackets();
                }
            }
        });
    }

    private static void writeCaseBody(@NotNull StringBuilder builder, @NotNull ExpressionContext context, int i, @NotNull GrCaseSection[] caseSections) {
        builder.append("{\n");
        ExpressionContext extended = context.extend();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, extended);
        block0: for (int j = i; j < caseSections.length; ++j) {
            GrStatement[] statements;
            GrCaseSection curSection = caseSections[j];
            for (GrStatement statement : statements = curSection.getStatements()) {
                if (statement instanceof GrBreakStatement && ((GrBreakStatement)statement).getLabelIdentifier() == null) break block0;
                statement.accept(generator);
                builder.append("\n");
            }
            if (SwitchStatementGenerator.brakesFlow(curSection)) break;
        }
        builder.append('}');
    }

    private static boolean brakesFlow(GrCaseSection section) {
        Object[] statements = section.getStatements();
        return statements.length > 0 && !ControlFlowUtils.statementMayCompleteNormally((GrStatement)ArrayUtil.getLastElement((Object[])statements));
    }

    private static void writeCondition(StringBuilder builder, ExpressionContext context, GrCaseSection section, GrCaseLabel[] labels, GrExpression[] args) {
        builder.append("if (");
        for (GrCaseLabel label : labels) {
            if (label.isDefault()) {
                builder.append("true");
            } else {
                GenerationUtil.invokeMethodByName(label.getValue(), "isCase", args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, new ExpressionGenerator(builder, context), section);
            }
            builder.append("||");
        }
        builder.delete(builder.length() - 2, builder.length());
        builder.append(") ");
    }

    private static String generateConditionVar(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition) {
        StringBuilder conditionBuilder = new StringBuilder();
        PsiType type = condition.getType();
        String varName = GenerationUtil.validateName("switchArg", condition, context);
        conditionBuilder.append("final ");
        TypeWriter.writeType(conditionBuilder, type, condition);
        conditionBuilder.append(' ').append(varName).append(" = ");
        condition.accept(new ExpressionGenerator(conditionBuilder, context));
        conditionBuilder.append(";\n");
        GenerationUtil.insertStatementFromContextBefore(builder, context);
        builder.append((CharSequence)conditionBuilder);
        return varName;
    }

    private static void generateSwitch(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @Nullable GrExpression condition, @NotNull GrCaseSection[] caseSections) {
        builder.append("switch (");
        if (condition != null) {
            condition.accept(new ExpressionGenerator(builder, context));
        }
        builder.append(") {\n");
        ExpressionContext innerContext = context.extend();
        for (GrCaseSection section : caseSections) {
            SwitchStatementGenerator.generateCaseSection(builder, context, innerContext, section);
        }
        builder.append('}');
    }

    private static void generateCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull ExpressionContext innerContext, @NotNull GrCaseSection section) {
        for (GrCaseLabel label : section.getCaseLabels()) {
            SwitchStatementGenerator.writeLabel(builder, context, label);
        }
        GrStatement[] statements = section.getStatements();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, innerContext);
        for (GrStatement statement : statements) {
            statement.accept(generator);
            builder.append("\n");
        }
    }

    private static void writeLabel(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrCaseLabel label) {
        if (label.isDefault()) {
            builder.append("default");
        } else {
            Object evaluated;
            builder.append("case ");
            GrExpression value = label.getValue();
            try {
                evaluated = GroovyConstantExpressionEvaluator.evaluate(value);
            }
            catch (Throwable e) {
                evaluated = null;
            }
            if (evaluated != null) {
                builder.append(evaluated);
            } else if (value != null) {
                value.accept(new ExpressionGenerator(builder, context));
            }
        }
        builder.append(":\n");
    }
}

