/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.method;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.DuplicatesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.GrParameterTablePanel;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.method.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.method.ExtractMethodSettings;
import org.jetbrains.plugins.groovy.refactoring.extract.method.GroovyExtractMethodHandler;
import org.jetbrains.plugins.groovy.refactoring.ui.GrMethodSignatureComponent;
import org.jetbrains.plugins.groovy.refactoring.ui.GroovyComboboxVisibilityPanel;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;

public class GroovyExtractMethodDialog
extends DialogWrapper {
    private final ExtractMethodInfoHelper myHelper;
    private final EventListenerList myListenerList;
    private JPanel contentPane;
    private EditorTextField myNameField;
    private JCheckBox myCbSpecifyType;
    private JLabel myNameLabel;
    private MethodSignatureComponent mySignature;
    private ComboBoxVisibilityPanel<String> myVisibilityPanel;
    private Splitter mySplitter;
    private JCheckBox myForceReturnCheckBox;
    private GrParameterTablePanel myParameterTablePanel;
    private final Project myProject;

    public GroovyExtractMethodDialog(InitialInfo info, PsiClass owner) {
        super(info.getProject(), true);
        this.$$$setupUI$$$();
        this.myListenerList = new EventListenerList();
        this.myProject = info.getProject();
        this.myHelper = new ExtractMethodInfoHelper(info, "", owner, false);
        this.myParameterTablePanel.init(this.myHelper);
        this.setModal(true);
        this.setTitle(GroovyExtractMethodHandler.REFACTORING_NAME);
        this.init();
        this.setUpNameField();
        this.setUpDialog();
        this.update();
    }

    protected void init() {
        super.init();
        this.mySplitter.setOrientation(true);
        this.mySplitter.setShowDividerIcon(false);
        this.mySplitter.setFirstComponent((JComponent)((Object)this.myParameterTablePanel));
        this.mySplitter.setSecondComponent((JComponent)this.mySignature);
    }

    protected void doOKAction() {
        this.myHelper.setForceReturn(this.myForceReturnCheckBox.isSelected());
        String name = this.getEnteredName();
        if (name == null) {
            return;
        }
        GrMethod method = ExtractUtil.createMethod(this.myHelper);
        if (method != null && !GroovyExtractMethodDialog.validateMethod(method, this.myHelper)) {
            return;
        }
        GroovyApplicationSettings settings = GroovyApplicationSettings.getInstance();
        if (this.myCbSpecifyType.isEnabled()) {
            settings.EXTRACT_METHOD_SPECIFY_TYPE = this.myCbSpecifyType.isSelected();
        }
        if (this.myForceReturnCheckBox.isEnabled()) {
            settings.FORCE_RETURN = this.myForceReturnCheckBox.isSelected();
        }
        settings.EXTRACT_METHOD_VISIBILITY = (String)this.myVisibilityPanel.getVisibility();
        super.doOKAction();
    }

    private void setUpDialog() {
        this.myCbSpecifyType.setMnemonic(84);
        this.myCbSpecifyType.setFocusable(false);
        this.myCbSpecifyType.setSelected(true);
        if (GroovyApplicationSettings.getInstance().EXTRACT_METHOD_SPECIFY_TYPE != null) {
            this.myCbSpecifyType.setSelected(GroovyApplicationSettings.getInstance().EXTRACT_METHOD_SPECIFY_TYPE);
        }
        this.myCbSpecifyType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroovyExtractMethodDialog.this.myHelper.setSpecifyType(GroovyExtractMethodDialog.this.myCbSpecifyType.isSelected());
                GroovyExtractMethodDialog.this.updateSignature();
            }
        });
        this.myHelper.setSpecifyType(this.myCbSpecifyType.isSelected());
        this.myHelper.setVisibility((String)this.myVisibilityPanel.getVisibility());
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        PsiType type = this.myHelper.getOutputType();
        if (!PsiType.VOID.equals((Object)type)) {
            this.myForceReturnCheckBox.setSelected(GroovyApplicationSettings.getInstance().FORCE_RETURN);
        } else {
            this.myForceReturnCheckBox.setEnabled(false);
            this.myForceReturnCheckBox.setSelected(false);
        }
    }

    private void setUpNameField() {
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myNameField.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                GroovyExtractMethodDialog.this.fireNameDataChanged();
            }
        });
        this.myListenerList.add(DataChangedListener.class, new DataChangedListener());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    @NotNull
    protected ExtractMethodInfoHelper getHelper() {
        return this.myHelper;
    }

    private void update() {
        String text = this.getEnteredName();
        this.myHelper.setName(text);
        this.updateSignature();
    }

    protected ValidationInfo doValidate() {
        return null;
    }

    @Nullable
    protected String getEnteredName() {
        String text = this.myNameField.getText();
        if (text != null && !text.trim().isEmpty()) {
            return text.trim();
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.extractMethod");
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    private void createUIComponents() {
        this.mySignature = new GrMethodSignatureComponent("", this.myProject);
        this.mySignature.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        this.mySignature.setMinimumSize((Dimension)JBUI.size((int)500, (int)100));
        this.mySignature.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GroovyRefactoringBundle.message("signature.preview.border.title", new Object[0]), (boolean)false));
        this.mySignature.setFocusable(false);
        this.myNameField = new EditorTextField("", this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        this.myVisibilityPanel = new GroovyComboboxVisibilityPanel();
        String visibility = GroovyApplicationSettings.getInstance().EXTRACT_METHOD_VISIBILITY;
        if (visibility == null) {
            visibility = "private";
        }
        this.myVisibilityPanel.setVisibility((Object)visibility);
        this.myVisibilityPanel.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroovyExtractMethodDialog.this.myHelper.setVisibility((String)GroovyExtractMethodDialog.this.myVisibilityPanel.getVisibility());
                GroovyExtractMethodDialog.this.updateSignature();
            }
        });
        this.myParameterTablePanel = new GrParameterTablePanel(){

            protected void updateSignature() {
                GroovyExtractMethodDialog.this.updateSignature();
            }

            protected void doEnterAction() {
                GroovyExtractMethodDialog.this.clickDefaultButton();
            }

            protected void doCancelAction() {
                GroovyExtractMethodDialog.this.doCancelAction();
            }
        };
    }

    private static boolean validateMethod(GrMethod method, ExtractMethodInfoHelper helper) {
        ArrayList<String> conflicts = new ArrayList<String>();
        PsiClass owner = helper.getOwner();
        PsiMethod[] methods = (PsiMethod[])ArrayUtil.mergeArrays((Object[])owner.getAllMethods(), (Object[])new PsiMethod[]{method}, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        Map map = DuplicatesUtil.factorDuplicates((PsiElement[])methods, (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMethod>(){

            public int computeHashCode(PsiMethod method) {
                return method.getSignature(PsiSubstitutor.EMPTY).hashCode();
            }

            public boolean equals(PsiMethod method1, PsiMethod method2) {
                return method1.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
            }
        });
        List list = (List)map.get(method);
        if (list == null) {
            return true;
        }
        for (PsiMethod psiMethod : list) {
            if (psiMethod == method) continue;
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return true;
            }
            String message = containingClass instanceof GroovyScriptClass ? GroovyRefactoringBundle.message("method.is.already.defined.in.script", GroovyRefactoringUtil.getMethodSignature(method), CommonRefactoringUtil.htmlEmphasize((String)containingClass.getQualifiedName())) : GroovyRefactoringBundle.message("method.is.already.defined.in.class", GroovyRefactoringUtil.getMethodSignature(method), CommonRefactoringUtil.htmlEmphasize((String)containingClass.getQualifiedName()));
            conflicts.add(message);
        }
        return conflicts.size() <= 0 || GroovyExtractMethodDialog.reportConflicts(conflicts, helper.getProject());
    }

    private static boolean reportConflicts(ArrayList<String> conflicts, Project project) {
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        return conflictsDialog.showAndGet();
    }

    private void fireNameDataChanged() {
        Object[] list;
        for (Object aList : list = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChangedListener)) continue;
            ((DataChangedListener)aList).dataChanged();
        }
    }

    public void updateSignature() {
        if (this.mySignature == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        String modifier = ExtractUtil.getModifierString(this.myHelper);
        buffer.append(modifier);
        buffer.append(ExtractUtil.getTypeString(this.myHelper, true, modifier));
        String _name = this.getEnteredName();
        String name = _name == null ? "" : _name;
        ExtractUtil.appendName(buffer, name);
        buffer.append("(");
        String[] params = ExtractUtil.getParameterString(this.myHelper, false);
        if (params.length > 0) {
            String INDENT = "    ";
            buffer.append("\n");
            for (String param : params) {
                buffer.append(INDENT).append(param).append("\n");
            }
        }
        buffer.append(")");
        this.mySignature.setSignature(buffer.toString());
    }

    public ExtractMethodSettings getSettings() {
        return new MyExtractMethodSettings(this);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        Splitter splitter;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCbSpecifyType = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringBundle").getString("specify.type.label"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ComboBoxVisibilityPanel<String> comboBoxVisibilityPanel = this.myVisibilityPanel;
        jPanel2.add((Component)comboBoxVisibilityPanel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringBundle").getString("name.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        EditorTextField editorTextField = this.myNameField;
        jPanel3.add((Component)editorTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySplitter = splitter = new Splitter();
        jPanel.add((Component)splitter, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myForceReturnCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use explicit return statement");
        jCheckBox.setMnemonic('X');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jCheckBox.setFocusable(false);
        jCheckBox.setLabel("Use explicit return statement");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyExtractMethodSettings
    implements ExtractMethodSettings {
        ExtractMethodInfoHelper myHelper;
        String myEnteredName;

        public MyExtractMethodSettings(GroovyExtractMethodDialog dialog) {
            this.myHelper = dialog.getHelper();
            this.myEnteredName = dialog.getEnteredName();
        }

        @Override
        @NotNull
        public ExtractMethodInfoHelper getHelper() {
            return this.myHelper;
        }

        @Override
        public String getEnteredName() {
            return this.myEnteredName;
        }
    }

    class DataChangedListener
    implements EventListener {
        DataChangedListener() {
        }

        void dataChanged() {
            GroovyExtractMethodDialog.this.update();
        }
    }
}

