/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceFieldHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrInplaceFieldIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;

public class GrIntroduceFieldHandler
extends GrIntroduceFieldHandlerBase<GrIntroduceFieldSettings> {
    @Override
    @NotNull
    protected String getRefactoringName() {
        return IntroduceFieldHandler.REFACTORING_NAME;
    }

    @Override
    @NotNull
    protected String getHelpID() {
        return "refactoring.introduceField";
    }

    @Override
    protected void checkExpression(@NotNull GrExpression selectedExpr) {
        GrIntroduceFieldHandler.checkContainingClass(selectedExpr);
    }

    private static void checkContainingClass(PsiElement place) {
        PsiClass containingClass = PsiUtil.getContextClass(place);
        if (containingClass == null) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("cannot.introduce.field.in.script", new Object[0]));
        }
        if (containingClass.isInterface()) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("cannot.introduce.field.in.interface", new Object[0]));
        }
        if (PsiUtil.skipParentheses(place, false) == null) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("expression.contains.errors", new Object[0]));
        }
    }

    @Override
    protected void checkVariable(@NotNull GrVariable variable) throws GrRefactoringError {
        GrIntroduceFieldHandler.checkContainingClass(variable);
    }

    @Override
    protected void checkStringLiteral(@NotNull StringPartInfo info) throws GrRefactoringError {
        GrIntroduceFieldHandler.checkContainingClass(info.getLiteral());
    }

    @Override
    protected void checkOccurrences(@NotNull PsiElement[] occurrences) {
    }

    @Override
    @NotNull
    protected GrIntroduceDialog<GrIntroduceFieldSettings> getDialog(@NotNull GrIntroduceContext context) {
        return new GrIntroduceFieldDialog(context);
    }

    @Override
    public GrVariable runRefactoring(@NotNull GrIntroduceContext context, @NotNull GrIntroduceFieldSettings settings) {
        return new GrIntroduceFieldProcessor(context, settings).run();
    }

    @Override
    protected GrAbstractInplaceIntroducer<GrIntroduceFieldSettings> getIntroducer(@NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice) {
        Ref contextRef = Ref.create((Object)context);
        if (context.getStringPart() != null) {
            this.extractStringPart((Ref<GrIntroduceContext>)contextRef);
        }
        return new GrInplaceFieldIntroducer((GrIntroduceContext)contextRef.get(), choice);
    }

    @Override
    @NotNull
    protected PsiElement[] findOccurrences(@NotNull GrExpression expression, @NotNull PsiElement scope) {
        PsiElement[] occurrences = super.findOccurrences(expression, scope);
        if (GrIntroduceFieldHandler.shouldBeStatic(expression, scope)) {
            return occurrences;
        }
        ArrayList<PsiElement> filtered = new ArrayList<PsiElement>();
        for (PsiElement occurrence : occurrences) {
            if (GrIntroduceFieldHandler.shouldBeStatic(occurrence, scope)) continue;
            filtered.add(occurrence);
        }
        return (PsiElement[])ContainerUtil.toArray(filtered, (Object[])new PsiElement[filtered.size()]);
    }

    @Nullable
    static GrMember getContainer(@Nullable PsiElement place, @Nullable PsiElement scope) {
        while (place != null && place != scope) {
            if (!((place = place.getParent()) instanceof GrMember)) continue;
            return (GrMember)place;
        }
        return null;
    }

    static boolean shouldBeStatic(PsiElement expr, PsiElement clazz) {
        GrMember method = GrIntroduceFieldHandler.getContainer(expr, clazz);
        if (method == null) {
            return false;
        }
        return method.hasModifierProperty("static");
    }
}

