/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrInplaceVariableIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceLocalVariableProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyVariableValidator;

public class GrIntroduceVariableHandler
extends GrIntroduceHandlerBase<GroovyIntroduceVariableSettings, GrControlFlowOwner> {
    public static final String DUMMY_NAME = "________________xxx_________________";
    protected static final String REFACTORING_NAME = GroovyRefactoringBundle.message("introduce.variable.title", new Object[0]);
    private RangeMarker myPosition = null;

    @NotNull
    protected GrControlFlowOwner[] findPossibleScopes(GrExpression selectedExpr, GrVariable variable, StringPartInfo stringPartInfo, Editor editor) {
        GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(stringPartInfo != null ? stringPartInfo.getLiteral() : selectedExpr);
        if (scope == null) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", REFACTORING_NAME));
        }
        if (!GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(scope)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", REFACTORING_NAME));
        }
        return new GrControlFlowOwner[]{scope};
    }

    @Override
    protected void checkExpression(@NotNull GrExpression selectedExpr) {
        PsiElement parent;
        for (parent = selectedExpr.getParent(); parent != null && !(parent instanceof GroovyFileBase) && !(parent instanceof GrParameter); parent = parent.getParent()) {
        }
        if (GrIntroduceVariableHandler.checkInFieldInitializer(selectedExpr)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", new Object[0]));
        }
        if (parent instanceof GrParameter) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.method.parameters", new Object[0]));
        }
    }

    @Override
    protected void checkVariable(@NotNull GrVariable variable) throws GrRefactoringError {
        throw new GrRefactoringError(null);
    }

    @Override
    protected void checkStringLiteral(@NotNull StringPartInfo info) throws GrRefactoringError {
    }

    @Override
    protected void checkOccurrences(@NotNull PsiElement[] occurrences) {
    }

    private static boolean checkInFieldInitializer(@NotNull GrExpression expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof GrClosableBlock) {
            return false;
        }
        if (parent instanceof GrField && expr == ((GrField)parent).getInitializerGroovy()) {
            return true;
        }
        if (parent instanceof GrExpression) {
            return GrIntroduceVariableHandler.checkInFieldInitializer((GrExpression)parent);
        }
        return false;
    }

    @Override
    public GrVariable runRefactoring(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        GrVariable insertedVar = this.processExpression(context, settings);
        this.moveOffsetToPositionMarker(context.getEditor());
        return insertedVar;
    }

    private void moveOffsetToPositionMarker(Editor editor) {
        if (editor != null && this.getPositionMarker() != null) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(this.getPositionMarker().getEndOffset());
        }
    }

    protected GrInplaceVariableIntroducer getIntroducer(@NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice) {
        GrStatement anchor;
        final Ref contextRef = Ref.create((Object)context);
        if (context.getStringPart() != null) {
            this.extractStringPart((Ref<GrIntroduceContext>)contextRef);
        }
        if ((anchor = GrIntroduceVariableHandler.findAnchor(context = (GrIntroduceContext)contextRef.get(), choice == OccurrencesChooser.ReplaceChoice.ALL)).getParent() instanceof GrControlStatement) {
            this.addBraces(anchor, (Ref<GrIntroduceContext>)contextRef);
        }
        return new GrInplaceVariableIntroducer(this.getRefactoringName(), choice, (GrIntroduceContext)contextRef.get()){

            @Override
            protected GrVariable runRefactoring(GrIntroduceContext context, GroovyIntroduceVariableSettings settings, boolean processUsages) {
                return this.refactorInWriteAction((Computable<GrVariable>)((Computable)() -> processUsages ? GrIntroduceVariableHandler.this.processExpression(context, settings) : GrIntroduceVariableHandler.addVariable(context, settings)));
            }

            protected void performPostIntroduceTasks() {
                super.performPostIntroduceTasks();
                GrIntroduceVariableHandler.this.moveOffsetToPositionMarker(((GrIntroduceContext)contextRef.get()).getEditor());
            }
        };
    }

    private static GrVariable addVariable(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        GrStatement anchor = GrIntroduceVariableHandler.findAnchor(context, settings.replaceAllOccurrences());
        PsiElement parent = anchor.getParent();
        assert (parent instanceof GrStatementOwner);
        GrVariableDeclaration generated = GrIntroduceVariableHandler.generateDeclaration(context, settings);
        GrStatement declaration = ((GrStatementOwner)parent).addStatementBefore(generated, anchor);
        declaration = (GrStatement)JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)declaration);
        return ((GrVariableDeclaration)declaration).getVariables()[0];
    }

    protected void showScopeChooser(GrControlFlowOwner[] scopes, Pass<GrControlFlowOwner> callback, Editor editor) {
    }

    @NotNull
    private static GrVariableDeclaration generateDeclaration(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        String[] stringArray;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
        if (settings.isDeclareFinal()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "final";
        } else {
            stringArray = null;
        }
        String[] modifiers = stringArray;
        GrVariableDeclaration declaration = factory.createVariableDeclaration(modifiers, "foo", settings.getSelectedType(), settings.getName());
        GrIntroduceVariableHandler.generateInitializer(context, declaration.getVariables()[0]);
        return declaration;
    }

    @NotNull
    private GrVariable processExpression(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        GrVariableDeclaration varDecl = GrIntroduceVariableHandler.generateDeclaration(context, settings);
        if (context.getStringPart() != null) {
            GrExpression ref = context.getStringPart().replaceLiteralWithConcatenation(DUMMY_NAME);
            return this.doProcessExpression(context, settings, varDecl, new PsiElement[]{ref}, ref, true);
        }
        GrExpression expression = context.getExpression();
        assert (expression != null);
        return this.doProcessExpression(context, settings, varDecl, context.getOccurrences(), expression, true);
    }

    private GrVariable doProcessExpression(final @NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings, @NotNull GrVariableDeclaration varDecl, @NotNull PsiElement[] elements, @NotNull GrExpression expression, boolean processUsages) {
        return new GrIntroduceLocalVariableProcessor(context, settings, elements, expression, processUsages){

            @Override
            protected void refreshPositionMarker(PsiElement e) {
                GrIntroduceVariableHandler.this.refreshPositionMarker(context.getEditor().getDocument().createRangeMarker(e.getTextRange()));
            }
        }.processExpression(varDecl);
    }

    @NotNull
    private static GrExpression generateInitializer(@NotNull GrIntroduceContext context, @NotNull GrVariable variable) {
        GrExpression initializer = context.getStringPart() != null ? context.getStringPart().createLiteralFromSelected() : context.getExpression();
        GrExpression dummyInitializer = variable.getInitializerGroovy();
        assert (dummyInitializer != null);
        return dummyInitializer.replaceWithExpression(initializer, true);
    }

    void refreshPositionMarker(RangeMarker marker) {
        this.myPosition = marker;
    }

    private RangeMarker getPositionMarker() {
        return this.myPosition;
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Override
    @NotNull
    protected String getHelpID() {
        return "refactoring.introduceVariable";
    }

    @NotNull
    protected GroovyIntroduceVariableDialog getDialog(@NotNull GrIntroduceContext context) {
        GroovyVariableValidator validator = new GroovyVariableValidator(context);
        return new GroovyIntroduceVariableDialog(context, validator);
    }
}

