/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GrTypeComboBox
extends ComboBox {
    private static final Logger LOG = Logger.getInstance(GrTypeComboBox.class);

    public static GrTypeComboBox createTypeComboBoxWithDefType(@Nullable PsiType type, @NotNull PsiElement context) {
        return new GrTypeComboBox(type, null, true, context, false);
    }

    public static GrTypeComboBox createTypeComboBoxFromExpression(@NotNull GrExpression expression) {
        return GrTypeComboBox.createTypeComboBoxFromExpression(expression, false);
    }

    public static GrTypeComboBox createTypeComboBoxFromExpression(@NotNull GrExpression expression, boolean selectDef) {
        PsiElement resolved;
        PsiType type = expression.getType();
        if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof PsiClass) {
            type = TypesUtil.createJavaLangClassType(type, expression.getProject(), expression.getResolveScope());
        }
        if (GroovyRefactoringUtil.isDiamondNewOperator(expression)) {
            LOG.assertTrue(expression instanceof GrNewExpression);
            PsiType expected = PsiImplUtil.inferExpectedTypeForDiamond(expression);
            return new GrTypeComboBox(type, expected, expected == null, expression, selectDef);
        }
        if (type == PsiType.NULL) {
            type = PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
        }
        return new GrTypeComboBox(type, null, true, expression, selectDef);
    }

    public static GrTypeComboBox createEmptyTypeComboBox() {
        return new GrTypeComboBox(null, null, false, null, false);
    }

    private GrTypeComboBox(@Nullable PsiType type, @Nullable PsiType min, boolean createDef, @Nullable PsiElement context, boolean selectDef) {
        LOG.assertTrue(min == null || context != null);
        LOG.assertTrue(type == null || context != null);
        if (type instanceof PsiDisjunctionType) {
            type = ((PsiDisjunctionType)type).getLeastUpperBound();
        }
        Map<Object, Object> types = Collections.emptyMap();
        if (type != null) {
            types = GrTypeComboBox.getCompatibleTypeNames(type, min, context);
        }
        if (createDef || types.isEmpty()) {
            this.addItem(new PsiTypeItem(null));
        }
        if (type != null && type.equalsToText("java.math.BigDecimal")) {
            this.addItem(new PsiTypeItem(type));
            types.remove("java.math.BigDecimal");
            this.addItem(new PsiTypeItem((PsiType)PsiType.DOUBLE));
        }
        for (String string : types.keySet()) {
            this.addItem(new PsiTypeItem((PsiType)types.get(string)));
        }
        if (!selectDef && createDef && this.getItemCount() > 1) {
            this.setSelectedIndex(1);
        }
    }

    public void addClosureTypesFrom(@Nullable PsiType type, @NotNull PsiElement context) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiType cl = type == null || type == PsiType.NULL ? factory.createTypeFromText("groovy.lang.Closure", context) : factory.createTypeFromText("groovy.lang.Closure<" + type.getCanonicalText() + '>', context);
        this.addItem(new PsiTypeItem(cl, true));
    }

    @Nullable
    public PsiType getSelectedType() {
        Object selected = this.getSelectedItem();
        assert (selected instanceof PsiTypeItem);
        return ((PsiTypeItem)selected).getType();
    }

    public boolean isClosureSelected() {
        return ((PsiTypeItem)this.getSelectedItem()).isClosure();
    }

    private static Map<String, PsiType> getCompatibleTypeNames(@NotNull PsiType type, @Nullable PsiType min, @NotNull PsiElement context) {
        if (type instanceof PsiDisjunctionType) {
            type = ((PsiDisjunctionType)type).getLeastUpperBound();
        }
        if (min != null && !TypesUtil.isAssignable(min, type, context)) {
            min = null;
        }
        LinkedHashMap<String, PsiType> map = new LinkedHashMap<String, PsiType>();
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
        if (unboxed != null) {
            type = unboxed;
        }
        LinkedHashSet<PsiType> set = new LinkedHashSet<PsiType>();
        set.add(type);
        while (!set.isEmpty()) {
            PsiType cur = (PsiType)set.iterator().next();
            set.remove(cur);
            if (map.containsValue(cur) || min != null && !TypesUtil.isAssignable(min, cur, context)) continue;
            if (GrTypeComboBox.isPartiallySubstituted(cur)) {
                LOG.assertTrue(cur instanceof PsiClassType);
                PsiClassType rawType = ((PsiClassType)cur).rawType();
                map.put(rawType.getPresentableText(), (PsiType)rawType);
            } else {
                map.put(cur.getPresentableText(), cur);
            }
            for (PsiType superType : cur.getSuperTypes()) {
                if (map.containsValue(superType)) continue;
                set.add(superType);
            }
        }
        return map;
    }

    private static boolean isPartiallySubstituted(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
        PsiClass clazz = classResolveResult.getElement();
        if (clazz == null) {
            return false;
        }
        return clazz.getTypeParameters().length != parameters.length;
    }

    public static void registerUpDownHint(JComponent component, final GrTypeComboBox combo) {
        AnAction arrow = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    GrTypeComboBox.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0), combo);
                }
            }
        };
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 512), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 512), null);
        arrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), component);
    }

    private static void scrollBy(int delta, GrTypeComboBox combo) {
        if (delta == 0) {
            return;
        }
        int size = combo.getModel().getSize();
        int next = combo.getSelectedIndex() + delta;
        if (next < 0 || next >= size) {
            if (!UISettings.getInstance().getCycleScrolling()) {
                return;
            }
            next = (next + size) % size;
        }
        combo.setSelectedIndex(next);
    }

    private static class PsiTypeItem {
        @Nullable
        private final PsiType myType;
        private final boolean isClosure;

        private PsiTypeItem(PsiType type) {
            this(type, false);
        }

        private PsiTypeItem(@Nullable PsiType type, boolean closure) {
            this.myType = type;
            this.isClosure = closure;
        }

        @Nullable
        public PsiType getType() {
            return this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiTypeItem that = (PsiTypeItem)o;
            return !(this.myType == null ? that.myType != null : !this.myType.equals(that.myType));
        }

        public int hashCode() {
            return this.myType == null ? 0 : this.myType.hashCode();
        }

        public String toString() {
            return this.myType == null ? "def" : this.myType.getPresentableText();
        }

        public boolean isClosure() {
            return this.isClosure;
        }
    }
}

