/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;
import org.jetbrains.plugins.groovy.transformations.dsl.MemberBuilder;

public class TransformationContextImpl
implements TransformationContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final JavaPsiFacade myPsiFacade;
    @NotNull
    private final GrTypeDefinition myCodeClass;
    @NotNull
    private final PsiClassType myClassType;
    private final LinkedList<PsiMethod> myMethods = ContainerUtil.newLinkedList();
    private final Collection<GrField> myFields = ContainerUtil.newArrayList();
    private final Collection<PsiClass> myInnerClasses = ContainerUtil.newArrayList();
    private final List<PsiClassType> myImplementsTypes = ContainerUtil.newArrayList();
    private final List<PsiClassType> myExtendsTypes = ContainerUtil.newArrayList();
    private final MemberBuilder myMemberBuilder = new MemberBuilder(this);
    private final Map<String, Set<MethodSignature>> mySignaturesCache = FactoryMap.createMap(name -> {
        THashSet result = new THashSet(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        for (PsiMethod existingMethod : this.myMethods) {
            if (!existingMethod.getName().equals(name)) continue;
            result.add((Object)existingMethod.getSignature(PsiSubstitutor.EMPTY));
        }
        return result;
    });

    public TransformationContextImpl(@NotNull GrTypeDefinition codeClass) {
        this.myProject = codeClass.getProject();
        this.myPsiManager = codeClass.getManager();
        this.myPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        this.myCodeClass = codeClass;
        this.myClassType = this.getPsiFacade().getElementFactory().createType((PsiClass)this.getCodeClass());
        ContainerUtil.addAll(this.myFields, (Object[])codeClass.getCodeFields());
        ContainerUtil.addAll(this.myMethods, (Iterable)ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])codeClass.getCodeMethods(), m -> GrClassImplUtil.expandReflectedMethods(m))));
        ContainerUtil.addAll(this.myInnerClasses, (Object[])codeClass.getCodeInnerClasses());
        ContainerUtil.addAll(this.myImplementsTypes, (Object[])GrClassImplUtil.getReferenceListTypes(codeClass.getImplementsClause()));
        ContainerUtil.addAll(this.myExtendsTypes, (Object[])GrClassImplUtil.getReferenceListTypes(codeClass.getExtendsClause()));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        return this.myPsiManager;
    }

    @Override
    @NotNull
    public JavaPsiFacade getPsiFacade() {
        return this.myPsiFacade;
    }

    @Override
    @NotNull
    public GrTypeDefinition getCodeClass() {
        return this.myCodeClass;
    }

    @Override
    @NotNull
    public PsiClassType getClassType() {
        return this.myClassType;
    }

    @Override
    @NotNull
    public Collection<GrField> getFields() {
        return this.myFields;
    }

    @Override
    @NotNull
    public Collection<PsiMethod> getMethods() {
        return this.myMethods;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getInnerClasses() {
        return this.myInnerClasses;
    }

    @Override
    @NotNull
    public List<PsiClassType> getImplementsTypes() {
        return this.myImplementsTypes;
    }

    @Override
    @NotNull
    public List<PsiClassType> getExtendsTypes() {
        return this.myExtendsTypes;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myCodeClass.getName();
    }

    @Override
    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this.getCodeClass(), this.getExtendsListTypesArray());
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        return PsiImplUtil.getAnnotation((PsiModifierListOwner)this.getCodeClass(), fqn);
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass) {
        if (this.getManager().areElementsEquivalent((PsiElement)this.getCodeClass(), (PsiElement)baseClass)) {
            return false;
        }
        if (this.getCodeClass().isInterface() && !baseClass.isInterface()) {
            return false;
        }
        for (PsiClassType superType : this.getSuperTypes()) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            if (this.getManager().areElementsEquivalent((PsiElement)superClass, (PsiElement)baseClass)) {
                return true;
            }
            if (!superClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<PsiMethod> findMethodsByName(@NotNull String name, boolean checkBases) {
        PsiClass aClass;
        List methods = ContainerUtil.filter(this.myMethods, m -> name.equals(m.getName()));
        if (checkBases && (aClass = this.getSuperClass()) != null) {
            ContainerUtil.addAll((Collection)ContainerUtil.newArrayList((Iterable)methods), (Object[])aClass.findMethodsByName(name, true));
        }
        return methods;
    }

    private void doAddMethod(@NotNull PsiMethod method, boolean prepend) {
        if (method instanceof GrLightMethodBuilder) {
            ((GrLightMethodBuilder)method).setContainingClass(this.myCodeClass);
        } else if (method instanceof LightMethodBuilder) {
            ((LightMethodBuilder)method).setContainingClass((PsiClass)this.myCodeClass);
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        Set<MethodSignature> signatures = this.mySignaturesCache.get(method.getName());
        if (signatures.add(signature)) {
            if (prepend) {
                this.myMethods.addFirst(method);
            } else {
                this.myMethods.addLast(method);
            }
        }
    }

    @Override
    public void addMethod(@NotNull PsiMethod method, boolean prepend) {
        for (PsiMethod psiMethod : GrClassImplUtil.expandReflectedMethods(method)) {
            this.doAddMethod(psiMethod, prepend);
        }
    }

    @Override
    public void addMethods(@NotNull PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            this.addMethod(method);
        }
    }

    @Override
    public void addMethods(@NotNull Collection<? extends PsiMethod> methods) {
        for (PsiMethod psiMethod : methods) {
            this.addMethod(psiMethod);
        }
    }

    @Override
    public void removeMethod(@NotNull PsiMethod method) {
        Set<MethodSignature> signatures = this.mySignaturesCache.get(method.getName());
        for (PsiMethod psiMethod : GrClassImplUtil.expandReflectedMethods(method)) {
            MethodSignature signature = psiMethod.getSignature(PsiSubstitutor.EMPTY);
            if (!signatures.remove(signature)) continue;
            this.myMethods.removeIf(m -> MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)signature, (Object)m.getSignature(PsiSubstitutor.EMPTY)));
        }
    }

    @Override
    public void addField(@NotNull GrField field) {
        if (field instanceof GrLightField) {
            ((GrLightField)field).setContainingClass(this.getCodeClass());
        }
        this.myFields.add(field);
    }

    @Override
    public void addInnerClass(@NotNull PsiClass innerClass) {
        if (innerClass instanceof LightPsiClassBuilder) {
            ((LightPsiClassBuilder)innerClass).setContainingClass((PsiClass)this.getCodeClass());
        }
        this.myInnerClasses.add(innerClass);
    }

    @Override
    public void setSuperType(@NotNull String fqn) {
        this.setSuperType(TypesUtil.createType(fqn, this.getCodeClass()));
    }

    @Override
    public void setSuperType(@NotNull PsiClassType type) {
        if (!this.getCodeClass().isInterface()) {
            this.myExtendsTypes.clear();
            this.myExtendsTypes.add(type);
        }
    }

    @Override
    public void addInterface(@NotNull String fqn) {
        this.addInterface(TypesUtil.createType(fqn, this.getCodeClass()));
    }

    @Override
    public void addInterface(@NotNull PsiClassType type) {
        (!this.getCodeClass().isInterface() || this.getCodeClass().isTrait() ? this.myImplementsTypes : this.myExtendsTypes).add(type);
    }

    @Override
    @NotNull
    public MemberBuilder getMemberBuilder() {
        return this.myMemberBuilder;
    }

    @NotNull
    private GrField[] getFieldsArray() {
        return this.getFields().toArray(GrField.EMPTY_ARRAY);
    }

    @NotNull
    private PsiMethod[] getMethodsArray() {
        return this.getMethods().toArray(PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    private PsiClass[] getInnerClassesArray() {
        return this.getInnerClasses().toArray(PsiClass.EMPTY_ARRAY);
    }

    @NotNull
    private PsiClassType[] getImplementsListTypesArray() {
        return this.getImplementsTypes().toArray(PsiClassType.EMPTY_ARRAY);
    }

    @NotNull
    private PsiClassType[] getExtendsListTypesArray() {
        if (this.getExtendsTypes().size() > 1 && !this.getCodeClass().isInterface()) {
            throw new IllegalStateException("More than one type supertype for non-interface");
        }
        return this.getExtendsTypes().toArray(PsiClassType.EMPTY_ARRAY);
    }

    @NotNull
    TransformationResult getTransformationResult() {
        return new TransformationResult(this.getMethodsArray(), this.getFieldsArray(), this.getInnerClassesArray(), this.getImplementsListTypesArray(), this.getExtendsListTypesArray());
    }
}

