/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightCacheKey<T> {
    private final Key<Pair<Long, T>> key = Key.create((String)this.toString());

    @Nullable
    public T getCachedValue(PsiElement holder) {
        Pair userData = (Pair)holder.getUserData(this.key);
        if (userData == null || this.getModificationCount(holder) != ((Long)userData.first).longValue()) {
            return null;
        }
        return (T)userData.second;
    }

    protected long getModificationCount(PsiElement holder) {
        return holder.getManager().getModificationTracker().getModificationCount();
    }

    public T putCachedValue(PsiElement holder, @NotNull T value) {
        long modificationCount = this.getModificationCount(holder);
        Pair pair = Pair.create((Object)modificationCount, value);
        Pair puttedValue = (Pair)((UserDataHolderEx)holder).putUserDataIfAbsent(this.key, (Object)pair);
        if (puttedValue == pair) {
            return value;
        }
        if ((Long)puttedValue.first == modificationCount) {
            return (T)puttedValue.second;
        }
        if (((UserDataHolderEx)holder).replace(this.key, (Object)puttedValue, (Object)pair)) {
            return value;
        }
        Pair createdFromOtherThreadValue = (Pair)holder.getUserData(this.key);
        assert ((Long)createdFromOtherThreadValue.first == modificationCount);
        return (T)createdFromOtherThreadValue.second;
    }

    public static <T> LightCacheKey<T> create() {
        return new LightCacheKey<T>();
    }

    public static <T> LightCacheKey<T> createByJavaModificationCount() {
        return new LightCacheKey<T>(){

            @Override
            protected long getModificationCount(PsiElement holder) {
                return holder.getManager().getModificationTracker().getJavaStructureModificationCount();
            }
        };
    }

    public static <T> LightCacheKey<T> createByFileModificationCount() {
        return new LightCacheKey<T>(){

            @Override
            protected long getModificationCount(PsiElement holder) {
                return holder.getContainingFile().getModificationStamp();
            }
        };
    }
}

