/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.EllipseSolver;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.VdElement;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.google.common.collect.ImmutableMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;

class VdPath
extends VdElement {
    private static final Logger LOGGER = Logger.getLogger(VdPath.class.getSimpleName());
    private static final String PATH_ID = "android:name";
    private static final String PATH_DESCRIPTION = "android:pathData";
    private static final String PATH_FILL = "android:fillColor";
    private static final String PATH_FILL_OPACITY = "android:fillAlpha";
    private static final String PATH_FILL_TYPE = "android:fillType";
    private static final String PATH_STROKE = "android:strokeColor";
    private static final String PATH_STROKE_OPACTIY = "android:strokeAlpha";
    private static final String FILL_TYPE_EVEN_ODD = "evenOdd";
    private static final String PATH_STROKE_WIDTH = "android:strokeWidth";
    private static final String PATH_TRIM_START = "android:trimPathStart";
    private static final String PATH_TRIM_END = "android:trimPathEnd";
    private static final String PATH_TRIM_OFFSET = "android:trimPathOffset";
    private static final String PATH_STROKE_LINECAP = "android:strokeLineCap";
    private static final String PATH_STROKE_LINEJOIN = "android:strokeLineJoin";
    private static final String PATH_STROKE_MITERLIMIT = "android:strokeMiterLimit";
    private static final String LINECAP_BUTT = "butt";
    private static final String LINECAP_ROUND = "round";
    private static final String LINECAP_SQUARE = "square";
    private static final String LINEJOIN_MITER = "miter";
    private static final String LINEJOIN_ROUND = "round";
    private static final String LINEJOIN_BEVEL = "bevel";
    private Node[] mNodeList = null;
    private int mStrokeColor = 0;
    private int mFillColor = 0;
    private float mStrokeWidth = 0.0f;
    private int mStrokeLineCap = 0;
    private int mStrokeLineJoin = 0;
    private float mStrokeMiterlimit = 4.0f;
    private float mStrokeAlpha = 1.0f;
    private float mFillAlpha = 1.0f;
    private int mFillType = 1;
    private float mTrimPathStart = 0.0f;
    private float mTrimPathEnd = 1.0f;
    private float mTrimPathOffset = 0.0f;

    VdPath() {
    }

    private void toPath(Path2D path) {
        path.reset();
        if (this.mNodeList != null) {
            VdNodeRender.createPath(this.mNodeList, path);
        }
    }

    private static int calculateColor(String value) {
        int ret;
        int len = value.length();
        int k = 0;
        switch (len) {
            case 7: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                ret |= 0xFF000000;
                break;
            }
            case 9: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                break;
            }
            case 4: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                k |= (ret >> 8 & 0xF) * 0x110000;
                k |= (ret >> 4 & 0xF) * 4352;
                k |= (ret & 0xF) * 17;
                ret = k | 0xFF000000;
                break;
            }
            case 5: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                k |= (ret >> 12 & 0xF) * 0x11000000;
                k |= (ret >> 8 & 0xF) * 0x110000;
                k |= (ret >> 4 & 0xF) * 4352;
                k |= (ret & 0xF) * 17;
                ret = k;
                break;
            }
            default: {
                return -16777216;
            }
        }
        return ret;
    }

    private void setNameValue(String name, String value) {
        if (PATH_DESCRIPTION.equals(name)) {
            this.mNodeList = PathParser.parsePath(value);
        } else if (PATH_ID.equals(name)) {
            this.mName = value;
        } else if (PATH_FILL.equals(name)) {
            this.mFillColor = VdPath.calculateColor(value);
        } else if (PATH_FILL_TYPE.equals(name)) {
            this.mFillType = VdPath.parseFillType(value);
        } else if (PATH_STROKE.equals(name)) {
            this.mStrokeColor = VdPath.calculateColor(value);
        } else if (PATH_FILL_OPACITY.equals(name)) {
            this.mFillAlpha = Float.parseFloat(value);
        } else if (PATH_STROKE_OPACTIY.equals(name)) {
            this.mStrokeAlpha = Float.parseFloat(value);
        } else if (PATH_STROKE_WIDTH.equals(name)) {
            this.mStrokeWidth = Float.parseFloat(value);
        } else if (PATH_TRIM_START.equals(name)) {
            this.mTrimPathStart = Float.parseFloat(value);
        } else if (PATH_TRIM_END.equals(name)) {
            this.mTrimPathEnd = Float.parseFloat(value);
        } else if (PATH_TRIM_OFFSET.equals(name)) {
            this.mTrimPathOffset = Float.parseFloat(value);
        } else if (PATH_STROKE_LINECAP.equals(name)) {
            if (LINECAP_BUTT.equals(value)) {
                this.mStrokeLineCap = 0;
            } else if ("round".equals(value)) {
                this.mStrokeLineCap = 1;
            } else if (LINECAP_SQUARE.equals(value)) {
                this.mStrokeLineCap = 2;
            }
        } else if (PATH_STROKE_LINEJOIN.equals(name)) {
            if (LINEJOIN_MITER.equals(value)) {
                this.mStrokeLineJoin = 0;
            } else if ("round".equals(value)) {
                this.mStrokeLineJoin = 1;
            } else if (LINEJOIN_BEVEL.equals(value)) {
                this.mStrokeLineJoin = 2;
            }
        } else if (PATH_STROKE_MITERLIMIT.equals(name)) {
            this.mStrokeMiterlimit = Float.parseFloat(value);
        } else {
            LOGGER.log(Level.WARNING, ">>>>>> DID NOT UNDERSTAND ! \"" + name + "\" <<<<");
        }
    }

    private static int parseFillType(String value) {
        if (FILL_TYPE_EVEN_ODD.equalsIgnoreCase(value)) {
            return 0;
        }
        return 1;
    }

    private static int applyAlpha(int color, float alpha) {
        int alphaBytes = color >> 24 & 0xFF;
        color &= 0xFFFFFF;
        return color |= (int)((float)alphaBytes * alpha) << 24;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform currentMatrix, float scaleX, float scaleY) {
        Path2D.Double path2d = new Path2D.Double(this.mFillType);
        this.toPath(path2d);
        g.setTransform(new AffineTransform());
        g.scale(scaleX, scaleY);
        g.transform(currentMatrix);
        if (this.mFillColor != 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color fillColor = new Color(VdPath.applyAlpha(this.mFillColor, this.mFillAlpha), true);
            g.setColor(fillColor);
            g.fill(path2d);
        }
        if (this.mStrokeColor != 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke stroke = new BasicStroke(this.mStrokeWidth, this.mStrokeLineCap, this.mStrokeLineJoin, this.mStrokeMiterlimit);
            g.setStroke(stroke);
            Color strokeColor = new Color(VdPath.applyAlpha(this.mStrokeColor, this.mStrokeAlpha), true);
            g.setColor(strokeColor);
            g.draw(path2d);
        }
    }

    @Override
    public void parseAttributes(NamedNodeMap attributes) {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.item(i).getNodeName();
            String value = attributes.item(i).getNodeValue();
            this.setNameValue(name, value);
        }
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    public String toString() {
        return "Path: Name: " + this.mName + " Node: " + this.mNodeList.toString() + " mFillColor: " + Integer.toHexString(this.mFillColor) + " mFillAlpha:" + this.mFillAlpha + " mFillType:" + this.mFillType + " mStrokeColor:" + Integer.toHexString(this.mStrokeColor) + " mStrokeWidth:" + this.mStrokeWidth + " mStrokeAlpha:" + this.mStrokeAlpha;
    }

    public static class Node {
        private char mType;
        private float[] mParams;
        private static final char INIT_TYPE = ' ';
        private static final ImmutableMap<Character, Integer> commandStepMap = ImmutableMap.builder().put((Object)Character.valueOf('z'), (Object)2).put((Object)Character.valueOf('Z'), (Object)2).put((Object)Character.valueOf('m'), (Object)2).put((Object)Character.valueOf('M'), (Object)2).put((Object)Character.valueOf('l'), (Object)2).put((Object)Character.valueOf('L'), (Object)2).put((Object)Character.valueOf('t'), (Object)2).put((Object)Character.valueOf('T'), (Object)2).put((Object)Character.valueOf('h'), (Object)1).put((Object)Character.valueOf('H'), (Object)1).put((Object)Character.valueOf('v'), (Object)1).put((Object)Character.valueOf('V'), (Object)1).put((Object)Character.valueOf('c'), (Object)6).put((Object)Character.valueOf('C'), (Object)6).put((Object)Character.valueOf('s'), (Object)4).put((Object)Character.valueOf('S'), (Object)4).put((Object)Character.valueOf('q'), (Object)4).put((Object)Character.valueOf('Q'), (Object)4).put((Object)Character.valueOf('a'), (Object)7).put((Object)Character.valueOf('A'), (Object)7).build();

        public char getType() {
            return this.mType;
        }

        public float[] getParams() {
            return this.mParams;
        }

        public Node(char type, float[] params) {
            this.mType = type;
            this.mParams = params;
        }

        public Node(Node n) {
            this.mType = n.mType;
            this.mParams = Arrays.copyOf(n.mParams, n.mParams.length);
        }

        public static boolean hasRelMoveAfterClose(Node[] nodes) {
            int preType = 32;
            for (Node n : nodes) {
                if ((preType == 122 || preType == 90) && n.mType == 'm') {
                    return true;
                }
                preType = n.mType;
            }
            return false;
        }

        public static String NodeListToString(Node[] nodes, String decimalPlaceString) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nodes.length; ++i) {
                Node n = nodes[i];
                stringBuilder.append(n.mType);
                int len = n.mParams.length;
                boolean implicitLineTo = false;
                char lineToType = ' ';
                if ((n.mType == 'm' || n.mType == 'M') && len > 2) {
                    implicitLineTo = true;
                    lineToType = n.mType == 'm' ? (char)'l' : 'L';
                }
                for (int j = 0; j < len; ++j) {
                    float value;
                    if (j > 0) {
                        stringBuilder.append((j & 1) == 1 ? "," : " ");
                    }
                    if (implicitLineTo && j == 2) {
                        stringBuilder.append(lineToType);
                    }
                    if ((value = n.mParams[j]) == (float)((long)value)) {
                        stringBuilder.append(String.valueOf((long)value));
                        continue;
                    }
                    DecimalFormatSymbols fractionSeparator = new DecimalFormatSymbols();
                    fractionSeparator.setDecimalSeparator('.');
                    DecimalFormat df = new DecimalFormat(decimalPlaceString, fractionSeparator);
                    df.setRoundingMode(RoundingMode.HALF_UP);
                    stringBuilder.append(df.format(value));
                }
            }
            return stringBuilder.toString();
        }

        public static void transform(AffineTransform totalTransform, Node[] nodes) {
            Point2D.Float currentPoint = new Point2D.Float();
            Point2D.Float currentSegmentStartPoint = new Point2D.Float();
            char previousType = ' ';
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i].transform(totalTransform, currentPoint, currentSegmentStartPoint, previousType);
                previousType = nodes[i].mType;
            }
        }

        private void transform(AffineTransform totalTransform, Point2D.Float currentPoint, Point2D.Float currentSegmentStartPoint, char previousType) {
            int paramsLen = this.mParams.length;
            float[] tempParams = new float[2 * paramsLen];
            float currentX = currentPoint.x;
            float currentY = currentPoint.y;
            float currentSegmentStartX = currentSegmentStartPoint.x;
            float currentSegmentStartY = currentSegmentStartPoint.y;
            int step = (Integer)commandStepMap.get((Object)Character.valueOf(this.mType));
            switch (this.mType) {
                case 'Z': 
                case 'z': {
                    currentX = currentSegmentStartX;
                    currentY = currentSegmentStartY;
                    break;
                }
                case 'C': 
                case 'L': 
                case 'M': 
                case 'Q': 
                case 'S': 
                case 'T': {
                    currentX = this.mParams[paramsLen - 2];
                    currentY = this.mParams[paramsLen - 1];
                    if (this.mType == 'M') {
                        currentSegmentStartX = currentX;
                        currentSegmentStartY = currentY;
                    }
                    totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLen / 2);
                    break;
                }
                case 'm': {
                    if (previousType == 'z' || previousType == 'Z') {
                        this.mType = (char)77;
                        this.mParams[0] = this.mParams[0] + currentSegmentStartX;
                        this.mParams[1] = this.mParams[1] + currentSegmentStartY;
                        currentSegmentStartX = this.mParams[0];
                        currentSegmentStartY = this.mParams[1];
                        for (int i = 1; i < paramsLen / step; ++i) {
                            int n = i * step + 0;
                            this.mParams[n] = this.mParams[n] + this.mParams[(i - 1) * step + 0];
                            int n2 = i * step + 1;
                            this.mParams[n2] = this.mParams[n2] + this.mParams[(i - 1) * step + 1];
                        }
                        currentX = this.mParams[paramsLen - 2];
                        currentY = this.mParams[paramsLen - 1];
                        totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLen / 2);
                        break;
                    }
                    int startIndex = 0;
                    if (previousType == ' ') {
                        int paramsLenInitialM = 2;
                        currentX = this.mParams[paramsLenInitialM - 2];
                        currentY = this.mParams[paramsLenInitialM - 1];
                        currentSegmentStartX = currentX;
                        currentSegmentStartY = currentY;
                        totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLenInitialM / 2);
                        startIndex = 1;
                    }
                    for (int i = startIndex; i < paramsLen / step; ++i) {
                        int indexX = i * step + (step - 2);
                        int indexY = i * step + (step - 1);
                        currentX += this.mParams[indexX];
                        currentY += this.mParams[indexY];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    Node.deltaTransform(totalTransform, this.mParams, 2 * startIndex, paramsLen - 2 * startIndex);
                    break;
                }
                case 'c': 
                case 'l': 
                case 'q': 
                case 's': 
                case 't': {
                    for (int i = 0; i < paramsLen / step; ++i) {
                        int indexX = i * step + (step - 2);
                        int indexY = i * step + (step - 1);
                        currentX += this.mParams[indexX];
                        currentY += this.mParams[indexY];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    Node.deltaTransform(totalTransform, this.mParams, 0, paramsLen);
                    break;
                }
                case 'H': {
                    this.mType = (char)76;
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2 + 0] = this.mParams[i];
                        tempParams[i * 2 + 1] = currentY;
                        currentX = this.mParams[i];
                    }
                    totalTransform.transform(tempParams, 0, tempParams, 0, paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'V': {
                    this.mType = (char)76;
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2 + 0] = currentX;
                        tempParams[i * 2 + 1] = this.mParams[i];
                        currentY = this.mParams[i];
                    }
                    totalTransform.transform(tempParams, 0, tempParams, 0, paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'h': {
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2 + 0] = this.mParams[i];
                        currentX += this.mParams[i];
                        tempParams[i * 2 + 1] = 0.0f;
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    this.mType = (char)108;
                    Node.deltaTransform(totalTransform, tempParams, 0, 2 * paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'v': {
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2 + 0] = 0.0f;
                        tempParams[i * 2 + 1] = this.mParams[i];
                        currentY += this.mParams[i];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    this.mType = (char)108;
                    Node.deltaTransform(totalTransform, tempParams, 0, 2 * paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'A': {
                    for (int i = 0; i < paramsLen / step; ++i) {
                        if (!Node.isTranslationOnly(totalTransform)) {
                            EllipseSolver ellipseSolver = new EllipseSolver(totalTransform, currentX, currentY, this.mParams[i * step + 0], this.mParams[i * step + 1], this.mParams[i * step + 2], this.mParams[i * step + 3], this.mParams[i * step + 4], this.mParams[i * step + 5], this.mParams[i * step + 6]);
                            this.mParams[i * step + 0] = ellipseSolver.getMajorAxis();
                            this.mParams[i * step + 1] = ellipseSolver.getMinorAxis();
                            this.mParams[i * step + 2] = ellipseSolver.getRotationDegree();
                            if (ellipseSolver.getDirectionChanged()) {
                                this.mParams[i * step + 4] = 1.0f - this.mParams[i * step + 4];
                            }
                        }
                        currentX = this.mParams[i * step + 5];
                        currentY = this.mParams[i * step + 6];
                        totalTransform.transform(this.mParams, i * step + 5, this.mParams, i * step + 5, 1);
                    }
                    break;
                }
                case 'a': {
                    for (int i = 0; i < paramsLen / step; ++i) {
                        float oldCurrentX = currentX;
                        float oldCurrentY = currentY;
                        currentX += this.mParams[i * step + 5];
                        currentY += this.mParams[i * step + 6];
                        if (Node.isTranslationOnly(totalTransform)) continue;
                        EllipseSolver ellipseSolver = new EllipseSolver(totalTransform, oldCurrentX, oldCurrentY, this.mParams[i * step + 0], this.mParams[i * step + 1], this.mParams[i * step + 2], this.mParams[i * step + 3], this.mParams[i * step + 4], oldCurrentX + this.mParams[i * step + 5], oldCurrentY + this.mParams[i * step + 6]);
                        Node.deltaTransform(totalTransform, this.mParams, i * step + 5, 2);
                        this.mParams[i * step + 0] = ellipseSolver.getMajorAxis();
                        this.mParams[i * step + 1] = ellipseSolver.getMinorAxis();
                        this.mParams[i * step + 2] = ellipseSolver.getRotationDegree();
                        if (!ellipseSolver.getDirectionChanged()) continue;
                        this.mParams[i * step + 4] = 1.0f - this.mParams[i * step + 4];
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type is not right!!!");
                }
            }
            currentPoint.setLocation(currentX, currentY);
            currentSegmentStartPoint.setLocation(currentSegmentStartX, currentSegmentStartY);
        }

        private static boolean isTranslationOnly(AffineTransform totalTransform) {
            int type = totalTransform.getType();
            return type == 0 || type == 1;
        }

        private static void deltaTransform(AffineTransform totalTransform, float[] tempParams, int offset, int paramsLen) {
            int i;
            double[] doubleArray = new double[paramsLen];
            for (i = 0; i < paramsLen; ++i) {
                doubleArray[i] = tempParams[i + offset];
            }
            totalTransform.deltaTransform(doubleArray, 0, doubleArray, 0, paramsLen / 2);
            for (i = 0; i < paramsLen; ++i) {
                tempParams[i + offset] = (float)doubleArray[i];
            }
        }
    }
}

