/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallNdkHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.ndk.AndroidSysroot;
import com.android.tools.ndk.ModuleResolveConfiguration;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.android.tools.ndk.NdkHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleWorkspace
extends AbstractProjectComponent
implements OCWorkspace {
    private static final String GRADLE_LANGUAGE_TYPE_C = "c";
    private static final String GRADLE_LANGUAGE_TYPE_CPP = "c++";
    private static final Logger LOG = Logger.getInstance(GradleWorkspace.class);
    @NotNull
    private final Map<String, OCLanguageKind> myProjectFileExtensions = Maps.newHashMap();
    @NotNull
    private Map<String, ModuleResolveConfiguration> myResolveConfigurations = ImmutableMap.of();
    @NotNull
    private NdkCompilerInfoCache myCompilerInfoCache = new NdkCompilerInfoCache();

    @NotNull
    public static GradleWorkspace getInstance(@NotNull Project project) {
        GradleWorkspace instance = (GradleWorkspace)((Object)project.getComponent(GradleWorkspace.class));
        assert (instance != null);
        return instance;
    }

    public GradleWorkspace(@NotNull Project project) {
        super(project);
        if (GradleProjectInfo.getInstance((Project)project).isBuildWithGradle()) {
            OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)true);
        }
        GradleSyncState.subscribe((Project)this.myProject, (GradleSyncListener)new GradleSyncListener.Adapter(){

            public void syncSucceeded(@NotNull Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncSkipped(@NotNull Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }
        });
    }

    private void scheduleGradleWorkspaceUpdate() {
        this.myProjectFileExtensions.clear();
        this.myResolveConfigurations = ImmutableMap.of();
        this.myCompilerInfoCache = new NdkCompilerInfoCache();
        new Task.Backgroundable(this.myProject, "Resolving C/C++ Configurations", false){

            public void run(@NotNull ProgressIndicator indicator) {
                GradleWorkspace.this.updateGradleWorkspace(indicator);
            }
        }.queue();
    }

    private void logProjectInfo() {
        String gradleModelVersion = "UNKNOWN";
        GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
        if (gradleVersion != null) {
            gradleModelVersion = gradleVersion.toString();
        }
        String ndkVersion = "UNKNOWN";
        try {
            File ndkPath = this.getNdkPath();
            if (ndkPath != null) {
                ndkVersion = NdkHelper.getNdkVersion(ndkPath);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        LOG.info(String.format("Project settings: Gradle model version=%s, NDK version=%s", gradleModelVersion, ndkVersion));
    }

    private void updateGradleWorkspace(@NotNull ProgressIndicator indicator) {
        boolean newDisableLanguageSupport;
        boolean isValidNdkProject;
        indicator.setIndeterminate(true);
        String incompatibleModelVersion = GradleWorkspace.getModelVersionIfIncompatible(this.myProject);
        boolean isNdkSpecified = this.isNdkDefined() && SdkPaths.validateAndroidNdk((File)this.getNdkPath(), (boolean)false).success;
        HashMap projectResolveConfigurations = Maps.newHashMap();
        ArrayList nativeAppModules = Lists.newArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            ImmutableMap moduleFileExtensions;
            Map<String, ModuleResolveConfiguration> moduleResolveConfigurations;
            AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
            NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)module);
            if (ndkModuleModel != null) {
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, ndkModuleModel);
                moduleFileExtensions = GradleWorkspace.getFileExtensions(ndkModuleModel);
            } else {
                if (androidModel == null) continue;
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
                moduleFileExtensions = ImmutableMap.of();
            }
            if (androidModel != null && !moduleResolveConfigurations.isEmpty()) {
                nativeAppModules.add(module);
            }
            if (!moduleResolveConfigurations.isEmpty()) {
                if (incompatibleModelVersion != null) {
                    GradleWorkspace.addModelVersionIncompatibilityNotification(incompatibleModelVersion, this.myProject);
                    return;
                }
                if (!isNdkSpecified) {
                    GradleWorkspace.addNdkNotSpecifiedNotification(this.myProject, this.isNdkDefined());
                    return;
                }
            }
            projectResolveConfigurations.putAll(moduleResolveConfigurations);
            this.myProjectFileExtensions.putAll((Map<String, OCLanguageKind>)moduleFileExtensions);
        }
        this.myResolveConfigurations = GradleWorkspace.getValidConfigurations(projectResolveConfigurations);
        boolean bl = isValidNdkProject = !this.myResolveConfigurations.isEmpty();
        if (isValidNdkProject) {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_CPP_SYNC_COMPLETED));
            this.logProjectInfo();
        }
        boolean bl2 = newDisableLanguageSupport = !isValidNdkProject;
        if ((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false) != newDisableLanguageSupport) {
            NdkHelper.disableCppLanguageSupport(this.myProject, newDisableLanguageSupport);
            if (newDisableLanguageSupport) {
                LOG.warn("NDK support for project '" + this.myProject.getName() + "' is disabled because the project doesn't contain any valid native configurations.");
            }
        }
        TransactionGuard.getInstance().submitTransactionAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            OCWorkspaceModificationTrackers trackers = OCWorkspaceModificationTrackers.getInstance((Project)this.myProject);
            trackers.getProjectsListTracker().incModificationCount();
            trackers.getSourceFilesListTracker().incModificationCount();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                trackers.getBuildSettingsChangesTracker().incModificationCount();
            }
        }));
        NdkProjectInfo projectInfo = NdkProjectInfo.get((Project)this.myProject);
        projectInfo.setHasNdkModules(!nativeAppModules.isEmpty());
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            IdeAndroidProject androidProject;
            String version;
            AndroidModuleModel androidModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
            if (androidFacet == null || (androidModel = AndroidModuleModel.get((AndroidFacet)androidFacet)) == null || (version = GradleWorkspace.getModelVersionIfIncompatible((AndroidProject)(androidProject = androidModel.getAndroidProject()))) == null) continue;
            return version;
        }
        return null;
    }

    private static void addModelVersionIncompatibilityNotification(@NotNull String modelVersion, @NotNull Project project) {
        String text = String.format("Android plugin version %1$s is not compatible with the NDK support. ", modelVersion) + "Please use the experimental plugin.";
        GradleSyncMessages.getInstance((Project)project).report(new SyncMessage("Gradle Sync Issues", MessageType.WARNING, new String[]{text}));
        String title = "Incompatible Android Plugin Version";
        AndroidNotification.getInstance((Project)project).showBalloon(title, text, NotificationType.WARNING);
    }

    private static void addNdkNotSpecifiedNotification(@NotNull Project project, boolean isNdkDefined) {
        InstallNdkHyperlink downloadLink = new InstallNdkHyperlink();
        String text = String.format("Android NDK location is not %1$s.", isNdkDefined ? "valid" : "specified");
        AndroidNotification.getInstance((Project)project).showBalloon("Project Sync Error", text, NotificationType.ERROR, new NotificationHyperlink[]{downloadLink});
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull AndroidModuleModel androidModel) {
        HashMap configurations = Maps.newHashMap();
        IdeAndroidProject androidProject = androidModel.getAndroidProject();
        Map<String, NativeToolchain> toolchains = GradleWorkspace.getToolchainsByName((AndroidProject)androidProject);
        for (Variant variant : androidProject.getVariants()) {
            Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, (AndroidProject)androidProject);
            for (NativeLibrary library : nativeLibraries) {
                NativeToolchain toolchain = toolchains.get(library.getToolchainName());
                String key = GradleWorkspace.getResolvedConfigurationKey(androidModel, variant, library);
                if (toolchain == null || configurations.containsKey(key)) continue;
                ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, androidModel.getRootDirPath(), compilerInfoCache, library, toolchain);
                configurations.put(key, configuration);
            }
        }
        return configurations;
    }

    @NotNull
    private static Map<String, NativeToolchain> getToolchainsByName(@NotNull AndroidProject androidProject) {
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            return Collections.emptyMap();
        }
        HashMap toolchains = Maps.newHashMap();
        for (NativeToolchain toolchain : androidProject.getNativeToolchains()) {
            toolchains.put(toolchain.getName(), toolchain);
        }
        return toolchains;
    }

    private static String getResolvedConfigurationKey(AndroidModuleModel androidModel, Variant variant, NativeLibrary library) {
        return androidModel.getModuleName() + variant.getName() + library.getAbi();
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NdkModuleModel ndkModuleModel) {
        HashMap configurations = Maps.newHashMap();
        for (NdkModuleModel.NdkVariant variant : ndkModuleModel.getVariants()) {
            for (NativeArtifact artifact : variant.getArtifacts()) {
                NativeToolchain toolchain = ndkModuleModel.findToolchain(artifact.getToolChain());
                if (toolchain == null) continue;
                for (NativeFolder folder : artifact.getSourceFolders()) {
                    for (String settingsName : folder.getPerLanguageSettings().values()) {
                        File workingDirectory;
                        String key;
                        NativeSettings settings = ndkModuleModel.findSettings(settingsName);
                        if (settings == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModuleModel, folder)))) continue;
                        ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, workingDirectory, compilerInfoCache, toolchain, artifact, settings);
                        configurations.put(key, configuration);
                    }
                }
                for (NativeFile file : artifact.getSourceFiles()) {
                    File workingDirectory;
                    String key;
                    NativeSettings settings = ndkModuleModel.findSettings(file.getSettingsName());
                    if (settings == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModuleModel, file)))) continue;
                    ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, workingDirectory, compilerInfoCache, toolchain, artifact, settings);
                    configurations.put(key, configuration);
                }
            }
        }
        return configurations;
    }

    @NotNull
    private static String getResolvedConfigurationKey(@NotNull NativeArtifact artifact, @NotNull NativeToolchain toolchain, @NotNull NativeSettings settings, @NotNull File workingDirectory) {
        return artifact.getName() + toolchain.getName() + settings.getName() + FileUtilRt.toSystemIndependentName((String)workingDirectory.getPath());
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull NdkModuleModel ndkModuleModel, @NotNull NativeFile nativeFile) {
        File workingDirectory = null;
        if (ndkModuleModel.modelVersionIsAtLeast("2.0.0")) {
            workingDirectory = nativeFile.getWorkingDirectory();
        }
        if (workingDirectory != null) {
            return workingDirectory;
        }
        return ndkModuleModel.getRootDirPath();
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull NdkModuleModel ndkModuleModel, @NotNull NativeFolder nativeFolder) {
        File workingDirectory = null;
        if (ndkModuleModel.modelVersionIsAtLeast("2.0.0")) {
            workingDirectory = nativeFolder.getWorkingDirectory();
        }
        if (workingDirectory != null) {
            return workingDirectory;
        }
        return ndkModuleModel.getRootDirPath();
    }

    @NotNull
    private static Map<String, OCLanguageKind> getFileExtensions(@NotNull NdkModuleModel ndkModuleModel) {
        HashMap fileExtensions = Maps.newHashMap();
        for (Map.Entry entry : ndkModuleModel.getAndroidProject().getFileExtensions().entrySet()) {
            String fileExtension = (String)entry.getKey();
            String languageType = (String)entry.getValue();
            OCLanguageKind languageKind = null;
            if (GRADLE_LANGUAGE_TYPE_C.equals(languageType)) {
                languageKind = OCLanguageKind.C;
            } else if (GRADLE_LANGUAGE_TYPE_CPP.equals(languageType)) {
                languageKind = OCLanguageKind.CPP;
            }
            if (languageKind == null) {
                LOG.warn(String.format("Unknown language type '%1$s' found in '%2$s'", languageType, ndkModuleModel.getModuleName()));
                continue;
            }
            fileExtensions.put(fileExtension, languageKind);
        }
        return fileExtensions;
    }

    public boolean isNdkDefined() {
        return this.getNdkPath() != null;
    }

    @Nullable
    public File getNdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public File getSdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidSdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    public boolean isNativeModule(@NotNull Module module) {
        Map<String, ModuleResolveConfiguration> moduleResolveConfigurations = null;
        AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)module);
        if (ndkModuleModel != null) {
            moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, ndkModuleModel);
        } else if (androidModel != null) {
            moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
        }
        return androidModel != null && !moduleResolveConfigurations.isEmpty();
    }

    public boolean isInSDK(@Nullable VirtualFile file) {
        return false;
    }

    public boolean areFromSameProject(@Nullable VirtualFile a, @Nullable VirtualFile b) {
        return false;
    }

    public boolean areFromSamePackage(@Nullable VirtualFile a, @Nullable VirtualFile b) {
        return false;
    }

    public boolean isFromWrongSDK(@NotNull OCSymbol symbol, @Nullable VirtualFile contextFile) {
        return false;
    }

    @NotNull
    public Collection<VirtualFile> getLibraryFilesToBuildSymbols() {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends OCResolveConfiguration> getConfigurations() {
        return Lists.newArrayList(this.myResolveConfigurations.values());
    }

    @NotNull
    public List<? extends OCResolveConfiguration> getConfigurationsForFile(@Nullable VirtualFile file) {
        if (file == null || !file.isValid() || this.myResolveConfigurations.isEmpty()) {
            return ImmutableList.of();
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return ImmutableList.of();
        }
        NdkFacet ndkFacet = NdkFacet.getInstance((Module)module);
        if (ndkFacet != null) {
            return this.getResolvedConfigurations(ioFile, ndkFacet);
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet != null) {
            return this.getResolvedConfigurations(androidFacet);
        }
        ArrayList configurations = Lists.newArrayList();
        block0: for (ModuleResolveConfiguration configuration : this.myResolveConfigurations.values()) {
            HeaderRoots headerRoots = configuration.getLibraryHeadersRoots(new OCResolveRootAndConfiguration(null, file));
            for (PsiFileSystemItem root : headerRoots.getRoots()) {
                VirtualFile rootFile = root.getVirtualFile();
                if (rootFile == null || !FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)rootFile), (File)ioFile, (boolean)true)) continue;
                configurations.add(configuration);
                continue block0;
            }
        }
        return ImmutableList.copyOf((Collection)configurations);
    }

    @NotNull
    private List<? extends OCResolveConfiguration> getResolvedConfigurations(@NotNull AndroidFacet androidFacet) {
        AndroidModuleModel androidModel = AndroidModuleModel.get((AndroidFacet)androidFacet);
        if (androidModel == null) {
            return ImmutableList.of();
        }
        ArrayList configurations = Lists.newArrayList();
        IdeVariant variant = androidModel.getSelectedVariant();
        Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries((Variant)variant, (AndroidProject)androidModel.getAndroidProject());
        for (NativeLibrary nativeLibrary : nativeLibraries) {
            String key = GradleWorkspace.getResolvedConfigurationKey(androidModel, (Variant)variant, nativeLibrary);
            ModuleResolveConfiguration configuration = this.myResolveConfigurations.get(key);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    @NotNull
    private List<? extends OCResolveConfiguration> getResolvedConfigurations(@NotNull File file, @NotNull NdkFacet ndkFacet) {
        NdkModuleModel ndkModuleModel = ndkFacet.getNdkModuleModel();
        if (ndkModuleModel == null) {
            return ImmutableList.of();
        }
        HashMap configurations = Maps.newHashMap();
        for (NativeArtifact artifact : ndkModuleModel.getSelectedVariant().getArtifacts()) {
            ModuleResolveConfiguration configuration;
            NativeToolchain toolchain = ndkModuleModel.findToolchain(artifact.getToolChain());
            if (toolchain == null) continue;
            String configurationKey = null;
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                NativeSettings settings;
                if (!FileUtil.filesEqual((File)sourceFile.getFilePath(), (File)file) || (settings = ndkModuleModel.findSettings(sourceFile.getSettingsName())) == null) continue;
                File workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModuleModel, sourceFile);
                configurationKey = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory);
                break;
            }
            if (configurationKey == null) {
                File previouslyFoundFolderPath = null;
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    NativeSettings settings;
                    String settingsName;
                    String languageType;
                    File folderPath = sourceFolder.getFolderPath();
                    if (!FileUtil.isAncestor((File)folderPath, (File)file, (boolean)true) || previouslyFoundFolderPath != null && FileUtil.isAncestor((File)folderPath, previouslyFoundFolderPath, (boolean)false) || (languageType = (String)ndkModuleModel.getAndroidProject().getFileExtensions().get(FileUtilRt.getExtension((String)file.getName()))) == null || (settingsName = (String)sourceFolder.getPerLanguageSettings().get(languageType)) == null || (settings = ndkModuleModel.findSettings(settingsName)) == null) continue;
                    File workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModuleModel, sourceFolder);
                    configurationKey = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory);
                    previouslyFoundFolderPath = folderPath;
                }
            }
            if (configurationKey == null || configurations.containsKey(configurationKey) || (configuration = this.myResolveConfigurations.get(configurationKey)) == null) continue;
            configurations.put(configurationKey, configuration);
        }
        return ImmutableList.copyOf(configurations.values());
    }

    @NotNull
    private static Collection<NativeLibrary> getNativeLibraries(@NotNull Variant variant, @NotNull AndroidProject androidProject) {
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            return Collections.emptyList();
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Collection nativeLibraries = mainArtifact.getNativeLibraries();
        if (nativeLibraries != null) {
            return nativeLibraries;
        }
        return Collections.emptyList();
    }

    private static boolean isModelVersionIncompatible(@NotNull AndroidProject androidProject) {
        return GradleWorkspace.getModelVersionIfIncompatible(androidProject) != null;
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (!modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && androidProject.getApiVersion() >= 3) {
            return null;
        }
        return modelVersion;
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getValidConfigurations(@NotNull Map<String, ModuleResolveConfiguration> configs) {
        ImmutableMap.Builder configurationsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ModuleResolveConfiguration> entry : configs.entrySet()) {
            if (!GradleWorkspace.isValidConfiguration(entry.getValue())) continue;
            configurationsBuilder.put(entry);
        }
        return configurationsBuilder.build();
    }

    private static boolean isValidConfiguration(@NotNull ModuleResolveConfiguration configuration) {
        if (!GradleWorkspace.isValidConfiguration(configuration, OCLanguageKind.C)) {
            return false;
        }
        return GradleWorkspace.isValidConfiguration(configuration, OCLanguageKind.CPP);
    }

    private static boolean isValidConfiguration(@NotNull ModuleResolveConfiguration configuration, @NotNull OCLanguageKind kind) {
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches(kind, null);
        boolean isValidConfiguration = false;
        boolean isystemFound = false;
        boolean sysrootFound = false;
        for (String argument : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            File sysroot;
            String sysrootPath = StringUtil.trimStart((String)(argument = StringUtil.unquoteString((String)argument.trim())), (String)"--sysroot=");
            if (sysrootPath.length() < argument.length()) {
                sysroot = new File(FileUtilRt.toSystemIndependentName((String)sysrootPath));
                if (!sysroot.isAbsolute()) {
                    sysroot = new File(compilerSettings.getCompilerWorkingDir(), sysroot.getPath());
                }
                if (isValidConfiguration = AndroidSysroot.isValidAndroidSysroot(sysroot)) continue;
                return false;
            }
            if (argument.equals("--sysroot")) {
                sysrootFound = true;
                continue;
            }
            if (sysrootFound) {
                sysrootFound = false;
                sysroot = new File(FileUtilRt.toSystemIndependentName((String)argument));
                if (!sysroot.isAbsolute()) {
                    sysroot = new File(compilerSettings.getCompilerWorkingDir(), sysroot.getPath());
                }
                if (isValidConfiguration = AndroidSysroot.isValidAndroidSysroot(sysroot)) continue;
                return false;
            }
            if (argument.equals("-isystem")) {
                isystemFound = true;
                continue;
            }
            if (!isystemFound) continue;
            isystemFound = false;
            File systemIncludePath = new File(FileUtilRt.toSystemIndependentName((String)argument));
            if (!systemIncludePath.isAbsolute()) {
                systemIncludePath = new File(compilerSettings.getCompilerWorkingDir(), systemIncludePath.getPath());
            }
            if (AndroidSysroot.isValidAndroidSysrootUsrInclude(systemIncludePath)) {
                isValidConfiguration = true;
                continue;
            }
            if (!AndroidSysroot.isPotentialNonAndroidSysrootUsrInclude(systemIncludePath)) continue;
            return false;
        }
        return isValidConfiguration;
    }

    @Nullable
    public OCLanguageKind getLanguageKind(@NotNull String fileName) {
        if (!OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return null;
        }
        String fileExtension = FileUtilRt.getExtension((String)fileName);
        OCLanguageKind languageKind = this.myProjectFileExtensions.get(fileExtension);
        if (languageKind == null && !this.myResolveConfigurations.isEmpty()) {
            languageKind = fileExtension.equalsIgnoreCase(GRADLE_LANGUAGE_TYPE_C) ? OCLanguageKind.C : OCLanguageKind.CPP;
            LOG.warn(String.format("Unable to find language kind for files with extension '%1$s', assuming it as '%2$s'", fileExtension, languageKind));
            this.myProjectFileExtensions.put(fileExtension, languageKind);
        }
        return languageKind;
    }
}

