/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulePathManager {
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);

    @NotNull
    public static File getRepoLLDBBinFile(@NotNull String relativePath) {
        File lldbBin = new File(PathManager.getBinPath(), "lldb");
        File file = new File(lldbBin, relativePath);
        if (file.exists()) {
            return file;
        }
        return new File(new File(PathManager.getHomePath(), "../vendor/google/android-ndk/bin/lldb"), relativePath);
    }

    @NotNull
    public static File getSdkLLDBDir() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ModulePathManager.class);
        String path = DetailsTypes.getLldbPath((Revision)LLDBSdkPkgInstaller.PINNED_REVISION);
        LocalPackage p = AndroidSdks.getInstance().tryToChooseSdkHandler().getLocalPackage(path, (ProgressIndicator)progress);
        if (p == null) {
            throw new IllegalStateException("LLDB package hasn't been found");
        }
        return p.getLocation();
    }

    @NotNull
    public static File getSdkLLDBFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getSdkLLDBDir(), relativePath);
    }

    @NotNull
    public static File getSdkLLDBAndroidFile(@NotNull String relativePath) {
        return new File(new File(ModulePathManager.getSdkLLDBDir(), "android"), relativePath);
    }

    @Nullable
    public static File findLLDBServer(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        File foundServerFile = null;
        for (Abi abi : abis) {
            File serverFile = ModulePathManager.getServerFileByAbi(abi);
            if (serverFile != null) {
                foundServerFile = serverFile;
            }
            if (AndroidNativeDebugProcess.getSymbolsDir(facet, debuggerState, Collections.singletonList(abi)).isEmpty()) continue;
            return serverFile;
        }
        return foundServerFile;
    }

    @Nullable
    private static File getServerFileByAbi(@NotNull Abi abi) {
        File lldbServerFile = ModulePathManager.getAndroidLLDBBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = ModulePathManager.getAndroidLLDBBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    @NotNull
    private static File getAndroidLLDBBinFile(Abi abi) {
        return ModulePathManager.getSdkLLDBAndroidFile(new File(abi.toString(), "lldb-server").getPath());
    }

    @NotNull
    public static File getRepoLLDBSharedBinFile(@NotNull String relativePath) {
        return ModulePathManager.getRepoLLDBBinFile(new File("shared", relativePath).getPath());
    }

    @NotNull
    public static File getRepoLLDBStlPrintersFolder() {
        return ModulePathManager.getRepoLLDBSharedBinFile("stl_printers");
    }

    @NotNull
    public static File getRepoLLDBStlPrintersBinFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getRepoLLDBStlPrintersFolder(), relativePath);
    }

    @NotNull
    public static File getRepoLLDBPrettyPrinterScriptsFolder() {
        return ModulePathManager.getRepoLLDBSharedBinFile("jobject_printers");
    }
}

