/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.tools.ndk.GradleWorkspace;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.CidrCompilerResult;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.toolchains.CompilerInfoCache;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkCompilerInfoCache {
    @NotNull
    private final CompilerInfoCache myCompilerInfoCache;

    public NdkCompilerInfoCache() {
        this(new CompilerInfoCache());
    }

    @VisibleForTesting
    NdkCompilerInfoCache(@NotNull CompilerInfoCache compilerInfoCache) {
        this.myCompilerInfoCache = compilerInfoCache;
    }

    @Nullable
    public NdkCompilerInfo getCompilerInfo(@NotNull Project project, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile) throws NdkCompilerInvocationException {
        CidrCompilerResult compilerResult = this.myCompilerInfoCache.getCompilerInfoCache(project, compilerSettings, lang, sourceFile);
        CompilerInfoCache.Entry compilerInfo = (CompilerInfoCache.Entry)compilerResult.getResult();
        if (compilerInfo == null) {
            if (GradleWorkspace.getInstance(project).getConfigurationsForFile(sourceFile).isEmpty()) {
                return null;
            }
            String message = "Failed to get the compiler information " + (sourceFile != null ? "for file " + sourceFile.getPath() : "");
            throw new NdkCompilerInvocationException(message, compilerResult.getError());
        }
        return new NdkCompilerInfo(compilerInfo);
    }

    public static class NdkCompilerInvocationException
    extends Exception {
        private NdkCompilerInvocationException(@NotNull String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }

    public static class NdkCompilerInfo {
        @NotNull
        private final CompilerInfoCache.Entry myInfo;

        private NdkCompilerInfo(@NotNull CompilerInfoCache.Entry info) {
            this.myInfo = info;
        }

        @NotNull
        public String getDefines() {
            return this.myInfo.defines;
        }

        @NotNull
        public Map<String, String> getFeatures() {
            return this.myInfo.features;
        }

        @NotNull
        public Map<String, String> getExtensions() {
            return this.myInfo.extensions;
        }

        @NotNull
        public List<HeadersSearchRoot> getHeaderSearchPaths() {
            return this.myInfo.headerSearchPaths;
        }

        @VisibleForTesting
        @NotNull
        CompilerInfoCache.Entry getInfo() {
            return this.myInfo;
        }
    }
}

