/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.utils.debug.dwarf.DwarfReader;
import org.eclipse.cdt.utils.elf.Elf;
import org.jetbrains.annotations.NotNull;

public class SourceRootsExtractor {
    @NotNull
    public List<String> extractSourceRoots(@NotNull File path) throws IOException {
        HashSet<String> sourceRoots = new HashSet<String>();
        this.doExtractSourceRoots(path, sourceRoots);
        return FilePaths.mergePaths(sourceRoots);
    }

    private void doExtractSourceRoots(@NotNull File path, @NotNull Set<String> sourceRoots) throws IOException {
        if (path.isDirectory()) {
            for (File child : FileUtil.notNullize((File[])path.listFiles())) {
                this.doExtractSourceRoots(child, sourceRoots);
            }
        } else {
            sourceRoots.addAll(this.extractSourceRootsFromFile(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> extractSourceRootsFromFile(@NotNull File filePath) throws IOException {
        if (!filePath.exists() || !"so".equals(FileUtilRt.getExtension((String)filePath.getName()))) {
            return Collections.emptyList();
        }
        Elf elf = new Elf(filePath.getPath());
        try {
            Elf.Section debugInfo = elf.getSectionByName(".debug_info");
            if (debugInfo == null) {
                SourceRootsExtractor.getLog().info("No debug info in the ELF lib");
                List<String> list = Collections.emptyList();
                return list;
            }
            DwarfReader reader = new DwarfReader(elf);
            String[] sourceFilePaths = reader.getSourceFiles();
            if (sourceFilePaths == null) {
                SourceRootsExtractor.getLog().info("No source files can be found in ELF lib");
                List<String> list = Collections.emptyList();
                return list;
            }
            List list = FilePaths.computeRootPathsForFiles(Arrays.stream(sourceFilePaths));
            return list;
        }
        finally {
            elf.dispose();
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(SourceRootsExtractor.class);
    }
}

