/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniNameMangler {
    @Nullable
    public static PsiMethod findDeclaration(@NotNull Project project, @NotNull String jniMethodName) {
        PsiMethod[] methods;
        int methodEnd;
        int methodBegin;
        int classBegin;
        if (!jniMethodName.startsWith("Java_")) {
            return null;
        }
        int pkgStart = "Java_".length();
        int length = jniMethodName.length();
        boolean lastWasUnderscore = false;
        for (classBegin = pkgStart; classBegin < length; ++classBegin) {
            char c = jniMethodName.charAt(classBegin);
            if (c == '_') {
                lastWasUnderscore = true;
                continue;
            }
            if (Character.isUpperCase(c) && lastWasUnderscore) break;
            lastWasUnderscore = false;
        }
        if ((methodBegin = jniMethodName.indexOf(95, classBegin) + 1) == 0) {
            return null;
        }
        lastWasUnderscore = true;
        while (methodBegin < length) {
            char c = jniMethodName.charAt(methodBegin);
            if (c == '_') {
                lastWasUnderscore = true;
            } else {
                if (Character.isLowerCase(c) && lastWasUnderscore) break;
                lastWasUnderscore = false;
            }
            ++methodBegin;
        }
        if ((methodEnd = jniMethodName.indexOf("__", methodBegin)) == -1) {
            methodEnd = length;
        }
        String pkg = classBegin > pkgStart ? JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(pkgStart, classBegin - 1), true) : null;
        String cls = JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(classBegin, methodBegin - 1), false);
        String methodName = JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(methodBegin, methodEnd), false);
        String fqn = pkg != null ? pkg + '.' + cls : cls;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (psiClass == null) {
            cls = cls.replace('_', '.');
            fqn = pkg != null ? pkg + '.' + cls : cls;
            psiClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
            if (psiClass == null) {
                return null;
            }
        }
        if ((methods = psiClass.findMethodsByName(methodName, false)).length == 1) {
            return methods[0];
        }
        ArrayList nativeMethods = Lists.newArrayListWithExpectedSize((int)methods.length);
        for (PsiMethod method : methods) {
            if (!method.hasModifierProperty("native")) continue;
            nativeMethods.add(method);
        }
        if (nativeMethods.size() == 1) {
            return (PsiMethod)nativeMethods.get(0);
        }
        if (nativeMethods.isEmpty()) {
            return null;
        }
        for (PsiMethod method : nativeMethods) {
            String escaped = JniNameMangler.getJniMethodName(method, true);
            if (!jniMethodName.equals(escaped)) continue;
            return method;
        }
        for (PsiMethod method : nativeMethods) {
            String escaped = JniNameMangler.getJniMethodName(method, false);
            if (!jniMethodName.equals(escaped)) continue;
            return method;
        }
        return (PsiMethod)nativeMethods.get(0);
    }

    static PsiMethod findDeclaration(@NotNull OCDeclarator element) {
        String jniMethodName = element.getName();
        if (jniMethodName != null) {
            return JniNameMangler.findDeclaration(element.getProject(), jniMethodName);
        }
        return null;
    }

    @NotNull
    public static String getJniMethodName(@NotNull PsiMethod method) {
        boolean overloaded = JniNameMangler.isOverloaded(method);
        return JniNameMangler.getJniMethodName(method, overloaded);
    }

    public static boolean isOverloaded(@NotNull PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && containingClass.findMethodsByName(method.getName(), false).length > 1;
    }

    @NotNull
    public static String getJniMethodName(@NotNull PsiMethod method, boolean overloaded) {
        return JniNameMangler.getJniMethodName(JniNameMangler.getJniClassName(method.getContainingClass()), method.getName(), method.getParameterList().getParameters(), overloaded);
    }

    @NotNull
    public static String getJniMethodName(String jniClassName, String name, PsiParameter[] parameters, boolean overloaded) {
        StringBuilder sb = new StringBuilder();
        sb.append("Java_");
        sb.append(jniClassName);
        sb.append('_');
        sb.append(JniNameMangler.jniEncodeUnderscore(name, false));
        if (overloaded) {
            sb.append('_').append('_');
            for (PsiParameter parameter : parameters) {
                PsiType type = parameter.getType();
                if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                    type = TypeConversionUtil.erasure((PsiType)type);
                }
                String internal = JniNameMangler.getJvmType(type);
                sb.append(JniNameMangler.jniEscape(internal));
            }
        }
        return sb.toString();
    }

    @NotNull
    public static String getJniClassName(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                return JniNameMangler.jniEncodeUnderscore(qualifiedName, true);
            }
            return JniNameMangler.jniEncodeUnderscore(psiClass.getName(), false);
        }
        return "";
    }

    public static String jniEncodeUnderscore(@NotNull String javaName, boolean isPackageName) {
        if (isPackageName) {
            return javaName.replaceAll("_", "_1").replace('.', '_');
        }
        return javaName.replaceAll("_", "_1");
    }

    private static String jniDecodeUnderscore(@NotNull String nativeName, boolean isPackageName) {
        if (isPackageName) {
            return nativeName.replace('_', '.').replaceAll("\\.1", "_");
        }
        return nativeName.replaceAll("_1", "_");
    }

    @NotNull
    public static String getJniType(@NotNull PsiType type) {
        if (PsiType.VOID.equals((Object)type)) {
            return "void";
        }
        if (PsiType.BOOLEAN.equals((Object)type)) {
            return "jboolean";
        }
        if (PsiType.INT.equals((Object)type)) {
            return "jint";
        }
        if (PsiType.LONG.equals((Object)type)) {
            return "jlong";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            return "jfloat";
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            return "jdouble";
        }
        if (PsiType.BYTE.equals((Object)type)) {
            return "jbyte";
        }
        if (PsiType.CHAR.equals((Object)type)) {
            return "jchar";
        }
        if (PsiType.SHORT.equals((Object)type)) {
            return "jshort";
        }
        if (type instanceof PsiArrayType) {
            if (PsiType.BOOLEAN.equals((Object)(type = ((PsiArrayType)type).getComponentType()))) {
                return "jbooleanArray";
            }
            if (PsiType.INT.equals((Object)type)) {
                return "jintArray";
            }
            if (PsiType.LONG.equals((Object)type)) {
                return "jlongArray";
            }
            if (PsiType.DOUBLE.equals((Object)type)) {
                return "jdoubleArray";
            }
            if (PsiType.CHAR.equals((Object)type)) {
                return "jcharArray";
            }
            if (PsiType.FLOAT.equals((Object)type)) {
                return "jfloatArray";
            }
            if (PsiType.SHORT.equals((Object)type)) {
                return "jshortArray";
            }
            if (PsiType.BYTE.equals((Object)type)) {
                return "jbyteArray";
            }
            return "jobjectArray";
        }
        if (JniNameMangler.isString(type)) {
            return "jstring";
        }
        if (JniNameMangler.isClass(type)) {
            return "jclass";
        }
        if (JniNameMangler.isThrowable(type)) {
            return "jthrowable";
        }
        return "jobject";
    }

    @Contract(value="null -> false")
    public static boolean isClass(@NotNull PsiType type) {
        return "java.lang.Class".equals(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isString(@NotNull PsiType type) {
        String shortName;
        if (type instanceof PsiClassType && !Comparing.equal((String)(shortName = ((PsiClassType)type).getClassName()), (String)"String")) {
            return false;
        }
        return "java.lang.String".equals(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isThrowable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Throwable");
    }

    @NotNull
    private static String getJvmType(@NotNull PsiType type) {
        if (PsiType.BOOLEAN.equals((Object)type)) {
            return "Z";
        }
        if (PsiType.BYTE.equals((Object)type)) {
            return "B";
        }
        if (PsiType.CHAR.equals((Object)type)) {
            return "C";
        }
        if (PsiType.SHORT.equals((Object)type)) {
            return "S";
        }
        if (PsiType.INT.equals((Object)type)) {
            return "I";
        }
        if (PsiType.LONG.equals((Object)type)) {
            return "J";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            return "F";
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            return "D";
        }
        if (PsiType.VOID.equals((Object)type)) {
            return "V";
        }
        return "L" + type.getCanonicalText().replace('.', '/') + ";";
    }

    static String jniEscape(String name) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '.': 
                case '/': {
                    sb.append('_');
                    continue block6;
                }
                case '_': {
                    sb.append('_').append('1');
                    continue block6;
                }
                case ';': {
                    sb.append('_').append('2');
                    continue block6;
                }
                case '[': {
                    sb.append('_').append('3');
                    continue block6;
                }
                default: {
                    sb.append('_').append('0');
                    sb.append((int)c);
                }
            }
        }
        return sb.toString();
    }
}

