/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JniRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return NdkHelper.isNdkProject(element.getProject()) && (element instanceof PsiMethod || element instanceof PsiClass);
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            JniRenameProcessor.renameNativeMethod(newName, allRenames, method, JniNameMangler.getJniClassName(method.getContainingClass()));
        } else if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot == -1) {
                return;
            }
            String newQualifiedName = qualifiedName.substring(0, lastDot) + '.' + newName;
            for (PsiMethod method : psiClass.getMethods()) {
                JniRenameProcessor.renameNativeMethod(method.getName(), allRenames, method, JniNameMangler.jniEncodeUnderscore(newQualifiedName, true));
            }
        }
    }

    private static void renameNativeMethod(String newName, Map<PsiElement, String> allRenames, PsiMethod method, String jniClassPrefix) {
        if (!method.hasModifierProperty("native")) {
            return;
        }
        PsiElement[] targets = JniGotoDeclarationHandler.getGotoDeclarationTargets((PsiElement)method);
        if (targets == null) {
            return;
        }
        boolean overloaded = JniNameMangler.isOverloaded(method);
        String newMangledName = JniNameMangler.getJniMethodName(jniClassPrefix, newName, method.getParameterList().getParameters(), overloaded);
        for (PsiElement target : targets) {
            allRenames.put(target, newMangledName);
        }
    }
}

