/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.MemoryRegionMap;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNativeAppDebugProcess
extends AndroidNativeDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeAppDebugProcess.class);
    private static final String LIBART_SO = "libart.so";
    private static final String ART_SIGSEGV_FAULT = "art_sigsegv_fault";
    private static final List<String> SKIPPABLE_UNITY_SIGNALS = ImmutableList.of((Object)"SIGPWR", (Object)"SIGXCPU");
    private static final List<String> UNITY_IDENTIFYING_LIBRARIES = ImmutableList.of((Object)"libil2cpp.so", (Object)"libmono.so");
    private static final CidrSymbolicBreakpointType SYMBOLIC_BREAKPOINT_TYPE = (CidrSymbolicBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class);
    private final Project myProject;
    private final Client myClient;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigSegvFaultBp;
    private boolean myArt = false;
    private final MemoryRegionMap myArtMemRegionMap = new MemoryRegionMap(Arrays.asList(".*\\.dex", ".*\\.odex", ".*\\.oat"));
    private final boolean myDetachOnStop;
    private final Set<String> myLoadedModules = Sets.newHashSet();
    private final Map<File, File> myModuleToSymbols;
    private final JdwpConnector myJdwpConnector;

    public AndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws ExecutionException {
        super(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, progressReporter);
        AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)this.myRunParameters.getDebuggerDriverConfiguration();
        ApkFacet apkFacet = ApkFacet.getInstance((Module)configuration.getFacet().getModule());
        if (apkFacet != null && !configuration.getClientABIs().isEmpty()) {
            Abi abi = configuration.getClientABIs().get(0);
            this.myModuleToSymbols = ((ApkFacetConfiguration)apkFacet.getConfiguration()).getExplicitModuleSymbolMap(abi);
        } else {
            this.myModuleToSymbols = Collections.emptyMap();
        }
        this.myProject = session.getProject();
        this.myClient = client;
        this.myDetachOnStop = detachOnStop;
        this.myJdwpConnector = jdwpConnector;
    }

    @NotNull
    public Client getClient() {
        return this.myClient;
    }

    public boolean isDetachDefault() {
        return this.myDetachOnStop;
    }

    @Override
    protected void prepareTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        this.myProgressReporter.step("Loading debugger driver");
        driver.loadForAttach();
        ClientData clientData = this.myClient.getClientData();
        LOG.info(String.format("Attaching to inferior: pid=%d, ABI=%s, native debuggable=%b", clientData.getPid(), clientData.getAbi(), clientData.isNativeDebuggable()));
        this.myProgressReporter.step("Attaching to the app");
        driver.attachTo(clientData.getPid());
        this.myArt = this.isArtVM();
        if (this.myArt) {
            LOG.info("Running in ART VM");
            this.initArtSigSegvFaultBreakpoint();
        } else {
            LOG.info("Running in Dalvik VM");
        }
        this.loadExplicitSymbols();
    }

    @Override
    protected void launchTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        LOG.info("Resuming paused inferior");
        this.myProgressReporter.step("Resuming the app process");
        driver.resume();
    }

    @NotNull
    protected XBreakpointManager getBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    @NotNull
    protected static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private void initArtSigSegvFaultBreakpoint() throws ExecutionException {
        AndroidNativeAppDebugProcess.getApp().runReadAction(() -> {
            for (XBreakpoint bp : this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                if (!LIBART_SO.equals(bpProps.getModuleName()) || !ART_SIGSEGV_FAULT.equals(bpProps.getSymbolPattern())) continue;
                this.myArtSigSegvFaultBp = bp;
                break;
            }
        });
        if (this.myArtSigSegvFaultBp != null) {
            return;
        }
        AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
            CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(ART_SIGSEGV_FAULT, LIBART_SO);
            this.myArtSigSegvFaultBp = this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
        }));
    }

    private boolean isArtVM() {
        return this.myLoadedModules.contains(LIBART_SO);
    }

    private void loadExplicitSymbols() {
        for (Map.Entry<File, File> entry : this.myModuleToSymbols.entrySet()) {
            String cmd = String.format("target modules add -s \"%s\" \"%s\"", entry.getValue().getAbsolutePath(), entry.getKey().getAbsolutePath());
            this.executeConsoleCommand(cmd);
        }
    }

    public void stop() {
        super.stop();
        if (this.myJdwpConnector != null) {
            this.myJdwpConnector.dispose();
        }
        AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
            if (this.myArtSigSegvFaultBp != null && !this.myProject.isDisposed()) {
                XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().removeBreakpoint(this.myArtSigSegvFaultBp);
                this.myArtSigSegvFaultBp = null;
            }
        }));
    }

    private boolean isUnityApp() {
        for (String unityLibrary : UNITY_IDENTIFYING_LIBRARIES) {
            if (!this.myLoadedModules.contains(unityLibrary)) continue;
            return true;
        }
        return false;
    }

    public void handleSignal(final @NotNull DebuggerDriver.StopPlace stopPlace, final @NotNull String signal, final @NotNull String meaning) {
        if (SKIPPABLE_UNITY_SIGNALS.contains(signal)) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (AndroidNativeAppDebugProcess.this.isUnityApp()) {
                        for (String skippableUnixSignal : SKIPPABLE_UNITY_SIGNALS) {
                            try {
                                driver.handleSignal(skippableUnixSignal, false, true, false);
                            }
                            catch (DebuggerCommandException e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        driver.resume();
                    } else {
                        AndroidNativeAppDebugProcess.super.handleSignal(stopPlace, signal, meaning);
                    }
                }
            });
            return;
        }
        if (this.myArt && signal.equals("SIGSEGV")) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (!AndroidNativeAppDebugProcess.this.handleArtSigSegv(driver, stopPlace.thread)) {
                        AndroidNativeAppDebugProcess.super.handleSignal(stopPlace, signal, meaning);
                    }
                }
            });
            return;
        }
        super.handleSignal(stopPlace, signal, meaning);
    }

    private boolean handleArtSigSegv(@NotNull DebuggerDriver driver, @NotNull LLThread thread) {
        try {
            List frames = driver.getFrames((long)thread.getId(), (int)0, (int)1).list;
            if (frames.isEmpty()) {
                return false;
            }
            LLFrame firstFrame = (LLFrame)frames.get(0);
            LOG.info("Got SIGSEGV signal, PC address: " + firstFrame.getProgramCounter());
            MemoryRegionMap.Region region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter().unsignedLongValue());
            if (region == null || !region.isExecutable()) {
                this.myArtMemRegionMap.clear();
                String procMapsContent = this.readProcMapsFile(driver);
                this.myArtMemRegionMap.addMapEntries(StringUtil.splitByLines((String)procMapsContent));
            }
            if ((region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter().unsignedLongValue())) != null && region.isExecutable()) {
                LOG.info(String.format("SIGSEGV came from ART module '%s' - resuming the inferior", region.getFileName()));
                driver.resume();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    @NotNull
    private String readProcMapsFile(@NotNull DebuggerDriver driver) throws ExecutionException {
        return driver.executeShellCommand("cat", (List)Lists.newArrayList((Object[])new String[]{String.format("/proc/%d/maps", this.myClient.getClientData().getPid())}), null, 0).getOutput();
    }

    @Override
    public void handleModulesLoaded(@NotNull List<String> modules) {
        ArrayList<String> trimmedModules = new ArrayList<String>();
        for (String m : modules) {
            if (m == null || m.isEmpty()) continue;
            trimmedModules.add(m.trim());
        }
        super.handleModulesLoaded(trimmedModules);
        this.myLoadedModules.addAll(trimmedModules);
    }
}

