/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.SourceProvider;
import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.ndk.run.OptimizedFileNotificationProvider;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.crash.CrashLoggingEvent;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidNativeDebugProcess
extends CidrDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeDebugProcess.class);
    private static final boolean ENABLE_ATTACH_ERROR_REPORTING = true;
    private static final boolean ADD_IDEA_LOG_TO_ERROR_REPORTS = false;
    protected final ConsolePrinter myPrinter;
    protected final SessionStarter mySessionStarter;
    protected final ProgressReporter myProgressReporter;
    private final String mySessionId;
    private long myStops = 0L;
    private boolean myReportedSessionEnd = false;
    private static final Map<String, String> DANGEROUS_COMPILER_FLAGS = ImmutableMap.of((Object)"-flto", (Object)"Combining -flto with -g is currently experimental and expected to produce unexpected results", (Object)"-Wl,--gc-sections", (Object)"can remove unused functions, breaking expression evaluation");

    protected AndroidNativeDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull ProgressReporter progressReporter) throws ExecutionException {
        super(parameters, session, consoleBuilder);
        this.mySessionId = sessionId;
        this.myPrinter = printer;
        this.mySessionStarter = sessionStarter;
        this.myProgressReporter = progressReporter;
        session.addSessionListener((XDebugSessionListener)new WarnIfOptimizedListener());
    }

    protected void doStart(@NotNull DebuggerDriver driver) throws ExecutionException {
        try {
            this.mySessionStarter.pushFilesToDevice();
            this.prepareTarget(driver);
        }
        catch (ExecutionException launchException) {
            this.myProgressReporter.finish();
            this.handleLaunchException(launchException);
        }
    }

    public void sessionInitialized() {
        super.sessionInitialized();
        this.getProcessHandler().startNotify();
    }

    protected abstract void prepareTarget(@NotNull DebuggerDriver var1) throws ExecutionException;

    protected abstract void launchTarget(@NotNull DebuggerDriver var1) throws ExecutionException;

    protected void doLaunchTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        try {
            this.launchTarget(driver);
            this.mySessionStarter.sessionStarted();
            LOG.info("Launch has been completed");
        }
        catch (ExecutionException launchException) {
            this.handleLaunchException(launchException);
        }
        finally {
            this.myProgressReporter.finish();
        }
    }

    private void handleLaunchException(@NotNull ExecutionException launchException) throws ExecutionException {
        this.getSession().stop();
        LOG.warn((Throwable)launchException);
        this.myPrinter.stderr(launchException.getMessage());
        this.reportError(launchException);
        List<Attachment> logs = this.mySessionStarter.getLogFilesFromDevice();
        throw new CrashLoggingEvent(launchException.getMessage(), launchException, logs, AndroidStudioUsageTracker.deviceToDeviceInfo((IDevice)this.mySessionStarter.getDevice()), launchException.toString()).makeException();
    }

    @NotNull
    private static Attachment getIdeaLog() {
        String content;
        File logFile = new File(PathManager.getLogPath(), "idea.log");
        try {
            content = FileUtil.loadFile((File)logFile);
            int logTailSize = 100000;
            if (content.length() > 100000) {
                content = content.substring(content.length() - 100000);
            }
        }
        catch (IOException e) {
            content = e.toString();
        }
        return new Attachment(logFile.getPath(), content);
    }

    @NotNull
    private static Set<String> getAbiNameSet(@NotNull List<Abi> abis) {
        HashSet abiNames = Sets.newHashSetWithExpectedSize((int)abis.size());
        for (Abi abi : abis) {
            abiNames.add(abi.toString());
        }
        return abiNames;
    }

    private static void visitNativeLibraries(@NotNull Module module, @NotNull Set<String> abiNames, @NotNull NativeLibraryVisitor visitor) {
        Collection nativeLibraries;
        AndroidModuleModel androidModel;
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)module);
        if (ndkModuleModel != null) {
            NdkModuleModel.NdkVariant variant = ndkModuleModel.getSelectedVariant();
            Collection nativeArtifacts = variant.getArtifacts();
            for (NativeArtifact nativeArtifact : nativeArtifacts) {
                String abi;
                File artifactOutputFile = nativeArtifact.getOutputFile();
                if (!artifactOutputFile.exists() || !abiNames.contains(abi = artifactOutputFile.getParentFile().getName())) continue;
                visitor.visit(ndkModuleModel, nativeArtifact);
            }
        }
        if ((androidModel = AndroidModuleModel.get((Module)module)) == null) {
            return;
        }
        IdeAndroidArtifact androidArtifact = androidModel.getSelectedVariant().getMainArtifact();
        if (AndroidPluginGeneration.find((Module)module) == AndroidPluginGeneration.COMPONENT && (nativeLibraries = androidArtifact.getNativeLibraries()) != null) {
            for (NativeLibrary library : nativeLibraries) {
                if (!abiNames.contains(library.getAbi())) continue;
                visitor.visit(library);
            }
        }
        Dependencies dependencies = androidArtifact.getDependencies();
        for (AndroidLibrary lib : dependencies.getLibraries()) {
            AndroidModuleModel moduleModel;
            AndroidFacet moduleFacet;
            Module depModule;
            String projectName = lib.getProject();
            if (projectName == null || (depModule = GradleUtil.findModuleByGradlePath((Project)module.getProject(), (String)projectName)) == null || (moduleFacet = AndroidFacet.getInstance((Module)depModule)) == null || (moduleModel = AndroidModuleModel.get((AndroidFacet)moduleFacet)) == null) continue;
            AndroidNativeDebugProcess.visitNativeLibraries(depModule, abiNames, visitor);
        }
    }

    @NotNull
    public static Map<String, String> getSourceMap(@NotNull AndroidFacet facet) {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        ApkFacet apkFacet = ApkFacet.getInstance((Module)facet.getModule());
        if (apkFacet != null) {
            for (Map.Entry entry : ((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings().entrySet()) {
                if (((String)entry.getValue()).isEmpty() || ((String)entry.getKey()).equals(entry.getValue())) continue;
                sourceMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return sourceMap;
    }

    @NotNull
    public static Collection<File> getSymbolsDir(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        AndroidModuleModel androidModel;
        final LinkedHashSet symDirs = Sets.newLinkedHashSet();
        AndroidNativeDebugProcess.addSymbolDirectories(symDirs, debuggerState.getSymbolDirs());
        ApkFacet apkFacet = ApkFacet.getInstance((Module)facet.getModule());
        if (apkFacet != null) {
            AndroidNativeDebugProcess.addSymbolDirectories(symDirs, ((ApkFacetConfiguration)apkFacet.getConfiguration()).getDebugSymbolFolderPaths(abis));
        }
        if ((androidModel = AndroidModuleModel.get((AndroidFacet)facet)) != null) {
            for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                for (File jniLib : sourceProvider.getJniLibsDirectories()) {
                    if (!jniLib.exists()) continue;
                    for (Abi abi : abis) {
                        File abiJniLib = new File(jniLib, abi.toString());
                        if (!abiJniLib.exists()) continue;
                        symDirs.add(abiJniLib);
                    }
                }
            }
        }
        AndroidNativeDebugProcess.visitNativeLibraries(facet.getModule(), AndroidNativeDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary library) {
                symDirs.addAll(library.getDebuggableLibraryFolders());
            }

            @Override
            public void visit(@NotNull NdkModuleModel ndkModuleModel, @NotNull NativeArtifact artifact) {
                symDirs.add(artifact.getOutputFile().getParentFile());
            }
        });
        return symDirs;
    }

    private static void addSymbolDirectories(@NotNull Set<File> symDirs, @NotNull Iterable<String> paths) {
        for (String path : paths) {
            File dir = new File(FileUtils.toSystemDependentPath((String)path));
            symDirs.add(dir);
            Files.fileTreeTraverser().preOrderTraversal((Object)dir).filter(Files.isDirectory()).copyInto(symDirs);
        }
    }

    public static void verifyNativeModel(@NotNull AndroidFacet facet, @NotNull List<Abi> abis, final @NotNull ConsolePrinter printer) {
        AndroidNativeDebugProcess.visitNativeLibraries(facet.getModule(), AndroidNativeDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary nativeLibrary) {
                HashSet compilerFlags = Sets.newHashSet();
                compilerFlags.addAll(nativeLibrary.getCCompilerFlags());
                compilerFlags.addAll(nativeLibrary.getCppCompilerFlags());
                this.verifyCompilerFlags(nativeLibrary.getName(), compilerFlags);
            }

            @Override
            public void visit(@NotNull NdkModuleModel ndkModuleModel, @NotNull NativeArtifact nativeArtifact) {
                HashSet compilerFlags = Sets.newHashSet();
                for (NativeFile nativeFile : nativeArtifact.getSourceFiles()) {
                    NativeSettings settings = ndkModuleModel.findSettings(nativeFile.getSettingsName());
                    if (settings == null) {
                        LOG.warn(String.format("Cannot find settings \"%s\" for native file \"%s\"", nativeFile.getSettingsName(), nativeFile.getFilePath()));
                        continue;
                    }
                    compilerFlags.addAll(settings.getCompilerFlags());
                }
                for (NativeFolder nativeFolder : nativeArtifact.getSourceFolders()) {
                    for (Map.Entry setting : nativeFolder.getPerLanguageSettings().entrySet()) {
                        NativeSettings settings = ndkModuleModel.findSettings((String)setting.getValue());
                        if (settings == null) {
                            LOG.warn(String.format("Cannot find settings \"%s\" for native folder \"%s\"", setting.getValue(), nativeFolder.getFolderPath()));
                            continue;
                        }
                        compilerFlags.addAll(settings.getCompilerFlags());
                    }
                }
                this.verifyCompilerFlags(nativeArtifact.getName(), compilerFlags);
            }

            private void verifyCompilerFlags(@NotNull String libraryName, @NotNull Collection<String> compilerFlags) {
                HashMap foundDangerousFlags = Maps.newHashMap();
                for (Map.Entry flag : DANGEROUS_COMPILER_FLAGS.entrySet()) {
                    if (!compilerFlags.contains(flag.getKey())) continue;
                    foundDangerousFlags.put(flag.getKey(), flag.getValue());
                }
                if (!foundDangerousFlags.isEmpty()) {
                    String mainWarning = String.format("Native library %s is using compiler flags which may be debug incompatible:", libraryName);
                    printer.stderr(mainWarning);
                    LOG.warn(mainWarning);
                    for (Map.Entry flag : foundDangerousFlags.entrySet()) {
                        String flagWarning = String.format("%s: %s", flag.getKey(), flag.getValue());
                        printer.stderr(flagWarning);
                        LOG.warn(flagWarning);
                    }
                }
            }
        });
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull CidrDebugProcess.DebuggerCommand command, @NotNull ExecutionException exception) {
        this.reportError(exception);
        if (!AndroidLLDBBreakpadIntegration.checkForCrashes((AndroidLLDBDriver)driver)) {
            super.handleCommandException(driver, command, exception);
        }
    }

    public void handleModulesLoaded(@NotNull List<String> modules) {
        for (String module : modules) {
            this.myProgressReporter.step("Loaded module: " + module);
        }
    }

    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        ++this.myStops;
        super.handleInterrupted(stopPlace);
    }

    private void reportError(@NotNull Throwable e) {
        LLDBUsageTracker.sessionFailed(e, this.mySessionId, this.myStops);
    }

    private synchronized boolean reportSessionEnd() {
        if (this.myReportedSessionEnd) {
            return false;
        }
        this.myReportedSessionEnd = true;
        return true;
    }

    public void handleTargetFinished(int code, @Nullable String description) {
        super.handleTargetFinished(code, description);
        if (this.reportSessionEnd()) {
            LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops);
        }
    }

    public void handleTargetTerminated() {
        super.handleTargetTerminated();
        if (this.reportSessionEnd()) {
            LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops);
        }
    }

    public void handleExited(int code) {
        LOG.info("LLDBFrontend exited with code " + code);
        super.handleExited(code);
        if (this.reportSessionEnd()) {
            if (code == 0) {
                LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops);
            } else {
                LLDBUsageTracker.sessionFailed("LLDBFrontend exited with code " + code, this.mySessionId, this.myStops);
            }
        }
    }

    static {
        AndroidLLDBBreakpadIntegration.checkForStaleMinidumps();
    }

    private class WarnIfOptimizedListener
    implements XDebugSessionListener {
        private Data myData = null;

        private WarnIfOptimizedListener() {
        }

        public void sessionPaused() {
            this.update();
        }

        public void sessionResumed() {
        }

        public void sessionStopped() {
            this.updateData(this.myData, null);
            this.myData = null;
        }

        public void stackFrameChanged() {
            this.update();
        }

        private void updateData(@Nullable Data data, @Nullable AndroidLLDBDriverConfiguration o) {
            if (data == null) {
                return;
            }
            if (data.editors != null) {
                for (FileEditor editor : data.editors) {
                    editor.putUserData(OptimizedFileNotificationProvider.WARNING_KEY, (Object)o);
                }
            }
            if (data.file != null) {
                EditorNotifications.getInstance((Project)AndroidNativeDebugProcess.this.getProject()).updateNotifications(data.file);
            }
        }

        private Data getData() {
            AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)AndroidNativeDebugProcess.this.myRunParameters.getDebuggerDriverConfiguration();
            if (!configuration.isOptimizedWarningEnabled()) {
                return null;
            }
            XStackFrame frame = AndroidNativeDebugProcess.this.getSession().getCurrentStackFrame();
            if (frame == null) {
                return null;
            }
            XSourcePosition position = frame.getSourcePosition();
            if (position == null) {
                return null;
            }
            if (!((CidrStackFrame)frame).getFrame().getOptimized()) {
                return null;
            }
            return new Data(position.getFile(), FileEditorManager.getInstance((Project)AndroidNativeDebugProcess.this.getProject()).getAllEditors(position.getFile()));
        }

        private void update() {
            Data newData = this.getData();
            if (Objects.equals(this.myData, newData)) {
                return;
            }
            this.updateData(this.myData, null);
            this.updateData(newData, (AndroidLLDBDriverConfiguration)AndroidNativeDebugProcess.this.myRunParameters.getDebuggerDriverConfiguration());
            this.myData = newData;
        }

        private class Data {
            public VirtualFile file;
            public FileEditor[] editors;

            public Data(VirtualFile file, FileEditor[] editors) {
                this.file = file;
                this.editors = editors;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Data)) {
                    return false;
                }
                Data other = (Data)obj;
                return Objects.equals(this.file, other.file) && Arrays.equals(this.editors, other.editors);
            }
        }
    }

    private static interface NativeLibraryVisitor {
        public void visit(@NotNull NativeLibrary var1);

        public void visit(@NotNull NdkModuleModel var1, @NotNull NativeArtifact var2);
    }
}

