/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ClientShellHelper {
    private static final String RUNAS = "run-as";
    private static final String USER_ARG = "--user";
    private final ClientData myClientData;

    public ClientShellHelper(@NotNull Client client) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.myClientData = client.getClientData();
        if (this.isRestrictedUser()) {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(RUNAS, (IShellOutputReceiver)receiver);
            if (!receiver.getOutput().contains(USER_ARG)) {
                throw new IllegalStateException("Native debugging under restricted user is not supported yet.");
            }
        }
    }

    @NotNull
    public String getRunAsCommand(@NotNull String command) {
        String prefix = String.format("%s %s", RUNAS, this.myClientData.getPackageName());
        if (this.isRestrictedUser()) {
            prefix = String.format("%s %s %d", prefix, USER_ARG, this.myClientData.getUserId());
        }
        return prefix + " " + command;
    }

    private boolean isRestrictedUser() {
        return this.myClientData.isValidUserId() && this.myClientData.getUserId() > 0;
    }
}

