/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizedFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> COMPONENT_KEY = Key.create((String)"android.tools.ndk.run.opt.component");
    private static final Key<Object> HIDE_KEY = Key.create((String)"android.tools.ndk.run.opt.hide");
    public static final Key<AndroidLLDBDriverConfiguration> WARNING_KEY = Key.create((String)"android.tools.ndk.run.opt.warning");
    private final Project myProject;

    public OptimizedFileNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return COMPONENT_KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor editor) {
        boolean show;
        AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)((Object)editor.getUserData(WARNING_KEY));
        boolean bl = show = configuration != null && configuration.isOptimizedWarningEnabled() && editor.getUserData(HIDE_KEY) == null;
        if (!show) {
            return null;
        }
        EditorNotificationPanel oldKey = (EditorNotificationPanel)editor.getUserData(this.getKey());
        return oldKey != null ? oldKey : new Panel(file, editor, configuration);
    }

    private class Panel
    extends EditorNotificationPanel {
        private AndroidLLDBDriverConfiguration myConfiguration;

        public Panel(@NotNull VirtualFile file, @NotNull FileEditor editor, AndroidLLDBDriverConfiguration configuration) {
            this.myConfiguration = configuration;
            this.setText("WARNING: This function was compiled with optimizations enabled. Some debugger features may not be available.");
            this.createActionLabel("Hide", () -> {
                editor.putUserData(HIDE_KEY, new Object());
                EditorNotifications.getInstance((Project)OptimizedFileNotificationProvider.this.myProject).updateNotifications(file);
            });
            this.createActionLabel("Do not show this again", () -> {
                this.myConfiguration.disableOptimizedWarning();
                EditorNotifications.getInstance((Project)OptimizedFileNotificationProvider.this.myProject).updateAllNotifications();
            });
            this.createActionLabel("Help", () -> BrowserUtil.browse((String)"https://developer.android.com/r/studio-ui/debugging-with-cpp-flags.html"));
        }
    }
}

