/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.ndk.run.crash.LoggingEventWithAttachments;
import com.android.tools.ndk.run.crash.NativeClientCrashReportingTask;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.diagnostic.LogMessage;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrashLoggingEvent
extends LoggingEventWithAttachments {
    private final String mySignature;
    private final DeviceInfo myDeviceInfo;

    public CrashLoggingEvent(@NotNull String message, @NotNull Throwable throwable, @NotNull List<Attachment> attachments) {
        this(message, throwable, attachments, null, null);
    }

    public CrashLoggingEvent(@NotNull String message, @NotNull Throwable throwable, @NotNull List<Attachment> attachments, @Nullable DeviceInfo deviceInfo, @Nullable String signature) {
        super(message, throwable, attachments);
        this.mySignature = signature;
        this.myDeviceInfo = deviceInfo;
    }

    @Override
    @NotNull
    public LogMessage getData() {
        return new CrashData();
    }

    private class CrashData
    extends LoggingEventWithAttachments.Data
    implements ErrorReportCustomizer {
        private CrashData() {
            super(CrashLoggingEvent.this);
        }

        public Task.Backgroundable makeReportingTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull ErrorBean bean, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback) {
            return new NativeClientCrashReportingTask(project, title, canBeCancelled, bean, callback, errorCallback, CrashLoggingEvent.this.myDeviceInfo, CrashLoggingEvent.this.mySignature);
        }
    }
}

