/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfiguration;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfigurationType;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.javaawarecpp.AndroidJavaAwareNativeDebugProcess;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.ConnectLLDBTask;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebugger
extends AndroidDebuggerImplBase<NativeAndroidDebuggerState> {
    public static final String ID = "Native";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android %s Debugger (%d)";
    private static final Logger LOG = Logger.getInstance(NativeAndroidDebugger.class);
    private static final String JAVA_AWARE_NATIVE_DEBUG_OPTION = "-N";
    static final int MIN_JAVA_AWARE_NATIVE_DEBUG_API_LEVEL = 24;
    public static final Set<Class<? extends XBreakpointType<?, ?>>> NATIVE_BREAKPOINT_TYPES = ImmutableSet.of(CidrLineBreakpointType.class);

    public NativeAndroidDebugger() {
        super(NATIVE_BREAKPOINT_TYPES);
    }

    protected NativeAndroidDebugger(Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeCls) {
        super(breakpointTypeCls);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return this.getId();
    }

    @NotNull
    public NativeAndroidDebuggerState createState() {
        return new NativeAndroidDebuggerState();
    }

    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject(), runConfiguration instanceof AndroidRunConfiguration);
    }

    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull String runConfigTypeId, boolean monitorRemoteProcess) {
        return new ConnectLLDBTask(env, applicationIds, facet, state, this, runConfigTypeId);
    }

    public boolean supportsProject(@NotNull Project project) {
        return NdkProjectInfo.get((Project)project).hasNdkModules();
    }

    public void attachToClient(@NotNull Project project, @NotNull Client client) {
        String clientDescr = client.getClientData().getClientDescription();
        Module module = null;
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            try {
                String packageName = ApkProviderUtil.computePackageName((AndroidFacet)facet);
                if (!clientDescr.startsWith(packageName)) continue;
                module = facet.getModule();
                break;
            }
            catch (ApkProvisionException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (module == null) {
            throw new RuntimeException("Cannot find module by package name");
        }
        if (this.hasExistingSession(project, client)) {
            return;
        }
        DebuggerSession debuggerSession = NativeAndroidDebugger.findJdwpDebuggerSession((Project)project, (String)NativeAndroidDebugger.getClientDebugPort((Client)client));
        if (debuggerSession != null) {
            debuggerSession.getProcess().stop(false);
        }
        AndroidNativeAttachConfigurationType attachConfigurationType = AndroidNativeAttachConfigurationType.getInstance();
        ConfigurationFactory factory = attachConfigurationType.getFactory();
        String runConfigurationName = String.format(RUN_CONFIGURATION_NAME_PATTERN, this.getId(), client.getClientData().getPid());
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(runConfigurationName, factory);
        AndroidNativeAttachConfiguration configuration = (AndroidNativeAttachConfiguration)runSettings.getConfiguration();
        configuration.setClient(client);
        configuration.getAndroidDebuggerContext().setDebuggerType(this.getId());
        ((JavaRunConfigurationModule)configuration.getConfigurationModule()).setModule(module);
        ProgramRunnerUtil.executeConfiguration((Project)project, (RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
    }

    protected static void detachXDebugSession(@NotNull XDebugSession debugSession) {
        RunContentDescriptor descriptor = debugSession.getRunContentDescriptor();
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            processHandler.detachProcess();
        }
    }

    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession = NativeAndroidDebugger.findNativeDebugSession(project, client);
        if (nativeDebugSession != null) {
            return NativeAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        }
        return false;
    }

    @Nullable
    protected static XDebugSession findNativeDebugSession(@NotNull Project project, @NotNull Client client) {
        return NativeAndroidDebugger.findXDebugSession(project, (NotNullFunction<XDebugProcess, Boolean>)((NotNullFunction)debugProcess -> {
            if (!(debugProcess instanceof AndroidNativeAppDebugProcess)) {
                return false;
            }
            AndroidNativeAppDebugProcess nativeDebugProcess = (AndroidNativeAppDebugProcess)((Object)debugProcess);
            return nativeDebugProcess.getClient().getClientData().getPid() == client.getClientData().getPid();
        }));
    }

    @Nullable
    protected static XDebugSession findXDebugSession(@NotNull Project project, @NotNull NotNullFunction<XDebugProcess, Boolean> debugProcessFilter) {
        for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)project).getDebugSessions()) {
            XDebugProcess debugProcess = debugSession.getDebugProcess();
            if (!((Boolean)debugProcessFilter.fun((Object)debugProcess)).booleanValue()) continue;
            return debugSession;
        }
        return null;
    }

    @NotNull
    public String getAmStartOptions(@NotNull NativeAndroidDebuggerState state, @NotNull Project project, @NotNull AndroidVersion version) {
        String baseOptions = super.getAmStartOptions((AndroidDebuggerState)state, project, version);
        if (state.useJavaAwareDebugger() && this.supportsJavaAwareNativeDebugging(version)) {
            return baseOptions + (!baseOptions.isEmpty() ? " " : "") + JAVA_AWARE_NATIVE_DEBUG_OPTION;
        }
        return baseOptions;
    }

    @NotNull
    public synchronized Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes(@NotNull Project project, @NotNull AndroidVersion version) {
        Set bpTypes = super.getSupportedBreakpointTypes(project, version);
        if (this.supportsJavaAwareNativeDebugging(version)) {
            bpTypes.addAll(AndroidJavaAwareNativeDebugProcess.getJavaBreakpointTypes());
        }
        return bpTypes;
    }

    public boolean supportsJavaAwareNativeDebugging(@NotNull AndroidVersion version) {
        return version.getFeatureLevel() >= 24;
    }

    @NotNull
    public AndroidNativeDebugProcess newAndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull JdwpConnector jdwpConnector, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws ExecutionException {
        if (client.getClientData().isNativeDebuggable()) {
            return new AndroidJavaAwareNativeDebugProcess(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop);
        }
        return new AndroidNativeAppDebugProcess(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop);
    }

    @NotNull
    protected static String prepareSetSettingsCommand(String ... options) {
        return "settings set " + StringUtil.join((String[])options, (String)" ");
    }

    @NotNull
    public List<String> getStartupCommands(@NotNull AndroidFacet facet, @Nullable Client client) {
        Collection javaDirs = facet.getMainSourceProvider().getJavaDirectories();
        boolean enableJIT = client != null && client.getClientData().isNativeDebuggable() && !javaDirs.isEmpty();
        return Lists.newArrayList((Object[])new String[]{NativeAndroidDebugger.prepareSetSettingsCommand("auto-confirm", "true"), NativeAndroidDebugger.prepareSetSettingsCommand("plugin.symbol-file.dwarf.comp-dir-symlink-paths", "/proc/self/cwd"), NativeAndroidDebugger.prepareSetSettingsCommand("plugin.jit-loader.gdb.enable-jit-breakpoint", Boolean.toString(enableJIT))});
    }

    @NotNull
    public List<String> getPostAttachCommands(@NotNull AndroidFacet facet, @Nullable Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        LinkedList cmds = Lists.newLinkedList();
        Collection javaDirs = facet.getMainSourceProvider().getJavaDirectories();
        Map<String, String> sourceMap = AndroidNativeDebugProcess.getSourceMap(facet);
        if (client != null && client.getClientData().isNativeDebuggable() && !javaDirs.isEmpty()) {
            String firstJavaDir = NativeAndroidDebugger.getFirstAbsolutePath(javaDirs);
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("target.move-to-nearest-code", "false"));
            sourceMap.put("$JAVA_SRC_ROOT", firstJavaDir);
            if (javaDirs.size() > 1) {
                printer.stderr("The project has more than one Java source directories.\nBreakpoints in source files in " + firstJavaDir + " will only be active.");
            }
        }
        if (!sourceMap.isEmpty()) {
            ArrayList<String> arguments = new ArrayList<String>(sourceMap.size() * 2);
            for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
                arguments.add("\"" + entry.getKey() + "\"");
                arguments.add("\"" + entry.getValue() + "\"");
            }
            String argumentsStr = StringUtil.join(arguments, (String)" ");
            LOG.info("Set target.source-map: " + argumentsStr);
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("target.source-map", argumentsStr));
        }
        cmds.add(NativeAndroidDebugger.prepareSetSettingsCommand("target.process.thread.step-avoid-regexp", "''"));
        cmds.add("type format add --format boolean jboolean");
        return cmds;
    }

    @NotNull
    private static String getFirstAbsolutePath(@NotNull Collection<File> dirs) {
        File f = (File)ContainerUtil.getFirstItem(dirs);
        assert (f != null);
        return f.getAbsolutePath();
    }

    static {
        CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED = false;
    }
}

