/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.google.common.collect.Lists;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class StringListEntryPanel
extends JPanel {
    private final JBTable myOptionsList;
    private StringListTableModel myEntriesModel = new StringListTableModel(Collections.emptyList());

    public StringListEntryPanel() {
        super(new BorderLayout());
        this.myOptionsList = new JBTable((TableModel)this.myEntriesModel);
        this.myOptionsList.setTableHeader(null);
        this.myOptionsList.setShowGrid(false);
        this.myOptionsList.setSelectionMode(0);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myOptionsList).setAddAction(button -> {
            this.myEntriesModel.add("");
            this.myOptionsList.editCellAt(this.myEntriesModel.getLastRowIndex(), 0);
        }).setRemoveAction(button -> {
            if (this.myOptionsList.getSelectedRowCount() > 0) {
                int selectedRow = this.myOptionsList.getSelectedRow();
                this.myEntriesModel.removeRow(selectedRow);
                if (selectedRow < this.myEntriesModel.getRowCount()) {
                    this.myOptionsList.changeSelection(selectedRow, 0, false, false);
                } else if (selectedRow > 0) {
                    this.myOptionsList.changeSelection(selectedRow - 1, 0, false, false);
                }
            }
        }).setMoveDownAction(button -> {
            int selectedRow = this.myOptionsList.getSelectedRow();
            if (selectedRow > -1 && selectedRow < this.myEntriesModel.getRowCount() - 1) {
                this.myEntriesModel.moveRow(selectedRow, selectedRow, selectedRow + 1);
                this.myOptionsList.changeSelection(selectedRow + 1, 0, false, false);
            }
        }).setMoveUpAction(button -> {
            int selectedRow = this.myOptionsList.getSelectedRow();
            if (selectedRow > 0) {
                this.myEntriesModel.moveRow(selectedRow, selectedRow, selectedRow - 1);
                this.myOptionsList.changeSelection(selectedRow - 1, 0, false, false);
            }
        });
        this.add(decorator.createPanel());
    }

    @NotNull
    public List<String> getEntries() {
        return this.myEntriesModel.getEntries();
    }

    public void setEntries(@NotNull List<String> entries) {
        this.myEntriesModel = new StringListTableModel(entries);
        this.myOptionsList.setModel((TableModel)this.myEntriesModel);
    }

    private class StringListTableModel
    extends DefaultTableModel {
        public StringListTableModel(List<String> entries) {
            super(0, 1);
            for (String entry : entries) {
                this.add(entry);
            }
        }

        public void add(@NotNull String entry) {
            this.addRow(new String[]{entry});
        }

        public int getLastRowIndex() {
            return this.getRowCount() - 1;
        }

        @NotNull
        public List<String> getEntries() {
            ArrayList entries = Lists.newArrayListWithCapacity((int)this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                entries.add((String)this.getValueAt(i, 0));
            }
            return entries;
        }
    }
}

