/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.DeviceHelper;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.LibStdCppTypeNameFormatters;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.google.wireless.android.sdk.stats.LldbPercentileEstimator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final String[] STARTUP_SCRIPTS = new String[]{ModulePathManager.getRepoLLDBStlPrintersBinFile("load_script").getPath()};
    private static final int CONNECT_PLATFORM_NUM_RETRIES = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final Collection<File> mySymDirs;
    private final SessionStarter mySessionStarter;
    private String myPlatformConnectURL;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    private boolean myCrashed = false;
    private final boolean myDeviceSupportsWatchpoints;
    private CommandOutputListener myOutputListener = null;
    private static final Set<String> WATCHPOINT_WHITELISTED_MODELS = Sets.newHashSet((Object[])new String[]{"Nexus 9"});
    private static final Set<Abi> WATCHPOINT_WHITELISTED_ABIS = ImmutableSet.of((Object)Abi.X86, (Object)Abi.X86_64);
    private boolean myReportedWatchpointsUsage = false;
    private Stopwatch attachStopwatch = Stopwatch.createUnstarted();
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AndroidLLDBDriverConfiguration configuration, @NotNull ConsolePrinter printer) {
        super(handler, (LLDBDriverConfiguration)configuration);
        IDevice device = configuration.getDevice();
        this.mySessionStarter = configuration.getSessionStarter();
        this.myStartupCommands = configuration.getStartupCommands();
        this.myPostAttachCommands = configuration.getPostAttachCommands();
        this.mySymDirs = AndroidNativeDebugProcess.getSymbolsDir(facet, debuggerState, configuration.getClientABIs());
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            printer.stderr("Attention! No symbol directories found - please check your native debug configuration");
        }
        this.myDeviceSupportsWatchpoints = AndroidLLDBDriver.deviceSupportsWatchpoints(device);
    }

    private static boolean deviceSupportsWatchpoints(@NotNull IDevice device) {
        String model = device.getProperty("ro.product.model");
        if (WATCHPOINT_WHITELISTED_MODELS.contains(model)) {
            return true;
        }
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null || !WATCHPOINT_WHITELISTED_ABIS.contains(abi)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getWatchpointWhitelist() {
        return String.format("%s based devices/emulators, %s", WATCHPOINT_WHITELISTED_ABIS, WATCHPOINT_WHITELISTED_MODELS);
    }

    public void loadForLaunch() throws ExecutionException {
        LOG.info("Loading driver");
        LOG.debug("Load startup scripts");
        this.loadStartupScripts();
        this.loadJObjectPrettyPrinterScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runStartupCommands();
        this.myTargetCommandLine = this.myInstaller.install();
        LOG.debug("connectPlatform");
        LLDBDriverException lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.connectPlatform();
                lastException = null;
                break;
            }
            catch (LLDBDriverException e2) {
                lastException = e2;
                LOG.warn("failed to connect platform - retrying");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (this.myTargetCommandLine.getExePath().isEmpty()) {
            LOG.info("create empty target");
            this.createEmptyTarget();
        } else {
            LOG.info("create remote target");
            this.createRemoteTarget();
        }
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath() + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Set target.exec-search-paths: " + searchPathsStr);
            this.executeConsoleCommand("settings set target.exec-search-paths " + searchPathsStr);
        }
    }

    public void loadForAttach() throws ExecutionException {
        this.loadForLaunch();
    }

    public long launch() throws ExecutionException {
        final Ref launchedPid = new Ref();
        LLDBDriver.ThrowIfNotValid<Protocol.Launch_Res> responseHandler = new LLDBDriver.ThrowIfNotValid<Protocol.Launch_Res>("Couldn't launch process"){

            public void consume(Protocol.Launch_Res message) {
                super.consume((GeneratedMessage)message);
                if (this.isValid()) {
                    launchedPid.set((Object)message.getPid());
                }
            }
        };
        assert (this.myTargetCommandLine != null) : "Not Installed";
        Protocol.CompositeRequest launchReq = ProtobufMessageFactory.launch((GeneralCommandLine)this.myTargetCommandLine, null, null, null);
        this.printTargetCommandLine(this.myTargetCommandLine);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)launchReq, Protocol.Launch_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
        this.runPostAttachCommands();
        this.handlePrompt();
        return (Long)launchedPid.get();
    }

    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        super.setValuesFilteringEnabled(true);
    }

    private void runCommands(@NotNull String name, @NotNull List<String> commands) throws ExecutionException {
        for (String cmd : commands) {
            String trimmed_cmd = cmd.trim();
            if (trimmed_cmd.isEmpty()) continue;
            LOG.info(String.format("%s command: \"%s\"", name, trimmed_cmd));
            this.executeConsoleCommand(trimmed_cmd);
        }
    }

    private void runStartupCommands() throws ExecutionException {
        this.runCommands("Startup", this.myStartupCommands);
    }

    private void runPostAttachCommands() throws ExecutionException {
        this.runCommands("Post attach", this.myPostAttachCommands);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeConsoleCommand(envCommand);
            ++i;
        }
    }

    private void loadStartupScripts() throws ExecutionException {
        for (String script : STARTUP_SCRIPTS) {
            LOG.info("Loading startup script: " + script);
            this.executeConsoleCommand("command source \"" + script + "\"");
        }
    }

    private void loadJObjectPrettyPrinterScripts() throws ExecutionException {
        int deviceApiLevel = this.mySessionStarter.getDevice().getVersion().getApiLevel();
        String isDalvik = DeviceHelper.RuntimeVersion.DALVIK.equals((Object)DeviceHelper.getRuntime(this.mySessionStarter.getDevice())) ? "True" : "False";
        File scriptPath = new File(ModulePathManager.getRepoLLDBPrettyPrinterScriptsFolder(), "jstring_reader.py");
        LOG.info("Loading startup script: " + scriptPath);
        this.executeConsoleCommand("command script import \"" + scriptPath + "\"");
        this.executeConsoleCommand(String.format("script jstring_reader.register(%d, %s)", deviceApiLevel, isDalvik));
    }

    private void createEmptyTarget() throws ExecutionException {
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't create target");
        Protocol.CompositeRequest createTargetReq = ProtobufMessageFactory.createTarget((String)"", (String)"");
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)createTargetReq, Protocol.CreateTarget_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    private void createRemoteTarget() throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget((String)this.myInstaller.getExecutableFile().getAbsolutePath(), (String)PLATFORM_NAME, (String)this.myTargetCommandLine.getExePath()));
    }

    private void connectPlatform() throws ExecutionException {
        if (this.myPlatformConnectURL == null) {
            this.myPlatformConnectURL = this.mySessionStarter.startServer();
        }
        LOG.info("Connecting to LLDB server: " + this.myPlatformConnectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)this.myPlatformConnectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)connectPlatformReq, Protocol.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public void start(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        this.attachStopwatch.reset().start();
        super.start(installer, architecture);
        AndroidLLDBBreakpadIntegration.monitorForCrashes(this);
    }

    public boolean isCrashed() {
        return this.myCrashed;
    }

    public void setCrashed() {
        this.myCrashed = true;
    }

    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        if (!this.myDeviceSupportsWatchpoints) {
            throw new DebuggerCommandException("You are debugging on a device that is not known to support watchpoints - supported devices include " + AndroidLLDBDriver.getWatchpointWhitelist());
        }
        if (!this.myReportedWatchpointsUsage) {
            this.myReportedWatchpointsUsage = true;
            LLDBUsageTracker.sessionUsedWatchpoints();
        }
        return super.addWatchpoint(threadId, frameNumber, value, expr, lifetime, accessType);
    }

    private boolean isTargetDead() {
        DebuggerDriver.TargetState targetState = this.getState();
        return targetState.equals((Object)DebuggerDriver.TargetState.FINISHED);
    }

    public void attachTo(int pid) throws ExecutionException {
        super.attachTo(pid);
        this.runPostAttachCommands();
    }

    public void detach() throws ExecutionException {
        if (this.isTargetDead()) {
            LOG.warn("Target is dead - skip detach request");
            return;
        }
        super.detach();
    }

    public boolean abort() throws ExecutionException {
        if (this.isTargetDead()) {
            LOG.warn("Target is dead - skip abort request");
            return false;
        }
        return super.abort();
    }

    protected void handleExited(int code) {
        super.handleExited(code);
        LLDBUsageTracker.frontendExited(code);
    }

    protected void handleAttached(int pid) {
        if (this.attachStopwatch.isRunning()) {
            this.attachStopwatch.stop();
            LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ATTACH_TIME_MICROS, this.attachStopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        super.handleAttached(pid);
    }

    protected void handleGDBOutput(@NotNull String output) {
        if (this.myOutputListener != null) {
            this.myOutputListener.addOutput(output);
        }
        super.handleGDBOutput(output);
    }

    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.addBreakpoint(path, line, condition);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        LLSymbolicBreakpoint ret = super.addSymbolicBreakpoint(symBreakpoint);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_SYMBOLIC_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getFrames(threadId, from, count, untilFirstLineWithCode);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_FRAMES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.getVariables(threadId, frameIndex);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getVariableChildren(value, from, count);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLE_CHILDREN_RANGE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    public void stepOver() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOver();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepInto() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepInto();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepOut() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOut();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public boolean resume() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        boolean ret = super.resume();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public String executeConsoleCommandWithOutput(long threadId, int frameIndex, String command) throws ExecutionException {
        this.setUpOutputListener();
        this.executeConsoleCommand(threadId, frameIndex, command);
        return this.tearDownOutputListener();
    }

    private void setUpOutputListener() {
        this.myOutputListener = new CommandOutputListener();
    }

    @NotNull
    private String tearDownOutputListener() {
        CommandOutputListener listener = this.myOutputListener;
        this.myOutputListener = null;
        return listener.toString();
    }

    static {
        LibStdCppTypeNameFormatters.register();
    }

    private static class CommandOutputListener {
        private StringBuilder myBuilder = new StringBuilder();

        private CommandOutputListener() {
        }

        public void addOutput(@NotNull String text) {
            this.myBuilder.append(text);
        }

        public String toString() {
            return this.myBuilder.toString();
        }
    }
}

