/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.SyncService;
import com.android.sdklib.devices.Abi;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.AutoAndroidDebuggerState;
import com.android.tools.ndk.run.editor.HybridAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.InjectorSessionStarterImpl;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.RunAsSessionStarterImpl;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.ShellSessionStarterImpl;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectLLDBTask
extends ConnectDebuggerTask {
    private static final Logger LOG = Logger.getInstance(ConnectLLDBTask.class);
    private final String mySessionId;
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    protected final AndroidFacet myFacet;
    @NotNull
    protected final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final String myRunConfigTypeId;
    @NotNull
    private final NativeAndroidDebugger myNativeDebugger;
    protected ProgressReporter myProgressReporter;
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Native Debugger", (String)ToolWindowId.DEBUG);

    public ConnectLLDBTask(@NotNull ExecutionEnvironment env, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull NativeAndroidDebugger debugger, @NotNull String runConfigTypeId) {
        super(applicationIds, (AndroidDebugger)debugger, facet.getModule().getProject(), true);
        this.myEnv = env;
        this.myFacet = facet;
        this.myDebuggerState = state;
        this.myRunConfigTypeId = runConfigTypeId;
        this.myNativeDebugger = debugger;
        this.mySessionId = UUID.randomUUID().toString();
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        return super.isReadyForDebugging(client, printer) && client.isDdmAware();
    }

    protected boolean isDetachOnStop() {
        return false;
    }

    SessionStarterType decideStarterImplementation(Client client) throws ExecutionException {
        boolean restrictedPtraceScope;
        if (Boolean.getBoolean("lldb.session-starter.runas")) {
            return SessionStarterType.RUN_AS_SHELL;
        }
        int ptraceScope = ConnectLLDBTask.getPtraceScope(client.getDevice());
        boolean bl = restrictedPtraceScope = ptraceScope > 0;
        if (restrictedPtraceScope) {
            LOG.warn(String.format("YAMA is on - ptrace_scope set to %d.  Using injector to start debug session", ptraceScope));
            return SessionStarterType.INJECTOR_YAMA;
        }
        if (Boolean.getBoolean("lldb.session-starter.jdwp")) {
            LOG.warn("Using injector to start debug session due to system property");
            return SessionStarterType.INJECTOR;
        }
        if (ConnectLLDBTask.isRootedDevice(client.getDevice())) {
            LOG.warn("Rooted device, using shell to start debug session");
            return SessionStarterType.ROOT_SHELL;
        }
        if (ConnectLLDBTask.isRunAsOK(client)) {
            LOG.warn("Using run-as to start debug session");
            return SessionStarterType.RUN_AS_SHELL;
        }
        LOG.warn("Non-rooted device, run-as not working, resorting to injector to start debug session");
        return SessionStarterType.INJECTOR;
    }

    @Nullable
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CommonMetricsData.getOsArchitecture().equals((Object)ProductDetails.CpuArchitecture.X86) || Boolean.getBoolean("lldb.fail_arch_check")) {
            StringBuilder message = new StringBuilder("Native debugging is not supported on 32-bit architectures.\n");
            if (this.myNativeDebugger instanceof HybridAndroidDebugger) {
                if (this.myDebuggerState instanceof AutoAndroidDebuggerState) {
                    message.append("Auto debugger mode selected the Dual debugger.");
                } else {
                    message.append("You are using the Dual debugger.");
                }
            }
            message.append("You can continue to debug Java code by using the Java debugger.");
            NOTIFICATION_GROUP.createNotification(message.toString(), NotificationType.ERROR).notify(this.myProject);
            launchStatus.terminateLaunch(message.toString());
            ConnectLLDBTask.forceStopActivity(client);
            return null;
        }
        this.myProgressReporter = new ProgressReporter(this.myEnv.getProject());
        String prettyConfigName = this.getPrettyConfigurationName(client);
        IDevice device = client.getDevice();
        String deviceModel = device.getProperty("ro.product.model");
        String deviceAPILevel = device.getProperty("ro.build.version.sdk");
        String deviceCodename = device.getProperty("ro.build.version.codename");
        String deviceManufacturer = device.getProperty("ro.product.manufacturer");
        LOG.info(String.format("Launching %s native debug session on device: manufacturer=%s, model=%s, API=%s, codename=%s, ABIs=%s", prettyConfigName, deviceManufacturer, deviceModel, deviceAPILevel, deviceCodename, device.getAbis().toString()));
        try {
            SessionStarterType sessionStarterType = this.decideStarterImplementation(client);
            LLDBUsageTracker.sessionStarted(device, this.getDebuggerType(), this.mySessionId, this.debuggerTypeChosenByAuto(), sessionStarterType);
            return this.launchCidrDebugger(currentLaunchInfo, client, sessionStarterType, launchStatus, printer);
        }
        catch (Throwable e) {
            this.onLaunchFailure((LaunchStatus)launchStatus, client, "Error while starting native debug session: " + e.toString(), e);
            return null;
        }
    }

    @NotNull
    private static File createPtraceScopeTempFile() throws IOException {
        File file = File.createTempFile("ptrace_scope", Long.toString(System.currentTimeMillis()));
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPtraceScope(@NotNull IDevice device) {
        SyncService syncService = null;
        File localPtraceScopeFile = null;
        try {
            syncService = device.getSyncService();
            if (syncService == null) {
                throw new ExecutionException("Failed to get SyncService");
            }
            SyncService.FileStat ptraceScopeStat = syncService.statFile("/proc/sys/kernel/yama/ptrace_scope");
            if (ptraceScopeStat == null || ptraceScopeStat.getMode() == 0) {
                int n = 0;
                return n;
            }
            localPtraceScopeFile = ConnectLLDBTask.createPtraceScopeTempFile();
            device.pullFile("/proc/sys/kernel/yama/ptrace_scope", localPtraceScopeFile.getPath());
            int n = Integer.parseInt(com.google.common.io.Files.toString((File)localPtraceScopeFile, (Charset)Charsets.UTF_8).trim());
            return n;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        finally {
            if (localPtraceScopeFile != null) {
                try {
                    Files.delete(localPtraceScopeFile.toPath());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            if (syncService != null) {
                syncService.close();
            }
        }
        return -1;
    }

    @NotNull
    private SessionStarter newSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull List<Abi> clientABIs, @NotNull SessionStarterType type, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        AndroidNativeDebugProcess.verifyNativeModel(this.myFacet, clientABIs, printer);
        File lldbServer = ModulePathManager.findLLDBServer(this.myFacet, this.myDebuggerState, clientABIs);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException(String.format("LLDB server for architecture '%s' not found", clientABIs.get(0)));
        }
        LOG.info(String.format("Found LLDB server: \"%s\"", lldbServer.getAbsolutePath()));
        File startServerScript = ModulePathManager.getSdkLLDBAndroidFile("start_lldb_server.sh");
        switch (type) {
            case INJECTOR: 
            case INJECTOR_YAMA: {
                return this.newInjectorSessionStarter(jdwpConnector, client, type == SessionStarterType.INJECTOR_YAMA, lldbServer, startServerScript, launchStatus, printer);
            }
            case ROOT_SHELL: {
                return this.newShellSessionStarter(jdwpConnector, client.getDevice(), lldbServer, startServerScript, launchStatus, printer);
            }
            case RUN_AS_SHELL: {
                return this.newRunAsSessionStarter(jdwpConnector, client, lldbServer, startServerScript, launchStatus, printer);
            }
        }
        throw new IllegalStateException("SessionStarterType was not recognized");
    }

    private static void resumeVMOnSessionStarted(@NotNull SessionStarter sessionStarter, @NotNull JdwpConnector jdwpConnector) {
        sessionStarter.addEventListener(jdwpConnector::Connect);
    }

    @NotNull
    private SessionStarter newShellSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull IDevice device, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        ShellSessionStarterImpl sessionStarter = new ShellSessionStarterImpl(device, serverPath, startScriptPath, this.myDebuggerState, this.myProgressReporter, launchStatus, printer);
        ConnectLLDBTask.resumeVMOnSessionStarted(sessionStarter, jdwpConnector);
        return sessionStarter;
    }

    @NotNull
    private SessionStarter newRunAsSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        RunAsSessionStarterImpl sessionStarter = new RunAsSessionStarterImpl(client, serverPath, startScriptPath, this.myDebuggerState, this.myProgressReporter, launchStatus, printer);
        ConnectLLDBTask.resumeVMOnSessionStarted(sessionStarter, jdwpConnector);
        return sessionStarter;
    }

    @NotNull
    private SessionStarter newInjectorSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, boolean restrictedPtraceScope, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        return new InjectorSessionStarterImpl(jdwpConnector, client, restrictedPtraceScope, serverPath, startScriptPath, this.myDebuggerState, this.myProgressReporter, launchStatus, printer);
    }

    private static boolean isRunAsOK(@NotNull Client client) throws ExecutionException {
        try {
            ClientShellHelper shellHelper = new ClientShellHelper(client);
            IDevice device = client.getDevice();
            String deviceModel = device.getProperty("ro.product.model");
            if (deviceModel == null) {
                return false;
            }
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(shellHelper.getRunAsCommand(String.format("getprop %s", "ro.product.model")), (IShellOutputReceiver)receiver);
            return receiver.getOutput().trim().contains(deviceModel);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected static boolean isRootedDevice(@NotNull IDevice device) throws ExecutionException {
        try {
            return device.isRoot();
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private static int getClientAddressByteSize(@NotNull Client client) {
        String abi = client.getClientData().getAbi();
        if (abi != null && abi.startsWith("64-bit")) {
            return 8;
        }
        return 4;
    }

    @NotNull
    private static List<Abi> getClientABIs(@NotNull Client client) {
        int clientAddrByteSize = ConnectLLDBTask.getClientAddressByteSize(client);
        if (clientAddrByteSize <= 0) {
            LOG.warn("Failed to get client address byte size from ABI: " + client.getClientData().getAbi());
        }
        LinkedList abis = Lists.newLinkedList();
        IDevice device = client.getDevice();
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + abiStr);
                continue;
            }
            if (clientAddrByteSize > 0) {
                if (abi.getAddressSizeInBytes() != clientAddrByteSize) continue;
                abis.add(abi);
                continue;
            }
            abis.add(abi);
        }
        LOG.info("ABIs supported by app: " + ((Object)abis).toString());
        return abis;
    }

    @NotNull
    private RunParameters newRunParameters(@NotNull Client client, @NotNull List<Abi> clientABIs, @NotNull SessionStarter sessionStarter, @NotNull ProcessHandlerConsolePrinter printer) {
        final IDevice device = client.getDevice();
        final AndroidLLDBDriverConfiguration configuration = new AndroidLLDBDriverConfiguration(this.myFacet, this.myDebuggerState, (ConsolePrinter)printer, device, clientABIs, sessionStarter, this.getStartupCommands(client), this.getPostAttachCommands(client, printer));
        return new RunParameters(){

            @NotNull
            public Installer getInstaller() {
                return new TrivialInstaller(new GeneralCommandLine(new String[]{""}));
            }

            @NotNull
            public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                return configuration;
            }

            @NotNull
            public String getArchitectureId() {
                return NdkHelper.getArchitectureId(NdkHelper.getAbi(device));
            }
        };
    }

    @NotNull
    protected JdwpConnector newJdwpConnector(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull XDebugSession session) {
        return new JdwpConnector(currentLaunchInfo, this.myFacet, client, session, true);
    }

    private ProcessHandler launchCidrDebugger(final @NotNull LaunchInfo currentLaunchInfo, final @NotNull Client client, final @NotNull SessionStarterType sessionStarterType, final @NotNull ProcessHandlerLaunchStatus launchStatus, final @NotNull ProcessHandlerConsolePrinter printer) throws ExecutionException {
        AndroidSessionInfo newInfo;
        CidrRunner cidrRunner = new CidrRunner(){

            @NotNull
            public String getRunnerId() {
                return "AndroidNativeDebugRunner2";
            }
        };
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myEnv).executor(this.myEnv.getExecutor()).runner((ProgramRunner)cidrRunner).contentToReuse(this.myEnv.getContentToReuse()).build();
        CidrCommandLineState cidrState = new CidrCommandLineState(env, new CidrLauncher(){

            public ProcessHandler createProcess(@NotNull CommandLineState state) {
                throw new RuntimeException("start process not implemented");
            }

            @NotNull
            public CidrDebugProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
                SessionStarter sessionStarter;
                List clientABIs = ConnectLLDBTask.getClientABIs(client);
                JdwpConnector jdwpConnector = ConnectLLDBTask.this.newJdwpConnector(currentLaunchInfo, client, session);
                try {
                    sessionStarter = ConnectLLDBTask.this.newSessionStarter(jdwpConnector, client, clientABIs, sessionStarterType, launchStatus, (ConsolePrinter)printer);
                }
                catch (Exception e) {
                    throw new ExecutionException((Throwable)e);
                }
                RunParameters runParameters = ConnectLLDBTask.this.newRunParameters(client, clientABIs, sessionStarter, printer);
                AndroidNativeDebugProcess result = ConnectLLDBTask.this.myNativeDebugger.newAndroidNativeAppDebugProcess(ConnectLLDBTask.this.mySessionId, runParameters, session, state.getConsoleBuilder(), (ConsolePrinter)printer, sessionStarter, client, jdwpConnector, ConnectLLDBTask.this.myProgressReporter, ConnectLLDBTask.this.isDetachOnStop());
                ProcessTerminatedListener.attach((ProcessHandler)result.getProcessHandler(), (Project)ConnectLLDBTask.this.myEnv.getProject());
                return result;
            }

            @NotNull
            protected Project getProject() {
                return ConnectLLDBTask.this.myEnv.getProject();
            }
        });
        printer.stdout("Now Launching Native Debug Session");
        this.myProgressReporter.step("Launching debug session");
        XDebugSessionImpl xDebugSession = (XDebugSessionImpl)cidrRunner.startDebugSession(cidrState, env, false, new XDebugSessionListener[0]);
        ProcessHandler oldProcessHandler = launchStatus.getProcessHandler();
        ProcessHandler newProcessHandler = xDebugSession.getRunContentDescriptor().getProcessHandler();
        if (newProcessHandler == null) {
            throw new ExecutionException("Cannot start debugging - null process handler.");
        }
        AndroidSessionInfo oldInfo = (AndroidSessionInfo)oldProcessHandler.getUserData(AndroidSessionInfo.KEY);
        if (oldInfo != null) {
            newInfo = new AndroidSessionInfo(newProcessHandler, oldInfo.getDescriptor(), oldInfo.getRunConfigurationId(), oldInfo.getExecutorId(), oldInfo.getExecutorActionName(), oldInfo.isInstantRun());
        } else {
            RunProfile runProfile = env.getRunProfile();
            int uniqueId = runProfile instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
            newInfo = new AndroidSessionInfo(newProcessHandler, xDebugSession.getRunContentDescriptor(), uniqueId, env.getExecutor().getId(), env.getExecutor().getActionName(), InstantRunUtils.isInstantRunEnabled((ExecutionEnvironment)env));
        }
        newProcessHandler.putUserData(AndroidSessionInfo.KEY, (Object)newInfo);
        launchStatus.setProcessHandler(newProcessHandler);
        printer.setProcessHandler(newProcessHandler);
        oldProcessHandler.detachProcess();
        AndroidProcessText oldText = AndroidProcessText.get((ProcessHandler)oldProcessHandler);
        if (oldText != null) {
            oldText.printTo(newProcessHandler);
        }
        xDebugSession.showSessionTab();
        return newProcessHandler;
    }

    @NotNull
    private String getPrettyConfigurationName(@NotNull Client client) {
        LinkedList items = Lists.newLinkedList();
        items.add(this.myRunConfigTypeId);
        items.add(this.myDebugger.getId());
        if (client.getClientData().isNativeDebuggable()) {
            items.add("java_aware_cpp");
        }
        return StringUtil.join((Collection)items, (String)":");
    }

    private void onLaunchFailure(@NotNull LaunchStatus launchStatus, @NotNull Client client, @NotNull String message, @NotNull Throwable e) {
        launchStatus.terminateLaunch(message);
        LOG.warn(message, e);
        LLDBUsageTracker.sessionFailed(e, this.mySessionId, 0L);
        this.myProgressReporter.finish();
        ConnectLLDBTask.forceStopActivity(client);
    }

    private static void forceStopActivity(@NotNull Client client) {
        String packageName = client.getClientData().getClientDescription();
        try {
            IDevice device = client.getDevice();
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            device.executeShellCommand("am force-stop " + packageName, (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            LOG.info("Failed to force-stop activity " + packageName, (Throwable)e);
        }
    }

    @NotNull
    private List<String> getStartupCommands(@NotNull Client client) {
        return Stream.concat(this.myNativeDebugger.getStartupCommands(this.myFacet, client).stream(), this.myDebuggerState.getUserStartupCommands().stream()).collect(Collectors.toList());
    }

    @NotNull
    private List<String> getPostAttachCommands(@NotNull Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        return Stream.concat(this.myNativeDebugger.getPostAttachCommands(this.myFacet, client, printer).stream(), this.myDebuggerState.getUserPostAttachCommands().stream()).collect(Collectors.toList());
    }

    private boolean debuggerTypeChosenByAuto() {
        return this.myDebuggerState instanceof AutoAndroidDebuggerState;
    }

    private AndroidStudioEvent.DebuggerType getDebuggerType() {
        if (this.myDebugger instanceof HybridAndroidDebugger) {
            return AndroidStudioEvent.DebuggerType.HYBRID;
        }
        if (this.myDebugger instanceof NativeAndroidDebugger) {
            return AndroidStudioEvent.DebuggerType.NATIVE;
        }
        return AndroidStudioEvent.DebuggerType.UNKNOWN_DEBUGGER_TYPE;
    }

    public static enum SessionStarterType {
        ROOT_SHELL,
        RUN_AS_SHELL,
        INJECTOR,
        INJECTOR_YAMA;

    }
}

