/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class SessionStarter {
    private static final Logger LOG = Logger.getInstance(SessionStarter.class);
    protected final IDevice myDevice;
    protected final NativeAndroidDebuggerState myDebuggerState;
    private final String myPlatformSocketName;
    protected final ProgressReporter myProgressReporter;
    protected final ProcessHandlerLaunchStatus myLaunchStatus;
    protected final ConsolePrinter myPrinter;
    protected final File myLocalServerFile;
    protected final File myLocalStartScriptFile;
    protected FileStat myServerTempFile;
    protected FileStat myStartScriptTempFile;
    private final List<EventListener> myEventListeners = Lists.newLinkedList();
    private boolean mySessionStarted = false;

    protected SessionStarter(@NotNull IDevice device, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        this.myDevice = device;
        this.myDebuggerState = debuggerState;
        this.myPlatformSocketName = String.format("platform-%d.sock", System.currentTimeMillis());
        this.myProgressReporter = progressReporter;
        this.myLaunchStatus = launchStatus;
        this.myPrinter = printer;
        this.myLocalServerFile = localServerFile;
        this.myLocalStartScriptFile = localStartScriptFile;
    }

    public void pushFilesToDevice() throws ExecutionException {
        LOG.info("Pushing files to device");
        this.myProgressReporter.step("Pushing files to device");
        try (SyncService syncService = null;){
            syncService = this.myDevice.getSyncService();
            if (syncService == null) {
                throw new ExecutionException("Failed to get SyncService");
            }
            this.myServerTempFile = this.pushDebuggerFile(syncService, this.myLocalServerFile);
            this.myStartScriptTempFile = this.pushDebuggerFile(syncService, this.myLocalStartScriptFile);
        }
    }

    @NotNull
    public List<Attachment> getLogFilesFromDevice() {
        String[] files = new String[]{"gdb-server.log", "platform.log"};
        ArrayList<Attachment> result = new ArrayList<Attachment>(files.length);
        for (String targetFile : files) {
            String contents;
            String targetPath = this.getTargetLogFilePath(targetFile);
            try {
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                this.myDevice.executeShellCommand("cat '" + targetPath + "'", (IShellOutputReceiver)receiver, 30L, TimeUnit.SECONDS);
                contents = receiver.getOutput();
            }
            catch (Exception e) {
                contents = e.toString();
            }
            result.add(new Attachment(targetPath, contents));
        }
        return result;
    }

    public String startServer() throws ExecutionException {
        String startCmd = this.getStartCommandLine();
        this.myProgressReporter.step("Starting LLDB server");
        this.internalStartServer();
        return this.getConnectUrl();
    }

    protected abstract void internalStartServer() throws ExecutionException;

    @NotNull
    protected String getStartCommandLine() {
        return String.format("%s %s %s %s %s \"%s\"", this.getStartScriptTargetPath(), this.getTargetRootDirectory(), "unix-abstract", this.getTargetSocketDirectory(), this.myPlatformSocketName, this.myDebuggerState.getTargetLoggingChannels());
    }

    @NotNull
    protected String getConnectUrl() {
        return String.format("%s-connect://[%s]%s/%s", "unix-abstract", this.myDevice.getSerialNumber(), this.getTargetSocketDirectory(), this.myPlatformSocketName);
    }

    @NotNull
    protected abstract String getTargetDataDir();

    @NotNull
    protected String getTargetRootDirectory() {
        return SessionStarter.joinPaths(this.getTargetDataDir(), "lldb");
    }

    @NotNull
    protected String getTargetBinDirectory() {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "bin");
    }

    @NotNull
    protected String getTargetLogDirectory() {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "log");
    }

    @NotNull
    protected String getTargetLogFilePath(@NotNull String file) {
        return SessionStarter.joinPaths(this.getTargetLogDirectory(), file);
    }

    @NotNull
    protected String getTargetBinFilePath(@NotNull String filePath) {
        return SessionStarter.joinPaths(this.getTargetBinDirectory(), filePath);
    }

    @NotNull
    protected String getStartScriptTargetPath() {
        return this.getTargetBinFilePath("start_lldb_server.sh");
    }

    @NotNull
    protected abstract String getTargetSocketDirectory();

    @NotNull
    protected static String joinPaths(String ... paths) {
        return StringUtil.join((String[])paths, (String)"/");
    }

    @NotNull
    private FileStat pushDebuggerFile(@NotNull SyncService syncService, @NotNull File localFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        String fileName = localFile.getName();
        String tmpDestFile = SessionStarter.joinPaths("/data/local/tmp", fileName);
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = syncService.statFile(tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + localFile + " => " + tmpDestFile);
            this.myDevice.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        return new FileStat(tmpDestFile, destFileStat == null ? 0L : destFileStat.getLastModified().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStarted() throws ExecutionException {
        List<EventListener> list = this.myEventListeners;
        synchronized (list) {
            assert (!this.mySessionStarted);
            this.mySessionStarted = true;
            for (EventListener eventListener : this.myEventListeners) {
                eventListener.sessionStarted();
            }
            this.myEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(@NotNull EventListener eventListener) {
        List<EventListener> list = this.myEventListeners;
        synchronized (list) {
            assert (!this.mySessionStarted);
            this.myEventListeners.add(eventListener);
        }
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public static String getHelpfullyNamedSocketDirectory(@NotNull Client client) {
        String dir = client.getClientData().getPackageName() + "-" + client.getClientData().getUserId();
        if (dir.length() >= 70) {
            dir = dir.substring(dir.length() - 70);
        }
        return "/" + dir;
    }

    public static interface EventListener {
        public void sessionStarted() throws ExecutionException;
    }

    protected static class FileStat {
        private final String myFilePath;
        private final long myLastModified;

        public FileStat(@NotNull String filePath, long lastModified) {
            this.myFilePath = filePath;
            this.myLastModified = lastModified;
        }

        @NotNull
        public String getFilePath() {
            return this.myFilePath;
        }

        public long getLastModified() {
            return this.myLastModified;
        }
    }
}

