/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.testing;

import com.android.builder.model.NativeArtifact;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.ShellSessionStarterImpl;
import com.android.tools.ndk.run.testing.AndroidGoogleTestDebugProcess;
import com.android.tools.ndk.run.testing.AndroidGoogleTestRunConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestCommandLineState;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestConsoleProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGoogleTestLauncher
extends CidrLauncher {
    private static final Logger LOG = Logger.getInstance(AndroidGoogleTestLauncher.class);
    private AndroidGoogleTestRunConfiguration myConfiguration;
    private final AndroidFacet myFacet;
    private final NativeAndroidDebugger myDebugger;
    private final NativeAndroidDebuggerState myDebuggerState;
    private DeviceChooser myDeviceChooser;

    public AndroidGoogleTestLauncher(@NotNull AndroidGoogleTestRunConfiguration configuration, @NotNull NativeAndroidDebugger debugger, @NotNull NativeAndroidDebuggerState debuggerState) {
        this.myConfiguration = configuration;
        this.myFacet = AndroidFacet.getInstance((Module)((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule());
        assert (this.myFacet != null);
        this.myDebugger = debugger;
        this.myDebuggerState = debuggerState;
    }

    public void setDeviceChooser(@NotNull DeviceChooser deviceChooser) {
        this.myDeviceChooser = deviceChooser;
    }

    public ProcessHandler createProcess(@NotNull CommandLineState state) throws ExecutionException {
        state.setConsoleBuilder((TextConsoleBuilder)this.createConsoleBuilder(state));
        return new DefaultDebugProcessHandler();
    }

    @NotNull
    private NativeArtifact getTestNativeArtifact(@NotNull Collection<Abi> abis) throws ExecutionException {
        String target = this.myConfiguration.getTarget();
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)this.myFacet.getModule());
        if (ndkModuleModel == null) {
            throw new ExecutionException("Failed to get native Gradle model");
        }
        NdkModuleModel.NdkVariant variant = ndkModuleModel.getSelectedVariant();
        Collection nativeArtifacts = variant.getArtifacts();
        for (NativeArtifact nativeArtifact : nativeArtifacts) {
            if (!nativeArtifact.getTargetName().equals(target)) continue;
            Abi abi = Abi.getEnum((String)nativeArtifact.getAbi());
            if (abi == null) {
                LOG.warn("Failed to parse Abi string: " + nativeArtifact.getAbi());
                continue;
            }
            if (!abis.contains(abi)) continue;
            return nativeArtifact;
        }
        throw new ExecutionException("Failed to find a test NativeArtifact");
    }

    @NotNull
    private String getTestRootDir() {
        return "/data/local/tmp/androidstudio_googletest";
    }

    @NotNull
    private String getTestRunDir(@NotNull String abi) {
        Module module = this.myFacet.getModule();
        return this.getTestRootDir() + String.format("/%s-%s-%s", module.getProject().getName(), module.getName(), abi);
    }

    @NotNull
    Installer newTestInstaller(final @NotNull CommandLineState state, final @NotNull IDevice device, final @NotNull NativeArtifact nativeArtifact) {
        return new Installer(){

            @NotNull
            public GeneralCommandLine install() throws ExecutionException {
                String testDir = AndroidGoogleTestLauncher.this.getTestRunDir(nativeArtifact.getAbi());
                try {
                    String testExecutable = AndroidGoogleTestLauncher.this.pushFiles(device, nativeArtifact);
                    List cmdLineArgs = AndroidGoogleTestLauncher.this.getCommandLineArgs(state);
                    if (AndroidGoogleTestLauncher.this.myConfiguration.isBreakOnFailure()) {
                        cmdLineArgs.add("--gtest_break_on_failure");
                    }
                    GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{testExecutable});
                    commandLine.addParameters(cmdLineArgs);
                    commandLine.setWorkDirectory(testDir);
                    commandLine.getEnvironment().putAll(AndroidGoogleTestLauncher.this.getEnvironment(testDir));
                    commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE);
                    return commandLine;
                }
                catch (Exception e) {
                    throw new ExecutionException((Throwable)e);
                }
            }

            @NotNull
            public File getExecutableFile() {
                return nativeArtifact.getOutputFile();
            }

            @Nullable
            public File getAppWorkingDir() {
                return null;
            }
        };
    }

    @NotNull
    private RunParameters newRunParameters(final @NotNull CommandLineState state, final @NotNull IDevice device, final @NotNull List<Abi> abis, final @NotNull SessionStarter sessionStarter, final @NotNull ProcessHandlerConsolePrinter printer) throws ExecutionException {
        final NativeArtifact testNativeArtifact = this.getTestNativeArtifact(abis);
        return new RunParameters(){

            @NotNull
            public Installer getInstaller() {
                return AndroidGoogleTestLauncher.this.newTestInstaller(state, device, testNativeArtifact);
            }

            @NotNull
            public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                return new AndroidLLDBDriverConfiguration(AndroidGoogleTestLauncher.this.myFacet, AndroidGoogleTestLauncher.this.myDebuggerState, (ConsolePrinter)printer, device, abis, sessionStarter, AndroidGoogleTestLauncher.this.getStartupCommands(), AndroidGoogleTestLauncher.this.getPostAttachCommands(printer));
            }

            @NotNull
            public String getArchitectureId() {
                return NdkHelper.getArchitectureId(NdkHelper.getAbi(device));
            }
        };
    }

    @NotNull
    private SessionStarter newShellSessionStarter(@NotNull IDevice device, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        return new ShellSessionStarterImpl(device, serverPath, startScriptPath, this.myDebuggerState, progressReporter, launchStatus, printer);
    }

    @NotNull
    private List<String> getStartupCommands() {
        return Stream.concat(this.myDebugger.getStartupCommands(this.myFacet, null).stream(), this.myDebuggerState.getUserStartupCommands().stream()).collect(Collectors.toList());
    }

    @NotNull
    private List<String> getPostAttachCommands(@NotNull ProcessHandlerConsolePrinter printer) {
        return Stream.concat(this.myDebugger.getPostAttachCommands(this.myFacet, null, printer).stream(), this.myDebuggerState.getUserPostAttachCommands().stream()).collect(Collectors.toList());
    }

    @NotNull
    public CidrDebugProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        IDevice device = this.myDeviceChooser.getDevice();
        List<Abi> deviceAbis = this.getDeviceAbis(device);
        DefaultDebugProcessHandler processHandler = new DefaultDebugProcessHandler();
        ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus((ProcessHandler)processHandler);
        ProcessHandlerConsolePrinter printer = new ProcessHandlerConsolePrinter((ProcessHandler)processHandler);
        ProgressReporter progressReporter = new ProgressReporter(this.myFacet.getModule().getProject());
        File lldbServer = ModulePathManager.findLLDBServer(this.myFacet, this.myDebuggerState, deviceAbis);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException("LLDB server not found");
        }
        LOG.info(String.format("Found LLDB server: \"%s\"", lldbServer.getAbsolutePath()));
        File startServerScript = ModulePathManager.getSdkLLDBAndroidFile("start_lldb_server.sh");
        SessionStarter sessionStarter = this.newShellSessionStarter(device, lldbServer, startServerScript, progressReporter, launchStatus, (ConsolePrinter)printer);
        RunParameters runParameters = this.newRunParameters(state, device, deviceAbis, sessionStarter, printer);
        CidrConsoleBuilder consoleBuilder = this.createConsoleBuilder(state);
        AndroidGoogleTestDebugProcess debugProcess = new AndroidGoogleTestDebugProcess("", runParameters, session, (TextConsoleBuilder)consoleBuilder, (ConsolePrinter)printer, sessionStarter, progressReporter);
        return debugProcess;
    }

    @NotNull
    List<Abi> getDeviceAbis(@NotNull IDevice device) {
        ArrayList abis = Lists.newArrayListWithCapacity((int)device.getAbis().size());
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + abiStr);
                continue;
            }
            abis.add(abi);
        }
        return abis;
    }

    protected CidrConsoleBuilder createConsoleBuilder(final @NotNull CommandLineState state) {
        return new CidrConsoleBuilder(this.myFacet.getModule().getProject(), null, null){

            @NotNull
            protected ConsoleView createConsole() {
                CidrGoogleTestCommandLineState googleState = (CidrGoogleTestCommandLineState)state;
                ConsoleView consoleView = this.createConsole(googleState.getConfiguration().getType(), (SMTRunnerConsoleProperties)new CidrGoogleTestConsoleProperties(googleState.getConfiguration(), googleState.getExecutor(), googleState.getExecutionTarget()));
                return consoleView;
            }
        };
    }

    @NotNull
    public Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    public void configureExecutionResult(@NotNull CommandLineState state, @NotNull DefaultExecutionResult result) throws ExecutionException {
        ProcessHandler processHandler = result.getProcessHandler();
        try {
            IDevice device = this.myDeviceChooser.getDevice();
            LOG.info("Launching tests on device " + device.getSerialNumber());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.runTests(state, device, processHandler);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                finally {
                    processHandler.destroyProcess();
                }
            });
        }
        catch (Throwable e) {
            processHandler.destroyProcess();
            throw e;
        }
    }

    @NotNull
    private static String pushFile(@NotNull SyncService syncService, @NotNull String testDir, @NotNull File localFile) throws SyncException, IOException, TimeoutException {
        String remoteFile = String.format("%s/%s", testDir, localFile.getName());
        syncService.pushFile(localFile.getAbsolutePath(), remoteFile, SyncService.getNullProgressMonitor());
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String pushFiles(@NotNull IDevice device, @NotNull NativeArtifact nativeArtifact) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException, ExecutionException {
        String testRunDir = this.getTestRunDir(nativeArtifact.getAbi());
        device.executeShellCommand(String.format("mkdir %s; mkdir %s", this.getTestRootDir(), testRunDir), (IShellOutputReceiver)new NullOutputReceiver());
        SyncService syncService = device.getSyncService();
        if (syncService == null) {
            return null;
        }
        try {
            File outputDir = nativeArtifact.getOutputFile().getParentFile();
            String[] dependencies = outputDir.list((dir, name) -> name.endsWith(".so"));
            if (dependencies != null) {
                for (String dep : dependencies) {
                    AndroidGoogleTestLauncher.pushFile(syncService, testRunDir, new File(outputDir, dep));
                }
            }
            String testExecutable = AndroidGoogleTestLauncher.pushFile(syncService, testRunDir, nativeArtifact.getOutputFile());
            device.executeShellCommand("chmod 755 " + testExecutable, (IShellOutputReceiver)new NullOutputReceiver());
            String string = testExecutable;
            return string;
        }
        finally {
            syncService.close();
        }
    }

    @NotNull
    private Map<String, String> getEnvironment(@NotNull String testDir) {
        HashMap env = Maps.newHashMap();
        env.put("LD_LIBRARY_PATH", testDir);
        return env;
    }

    @NotNull
    private List<String> getCommandLineArgs(@NotNull CommandLineState state) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{"--gtest_filter=" + ((CidrTestCommandLineState)state).testScope(), "--gtest_color=no"});
        args.addAll(StringUtil.split((String)this.myConfiguration.getProgramArgs(), (String)" "));
        return args;
    }

    private void runTests(@NotNull CommandLineState state, @NotNull IDevice device, final @NotNull ProcessHandler processHandler) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException, ExecutionException {
        NativeArtifact testNativeArtifact = this.getTestNativeArtifact(this.getDeviceAbis(device));
        String testExecutable = this.pushFiles(device, testNativeArtifact);
        String env = StringUtil.join(this.getEnvironment(this.getTestRunDir(testNativeArtifact.getAbi())).entrySet(), t -> String.format("%s=%s", t.getKey(), t.getValue()), (String)" ");
        device.executeShellCommand(String.format("%s %s %s", env, testExecutable, StringUtil.join(this.getCommandLineArgs(state), (String)" ")), (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                for (String line : lines) {
                    processHandler.notifyTextAvailable(line + "\n", ProcessOutputTypes.STDOUT);
                }
            }

            public boolean isCancelled() {
                return false;
            }
        });
    }

    static interface DeviceChooser {
        @NotNull
        public IDevice getDevice() throws ExecutionException;
    }
}

