/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.testing;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.testing.AndroidGoogleTestLauncher;
import com.android.tools.ndk.run.testing.AndroidGoogleTestRunConfigurationEditor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestCommandLineState;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestRunConfigurationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGoogleTestRunConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CidrTestRunConfiguration,
PreferGradleMake {
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new GoogleTestAndroidDebuggerContext();
    private final CidrTestRunConfigurationData myTestData;
    private static final String TARGET_ATTR_NAME = "target";
    private static final String PROGRAM_ARGS_ATTR_NAME = "program_args";
    private static final String BREAK_ON_FAILURE_ATTR_NAME = "break_on_failure";
    private String myTarget = "";
    private String myProgramArgs = "";
    private boolean myBreakOnFailure = true;

    public AndroidGoogleTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myTestData = new CidrGoogleTestRunConfigurationData(project);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        if (topError.isFatal()) {
            throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
        }
        throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
    }

    private List<ValidationError> validate(@Nullable Executor executor) {
        ArrayList errors = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException((RuntimeConfigurationException)e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return ImmutableList.of((Object)ValidationError.fatal((String)AndroidBundle.message((String)"no.facet.error", (Object[])new Object[]{module.getName()})));
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            errors.add(ValidationError.fatal((String)AndroidBundle.message((String)"select.platform.error", (Object[])new Object[0])));
        }
        errors.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet));
        AndroidDebuggerState androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors.addAll(androidDebuggerState.validate(facet, executor));
        }
        if (this.myTarget.isEmpty()) {
            errors.add(ValidationError.fatal((String)"Target is not selected"));
        }
        return errors;
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws com.intellij.execution.ExecutionException {
        List<ValidationError> errors = this.validate(executor);
        ValidationUtil.promptAndQuickFixErrors((Project)this.getProject(), errors);
        return this.createState(env, executor, null);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AndroidGoogleTestRunConfigurationEditor(this);
    }

    @NotNull
    public CidrTestRunConfigurationData getTestData() {
        return this.myTestData;
    }

    @Nullable
    public String getTestingFrameworkName() {
        return "AndroidGoogleTest";
    }

    @NotNull
    public AndroidGoogleTestLauncher createLauncher() {
        return new AndroidGoogleTestLauncher(this, (NativeAndroidDebugger)this.getAndroidDebuggerContext().getAndroidDebugger(), (NativeAndroidDebuggerState)this.getAndroidDebuggerContext().getAndroidDebuggerState());
    }

    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    @NotNull
    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        AndroidGoogleTestLauncher launcher = this.createLauncher();
        launcher.setDeviceChooser(() -> {
            boolean debug = executor instanceof DefaultDebugExecutor;
            AndroidFacet facet = AndroidFacet.getInstance((Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
            assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
            DeployTarget deployTarget = this.getDeployTarget(executor, env, facet);
            if (deployTarget == null) {
                throw new ExecutionFinishedException();
            }
            DeployTargetState deployTargetState = this.getDeployTargetContext().getCurrentDeployTargetState();
            DeviceFutures deviceFutures = deployTarget.getDevices(deployTargetState, facet, DeviceCount.SINGLE, debug, this.getUniqueID());
            if (deviceFutures == null) {
                throw new ExecutionFinishedException();
            }
            List androidDevices = deviceFutures.getDevices();
            if (androidDevices.isEmpty()) {
                throw new com.intellij.execution.ExecutionException("No devices found");
            }
            try {
                return (IDevice)((AndroidDevice)androidDevices.get(0)).getLaunchedDevice().get();
            }
            catch (InterruptedException e) {
                throw new com.intellij.execution.ExecutionException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new com.intellij.execution.ExecutionException((Throwable)e);
            }
        });
        return new CidrGoogleTestCommandLineState((RunConfiguration)this, (CidrLauncher)launcher, failedTests, env, executor);
    }

    @NotNull
    public CidrRerunFailedTestsAction.CidrReturnTestProfile createTestRunProfile(CidrRerunFailedTestsAction action, CidrTestScope scope) {
        return new CidrRerunFailedTestsAction.CidrReturnTestProfile(action, (RunConfigurationBase)this, scope);
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance((Module)module) == null) continue;
            result.add(module);
        }
        return result;
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        return this.myDeployTargetContext;
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet) {
        DeployTarget deployTarget;
        DeployTargetProvider currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider();
        if (currentTargetProvider.requiresRuntimePrompt()) {
            deployTarget = currentTargetProvider.showPrompt(executor, env, facet, DeviceCount.SINGLE, false, this.getDeployTargetContext().getDeployTargetStates(), this.getUniqueID(), LaunchCompatibilityCheckerImpl.create((AndroidFacet)facet));
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget();
        }
        return deployTarget;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        ArrayList targets = Lists.newArrayList();
        for (DeployTargetProvider target : this.getDeployTargetContext().getDeployTargetProviders()) {
            if (!target.isApplicable(false)) continue;
            targets.add(target);
        }
        return targets;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String target = element.getAttributeValue(TARGET_ATTR_NAME);
        this.setTarget(target != null ? target : "");
        String programArgs = element.getAttributeValue(PROGRAM_ARGS_ATTR_NAME);
        this.setProgramArgs(programArgs != null ? programArgs : "");
        String breakOnFailure = element.getAttributeValue(BREAK_ON_FAILURE_ATTR_NAME);
        this.setBreakOnFailure(breakOnFailure != null ? Boolean.valueOf(breakOnFailure) : true);
        this.readModule(element);
        this.myTestData.readExternal(element);
        this.myDeployTargetContext.readExternal(element);
        this.myAndroidDebuggerContext.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.setAttribute(TARGET_ATTR_NAME, this.myTarget);
        element.setAttribute(PROGRAM_ARGS_ATTR_NAME, this.myProgramArgs);
        element.setAttribute(BREAK_ON_FAILURE_ATTR_NAME, Boolean.toString(this.myBreakOnFailure));
        this.writeModule(element);
        this.myTestData.writeExternal(element);
        this.myDeployTargetContext.writeExternal(element);
        this.myAndroidDebuggerContext.writeExternal(element);
    }

    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        return this.myAndroidDebuggerContext;
    }

    @NotNull
    public String getTarget() {
        return this.myTarget;
    }

    @NotNull
    public void setTarget(@NotNull String target) {
        this.myTarget = target;
    }

    @NotNull
    public String getProgramArgs() {
        return this.myProgramArgs;
    }

    @NotNull
    public void setProgramArgs(@NotNull String programArgs) {
        this.myProgramArgs = programArgs;
    }

    public boolean isBreakOnFailure() {
        return this.myBreakOnFailure;
    }

    public void setBreakOnFailure(boolean breakOnFailure) {
        this.myBreakOnFailure = breakOnFailure;
    }

    private static class GoogleTestAndroidDebuggerContext
    extends AndroidDebuggerContext {
        public GoogleTestAndroidDebuggerContext() {
            super("Native");
        }

        @NotNull
        public List<AndroidDebugger> getAndroidDebuggers() {
            return Collections.singletonList(AndroidDebugger.EP_NAME.findExtension(NativeAndroidDebugger.class));
        }
    }
}

