/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.testing;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetConfigurableWrapper;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.RunConfigurationEditorContext;
import com.android.tools.ndk.run.testing.AndroidGoogleTestDebuggerPanel;
import com.android.tools.ndk.run.testing.AndroidGoogleTestRunConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGoogleTestRunConfigurationEditor
extends SettingsEditor<AndroidGoogleTestRunConfiguration>
implements ActionListener {
    private static final String ALL = "[All]";
    private final Project myProject;
    private JPanel myPanel;
    private JBTabbedPane myTabbedPane;
    private ModulesComboBox myModulesComboBox;
    private final ConfigurationModuleSelector myModuleSelector;
    private JComboBox myDeploymentTargetCombo;
    private ConfigurableCardPanel myDeployTargetConfigurableCardPanel;
    private JComboBox mySuiteComboBox;
    private JComboBox myMethodComboBox;
    private JComboBox myTargetComboBox;
    private JPanel myTestKindPanel;
    private RawCommandLineEditor myProgramArgsComponent;
    private AndroidGoogleTestDebuggerPanel myDebuggerPanel;
    private final ImmutableMap<String, DeployTargetConfigurableWrapper> myDeployTargetConfigurables;
    private final List<DeployTargetProvider> myApplicableDeployTargetProviders;
    private final SetMultimap<String, String> mySuiteMethods;

    public AndroidGoogleTestRunConfigurationEditor(@NotNull AndroidGoogleTestRunConfiguration runConfiguration) {
        this.$$$setupUI$$$();
        this.mySuiteMethods = LinkedHashMultimap.create();
        this.myProject = runConfiguration.getProject();
        this.myModuleSelector = new ConfigurationModuleSelector(this.myProject, this.myModulesComboBox){

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                return facet != null && facet.isAppProject();
            }
        };
        this.myModulesComboBox.addActionListener(e -> this.loadTargets());
        this.myTargetComboBox.addActionListener(e -> this.targetChanged());
        this.mySuiteComboBox.addActionListener(e -> {
            this.myMethodComboBox.removeAllItems();
            Set methods = this.mySuiteMethods.get((Object)((String)this.mySuiteComboBox.getSelectedItem()));
            if (methods == null) {
                return;
            }
            if (!methods.isEmpty()) {
                this.myMethodComboBox.addItem(ALL);
            }
            for (String method : methods) {
                this.myMethodComboBox.addItem(method);
            }
        });
        this.myApplicableDeployTargetProviders = ImmutableList.copyOf(runConfiguration.getApplicableDeployTargetProviders());
        RunConfigurationEditorContext context = new RunConfigurationEditorContext(this.myModuleSelector, (JComboBox)this.myModulesComboBox);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider target : this.myApplicableDeployTargetProviders) {
            builder.put((Object)target.getId(), (Object)new DeployTargetConfigurableWrapper(this.myProject, (Disposable)this, (DeployTargetConfigurableContext)context, target));
        }
        this.myDeployTargetConfigurables = builder.build();
        this.myDeploymentTargetCombo.setModel(new CollectionComboBoxModel(this.myApplicableDeployTargetProviders));
        this.myDeploymentTargetCombo.setRenderer(new DeployTargetProvider.Renderer());
        this.myDeploymentTargetCombo.addActionListener(actionEvent -> {
            DeployTargetProvider target = (DeployTargetProvider)this.myDeploymentTargetCombo.getSelectedItem();
            this.myDeployTargetConfigurableCardPanel.select(this.myDeployTargetConfigurables.get((Object)target.getId()), true);
        });
        this.myDebuggerPanel = new AndroidGoogleTestDebuggerPanel(runConfiguration);
        this.myTabbedPane.add("Debugger", (Component)this.myDebuggerPanel.getComponent());
        this.loadTargets();
        this.myProgramArgsComponent.setDialogCaption("Program arguments");
    }

    private boolean isModuleAccepted(Module module) {
        if (module == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null && facet.isAppProject();
    }

    protected void resetEditorFrom(AndroidGoogleTestRunConfiguration configuration) {
        String method;
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        ArrayList<Module> list = new ArrayList<Module>();
        for (Module module : modules) {
            if (!this.isModuleAccepted(module)) continue;
            list.add(module);
        }
        this.myModulesComboBox.setModules(list);
        this.myModulesComboBox.setSelectedItem((Object)((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule());
        String target = configuration.getTarget();
        if (target != null && !target.isEmpty()) {
            this.myTargetComboBox.setSelectedItem(target);
        }
        this.targetChanged();
        this.myProgramArgsComponent.setText(configuration.getProgramArgs());
        CidrTestRunConfigurationData testData = configuration.getTestData();
        String suite = testData.getTestSuite();
        if (suite != null && !suite.isEmpty()) {
            this.mySuiteComboBox.setSelectedItem(suite);
        }
        if ((method = testData.getTestName()) != null && !method.isEmpty()) {
            this.myMethodComboBox.setSelectedItem(method);
        }
        this.myDebuggerPanel.resetFrom(configuration);
    }

    protected void applyEditorTo(AndroidGoogleTestRunConfiguration configuration) throws ConfigurationException {
        ((JavaRunConfigurationModule)configuration.getConfigurationModule()).setModule((Module)this.myModulesComboBox.getSelectedItem());
        String target = (String)this.myTargetComboBox.getSelectedItem();
        configuration.setTarget(target != null ? target : "");
        configuration.setProgramArgs(this.myProgramArgsComponent.getText());
        CidrTestRunConfigurationData testData = configuration.getTestData();
        String suite = (String)this.mySuiteComboBox.getSelectedItem();
        testData.setTestSuite(suite != null && suite.equals(ALL) ? "" : suite);
        String method = (String)this.myMethodComboBox.getSelectedItem();
        testData.setTestName(method != null && method.equals(ALL) ? "" : method);
        testData.setTestMode(CidrScopeInfo.Mode.SUITE_TEST);
        this.myDebuggerPanel.applyTo(configuration);
    }

    @NotNull
    protected JComponent createEditor() {
        return this.myPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Nullable
    private Collection<NativeArtifact> getNativeArtifacts() {
        Module module = (Module)this.myModulesComboBox.getSelectedItem();
        if (module == null) {
            return null;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)module);
        if (ndkModuleModel == null) {
            return null;
        }
        NdkModuleModel.NdkVariant variant = ndkModuleModel.getSelectedVariant();
        return variant.getArtifacts();
    }

    private void loadTargets() {
        this.myTargetComboBox.removeAllItems();
        Collection<NativeArtifact> nativeArtifacts = this.getNativeArtifacts();
        if (nativeArtifacts == null) {
            return;
        }
        HashSet targets = Sets.newHashSet();
        block0: for (NativeArtifact nativeArtifact : nativeArtifacts) {
            for (NativeFile nativeFile : nativeArtifact.getSourceFiles()) {
                if (!this.isGoogleTestSourceFile(nativeFile)) continue;
                targets.add(nativeArtifact.getTargetName());
                continue block0;
            }
        }
        for (String target : targets) {
            this.myTargetComboBox.addItem(target);
        }
    }

    private boolean isGoogleTestSourceFile(@NotNull NativeFile nativeFile) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = this.getPsiFileFromNativeFile(nativeFile);
        if (psiFile == null) {
            return false;
        }
        final Ref result = new Ref((Object)false);
        psiFile.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitStruct(OCStruct struct) {
                if (!((Boolean)result.get()).booleanValue() && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)((OCStructSymbol)struct.getSymbol()))) {
                    result.set((Object)true);
                }
                super.visitStruct(struct);
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    private PsiFile getPsiFileFromNativeFile(@NotNull NativeFile nativeFile) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl("file://" + nativeFile.getFilePath());
        if (file == null) {
            return null;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)file);
        if (psiFile == null) {
            return null;
        }
        if (!psiFile.getFileType().equals(OCFileType.INSTANCE)) {
            return null;
        }
        return psiFile;
    }

    private void targetChanged() {
        this.mySuiteComboBox.removeAllItems();
        this.myMethodComboBox.removeAllItems();
        this.mySuiteMethods.clear();
        String target = (String)this.myTargetComboBox.getSelectedItem();
        if (target == null || target.isEmpty()) {
            return;
        }
        NativeArtifact targetArtifact = null;
        for (NativeArtifact nativeArtifact : this.getNativeArtifacts()) {
            if (!nativeArtifact.getTargetName().equals(target)) continue;
            targetArtifact = nativeArtifact;
            break;
        }
        if (targetArtifact == null) {
            return;
        }
        NativeArtifact artifact = targetArtifact;
        ApplicationManager.getApplication().runReadAction(() -> {
            for (NativeFile nativeFile : artifact.getSourceFiles()) {
                PsiFile psiFile = this.getPsiFileFromNativeFile(nativeFile);
                if (psiFile == null) continue;
                psiFile.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                    public void visitStruct(OCStruct struct) {
                        Couple testName = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)((OCStructSymbol)struct.getSymbol()));
                        if (testName != null) {
                            AndroidGoogleTestRunConfigurationEditor.this.mySuiteMethods.put(testName.getFirst(), testName.getSecond());
                        }
                        super.visitStruct(struct);
                    }
                });
            }
        });
        if (!this.mySuiteMethods.isEmpty()) {
            this.mySuiteComboBox.addItem(ALL);
        }
        for (String suiteName : this.mySuiteMethods.keySet()) {
            this.mySuiteComboBox.addItem(suiteName);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ModulesComboBox modulesComboBox;
        ConfigurableCardPanel configurableCardPanel;
        JComboBox jComboBox;
        RawCommandLineEditor rawCommandLineEditor;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JPanel jPanel;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 15, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("General", null, jPanel3, null);
        JLabel jLabel = new JLabel();
        jLabel.setText("Module:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.myTestKindPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 2, 15, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Suite:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Method:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Target:");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySuiteComboBox = jComboBox4 = new JComboBox();
        jComboBox4.setEditable(false);
        jPanel.add(jComboBox4, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myMethodComboBox = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTargetComboBox = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myProgramArgsComponent = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Program arguments");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Program arguments:");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 15, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Deployment Target Options");
        jPanel4.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Target:");
        jLabel6.setDisplayedMnemonic('T');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeploymentTargetCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myDeployTargetConfigurableCardPanel = configurableCardPanel = new ConfigurableCardPanel();
        configurableCardPanel.setLayout(new BorderLayout(0, 0));
        configurableCardPanel.setEnabled(false);
        jPanel4.add((Component)configurableCardPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myModulesComboBox = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(0, 3, 1, 6, 8, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

