/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.workspace;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.ndk.GradleWorkspace;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.workspace.BlazePluginVerifier;
import com.android.tools.ndk.workspace.EmptyWorkspace;
import com.android.tools.ndk.workspace.NdkWorkspaceProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkWorkspaceManager
extends OCWorkspaceManager {
    private static final Logger LOG = Logger.getInstance(NdkWorkspaceManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final NdkWorkspaceProvider[] myWorkspaceProviders;
    @NotNull
    private final BlazePluginVerifier myBlazePluginVerifier;

    public NdkWorkspaceManager(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo) {
        this(project, androidProjectInfo, gradleProjectInfo, NdkWorkspaceProvider.getExtensions(), new BlazePluginVerifier());
    }

    @VisibleForTesting
    NdkWorkspaceManager(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull NdkWorkspaceProvider[] workspaceProviders, @NotNull BlazePluginVerifier blazePluginVerifier) {
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myWorkspaceProviders = workspaceProviders;
        this.myBlazePluginVerifier = blazePluginVerifier;
    }

    @NotNull
    public OCWorkspace getWorkspace() {
        if (this.myGradleProjectInfo.isBuildWithGradle()) {
            return GradleWorkspace.getInstance(this.myProject);
        }
        OCWorkspace workspace = this.findNdkWorkspaceFromExtensionPoints();
        if (workspace != null) {
            return workspace;
        }
        if (this.myAndroidProjectInfo.isApkProject()) {
            return EmptyWorkspace.getInstance(this.myProject);
        }
        workspace = EmptyWorkspace.getInstance(this.myProject);
        if (!((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false)).booleanValue()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("NDK support for project '" + this.myProject.getName() + "' is disabled because it's not a valid Android project");
            }
            NdkHelper.disableCppLanguageSupport(this.myProject, true);
            NdkWorkspaceManager.rebuildSymbols(this.myProject);
        }
        return workspace;
    }

    @Nullable
    private OCWorkspace findNdkWorkspaceFromExtensionPoints() {
        if (this.myBlazePluginVerifier.isBlazePluginAvailable()) {
            for (NdkWorkspaceProvider ndkWorkspaceProvider : this.myWorkspaceProviders) {
                OCWorkspace workspace = ndkWorkspaceProvider.findNdkWorkspace(this.myProject);
                if (workspace == null || !this.myBlazePluginVerifier.isBlazeNdkWorkspace(workspace)) continue;
                return workspace;
            }
        }
        return null;
    }

    private static void rebuildSymbols(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            OCWorkspaceModificationTrackers.getInstance((Project)project).getBuildSettingsChangesTracker().incModificationCount();
        }));
    }
}

