/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.google.common.base.Strings;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.InvalidThreadTypeException;
import com.google.services.firebase.ConnectFirebaseTask;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.ConnectToOnlineProjectDialog;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.ReconnectDialog;
import com.google.services.firebase.view.SelectModuleDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseConnectAction
implements AssistActionHandler {
    protected static final String ACTION_KEY = "firebase.connect";

    private void openConnectDialog(@NotNull Module module, boolean attemptLogin) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = module.getProject();
        try {
            FirebaseUiUtils.checkGradleState(module);
        }
        catch (FirebaseUiUtils.GradleStateException exception) {
            Messages.showWarningDialog((Project)module.getProject(), (String)FirebaseBundle.message("firebaseService.userError.gradleSyncNeeded", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]));
            return;
        }
        GoogleLogin googleLogin = GoogleLogin.getInstance();
        boolean previouslyLoggedIn = googleLogin.isLoggedIn();
        if (!previouslyLoggedIn && attemptLogin) {
            try {
                new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_ATTEMPT_LOGIN).withProject(project).log();
                GoogleLogin.promptToLogIn(null, () -> ApplicationManager.getApplication().invokeLater(() -> this.openConnectDialog(module, false)));
            }
            catch (InvalidThreadTypeException invalidThreadException) {
                FirebaseUiUtils.showTrackedErrorBalloon(project, invalidThreadException, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
            }
            return;
        }
        if (!googleLogin.isLoggedIn()) {
            FirebaseConnectAction.getLog().warn("Google Login rejected.");
            return;
        }
        if (!previouslyLoggedIn) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_LOGIN_SUCCESS).withProject(project).log();
        }
        MobileSdkWrapper wrapper = null;
        try {
            wrapper = MobileSdkUtil.getNewMobileSdkWrapper(googleLogin);
        }
        catch (MobileSdkCommException exception) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, exception, "firebaseConnectAction.userError.connectToFirebaseFailed.getWrapper", new Object[0]);
            return;
        }
        PrepareConnectDialogTask task = new PrepareConnectDialogTask(module.getProject(), module, wrapper);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, task.getProgressIndicator());
    }

    private static void showAlreadyConnectedDialog(@NotNull FirebaseConfig firebaseConfig, @NotNull Module androidApplicationModule, @NotNull OnlineProject matchedProject, URL pendingTermsUrl) {
        Project project = androidApplicationModule.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                ReconnectDialog dialog = new ReconnectDialog(project, firebaseConfig, pendingTermsUrl);
                if (dialog.showAndGet()) {
                    new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_RECONNECT_DIALOG_SYNC).withProject(project).withOnlineProject(matchedProject).log();
                    FirebaseUiUtils.showInfoBalloon(project, FirebaseBundle.message("firebase.service.notification.connect.process.started", new Object[0]), null);
                    FirebaseConnectAction.getLog().info("Project data sharing setting was: " + (Object)((Object)dialog.getProjectDataSharingEnabled()));
                    ProgressManager.getInstance().run((Task)new ConnectFirebaseTask(androidApplicationModule, firebaseConfig, matchedProject, dialog.getCountryCode(), MobileSdkUtil.getCurrentTimeZoneId(), pendingTermsUrl != null, dialog.getProjectDataSharingEnabled()));
                } else {
                    FirebaseUiUtils.showWarningBalloon(project, FirebaseBundle.message("firebaseService.userNotification.connectedCancelled", new Object[0]), null);
                }
            }
            catch (IllegalStateException exception) {
                FirebaseUiUtils.showTrackedErrorBalloon(project, exception, "firebaseConnectAction.userError.connectToFirebaseFailed.showDialog", new Object[0]);
            }
        });
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConnectAction.class);
    }

    @Nullable
    private static Module getAndroidModuleToConnect(Project project) {
        Module selectedModule;
        List<Module> eligibleModules = FirebaseConnectAction.filterEligibleModules(GradleProjectInfo.getInstance((Project)project).getAndroidModules());
        if (eligibleModules.isEmpty()) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseConnectAction.userError.couldNotFindAndroidModule", new Object[0]);
            return null;
        }
        if (eligibleModules.size() == 1) {
            selectedModule = eligibleModules.get(0);
            FirebaseConnectAction.getLog().debug("Found one Firebase project:" + selectedModule.getName());
        } else {
            SelectModuleDialog moduleDialog = new SelectModuleDialog(project, eligibleModules);
            if (moduleDialog.showAndGet()) {
                selectedModule = moduleDialog.getSelectedModule();
                FirebaseConnectAction.getLog().debug("Selected project: " + selectedModule.getName() + " to connect to Firebase");
            } else {
                return null;
            }
        }
        return selectedModule;
    }

    private static List<Module> filterEligibleModules(Collection<? extends Module> modules) {
        return modules.stream().filter(input -> {
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)input);
            return androidFacet != null && androidFacet.isAppProject();
        }).collect(Collectors.toList());
    }

    @NotNull
    public String getId() {
        return ACTION_KEY;
    }

    public void handleAction(@NotNull ActionData actionData, @NotNull Project project) {
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_CONNECT_REQUESTED).withProject(project).log();
        Module selectedModule = FirebaseConnectAction.getAndroidModuleToConnect(project);
        if (selectedModule == null) {
            return;
        }
        this.openConnectDialog(selectedModule, true);
    }

    private static class PrepareConnectDialogTask
    extends Task.ConditionalModal {
        private final Module myModule;
        private final Project myProject;
        private final MobileSdkWrapper myWrapper;
        private boolean myCancelRequested;

        public ProgressIndicator getProgressIndicator() {
            return new BackgroundableProcessIndicator((Task.Backgroundable)this){

                protected void onRunningChange() {
                    if (this.isCanceled()) {
                        this.requestCancel();
                    }
                }
            };
        }

        public PrepareConnectDialogTask(@NotNull Project project, @NotNull Module module, @NotNull MobileSdkWrapper wrapper) {
            super(module.getProject(), FirebaseBundle.message("ui.connect.dialog.action.start", new Object[0]), true, PerformInBackgroundOption.DEAF);
            this.myProject = project;
            this.myModule = module;
            this.myWrapper = wrapper;
            this.myCancelRequested = false;
        }

        public void requestCancel() {
            this.myCancelRequested = true;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            FirebaseConfig firebaseConfig;
            List<OnlineProject> existingProjects;
            URL pendingTermsUrl;
            try {
                pendingTermsUrl = this.myWrapper.getPendingTosUrl();
            }
            catch (MobileSdkCommException exception) {
                this.showErrorIfNotCancelled(exception, "firebaseConnectAction.userError.connectToFirebaseFailed.getTos", new Object[0]);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            try {
                existingProjects = this.myWrapper.getExistingProjects();
            }
            catch (MobileSdkCommException exception) {
                this.showErrorIfNotCancelled(exception, "firebaseConnectAction.userError.connectToFirebaseFailed.getProjects", new Object[0]);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            try {
                firebaseConfig = new FirebaseConfig(this.myModule, existingProjects);
            }
            catch (FirebaseLocalConfig.InvalidLocalConfigException configException) {
                FirebaseUiUtils.showErrorBalloon(this.myModule.getProject(), configException.getMessage(), (Throwable)((Object)configException));
                return;
            }
            if (firebaseConfig.isMultipleOnlineProjectsResolvedToAndroidClientMappings()) {
                this.showErrorIfNotCancelled(null, "firebaseService.userNotification.multipleExistingMatchesFound", new Object[0]);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            if (firebaseConfig.isLocalConfigPresent()) {
                if (firebaseConfig.getResolvedProject() != null) {
                    if (this.assertUserAccess(firebaseConfig.getResolvedProject(), firebaseConfig)) {
                        return;
                    }
                    FirebaseConnectAction.showAlreadyConnectedDialog(firebaseConfig, this.myModule, firebaseConfig.getResolvedProject(), pendingTermsUrl);
                    return;
                }
                this.showErrorIfNotCancelled(null, "firebaseService.userError.existingConfigButNoMatchFound", firebaseConfig.getLocalFirebaseConfigFile(), firebaseConfig.getLocalFirebaseConfigProjectId());
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            Pair<AndroidClient, OnlineProject> matchedPair = firebaseConfig.getFirstMatchedClientAndProject();
            if (matchedPair != null) {
                OnlineProject matchedProject = (OnlineProject)matchedPair.getSecond();
                if (this.assertUserAccess(matchedProject, firebaseConfig)) {
                    return;
                }
                FirebaseConnectAction.showAlreadyConnectedDialog(firebaseConfig, this.myModule, (OnlineProject)matchedPair.second, pendingTermsUrl);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    new ConnectToOnlineProjectDialog(this.myModule, firebaseConfig, existingProjects, pendingTermsUrl).show();
                }
                catch (IllegalStateException exception) {
                    this.showErrorIfNotCancelled(exception, "firebaseConnectAction.userError.connectToFirebaseFailed.showDialog", new Object[0]);
                }
            });
        }

        private void showErrorIfNotCancelled(@Nullable Throwable throwable, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
            if (!this.myCancelRequested) {
                FirebaseUiUtils.showTrackedErrorBalloon(this.myProject, throwable, messageKey, messageArguments);
            } else {
                FirebaseUiUtils.logSilentError(messageKey);
            }
        }

        private boolean assertUserAccess(@NotNull OnlineProject matchedProject, @NotNull FirebaseConfig firebaseConfig) {
            boolean needToAddAndroidAuthClients;
            boolean bl = needToAddAndroidAuthClients = !firebaseConfig.getRegisterableAndroidClients().isEmpty();
            if ((matchedProject.isRequiredFirebaseMigration() || needToAddAndroidAuthClients) && !matchedProject.isEditable()) {
                String projectDisplayName = matchedProject.getDisplayName();
                if (Strings.isNullOrEmpty((String)projectDisplayName)) {
                    projectDisplayName = matchedProject.getProjectNumber();
                }
                FirebaseUiUtils.showTrackedErrorBalloon(this.myModule.getProject(), null, "connect.reconnect.dialog.noEditRightsToProject", projectDisplayName);
                return true;
            }
            return false;
        }
    }
}

