/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseConnectAction;
import com.google.services.firebase.ModuleAsyncStateManager;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseConnectStateManager
extends ModuleAsyncStateManager {
    private final Set<Project> myRegisteredProjects = new HashSet<Project>();

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConnectAction.class);
    }

    public static void setCompletableState(@NotNull Module module, boolean stateOverride) {
        for (AssistActionStateManager stateManager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
            if (!stateManager.getId().equals("firebase.connect")) continue;
            ((FirebaseConnectStateManager)stateManager).updateModuleState(module, stateOverride);
        }
    }

    @Override
    boolean calculateState(@NotNull Module module) {
        List<OnlineProject> existingProjects;
        MobileSdkWrapper mobileSdkWrapper;
        try {
            mobileSdkWrapper = MobileSdkUtil.getNewMobileSdkWrapper(GoogleLogin.getInstance());
        }
        catch (MobileSdkCommException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because there is an issue making backend api calls");
            return true;
        }
        try {
            if (mobileSdkWrapper.getPendingTosUrl() != null) {
                FirebaseConnectStateManager.getLog().info("Not connected to Firebase because ToS is pending");
                return true;
            }
        }
        catch (MobileSdkCommException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because ToS status couldn't be determined.");
            return true;
        }
        try {
            existingProjects = mobileSdkWrapper.getExistingProjects();
        }
        catch (MobileSdkCommException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because couldn't list existing projects.");
            return true;
        }
        try {
            FirebaseConfig firebaseConfig = new FirebaseConfig(module, existingProjects);
            if (firebaseConfig.isMultipleOnlineProjectsResolvedToAndroidClientMappings()) {
                FirebaseConnectStateManager.getLog().info("Not connected to Firebase because multiple project mappings found.");
                return true;
            }
            FirebaseConnectStateManager.getLog().info("IsConnected: " + firebaseConfig.isConnected());
            return !firebaseConfig.isConnected();
        }
        catch (FirebaseLocalConfig.InvalidLocalConfigException exception) {
            FirebaseConnectStateManager.getLog().info("Not connected to Firebase because there was an invalid Firebase configuration");
            return true;
        }
    }

    @Override
    String getTaskDisplayName() {
        return FirebaseBundle.message("firebase.service.action.label.refresh.state.action", new Object[0]);
    }

    @NotNull
    public String getId() {
        return "firebase.connect";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener.Adapter(){

            public void syncSucceeded(@NotNull Project project) {
                FirebaseConnectStateManager.this.updateAllModuleStates(project);
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                FirebaseConnectStateManager.this.updateAllModuleStates(project);
            }
        });
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        String message = this.myStateMessageMap.containsKey(project) ? (String)this.myStateMessageMap.get(project) : successMessage;
        return new StatefulButtonMessage(message, (AssistActionState)this.getState(project, actionData));
    }
}

