/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.mobilesdk;

import com.google.api.client.util.Lists;
import com.google.api.services.mobilesdk_pa.v1.model.AndroidClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.ConsoleProject;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseProject;
import com.google.api.services.mobilesdk_pa.v1.model.IosClientSummary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.services.firebase.FirebaseBundle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnlineProject {
    private static final String LEGACY_PROJECT_SUFFIX = FirebaseBundle.message("mobileSdkService.displayString.legacyProjectDisplaySuffix", new Object[0]);
    private final List<String> myWarningMessages = Lists.newArrayList();
    private final boolean myRequiredFirebaseMigration;
    private final boolean myAnalyticsEnabled;
    private final boolean myUserEditable;
    @NotNull
    private final Map<String, FirebaseClientSummary> myFirebaseClientsByAndroidPackageName;
    private final int myNumAndroidOAuth2Clients;
    private int myNumIosApps = 0;
    @NotNull
    private final String myDisplayName;
    @NotNull
    private DataSharingOption myProjectDataSharingOption = DataSharingOption.DATA_NOT_LOADED;
    @NotNull
    private final String myProjectNumber;
    @Nullable
    private String myProjectId;

    @VisibleForTesting
    public OnlineProject(@NotNull String projectNumber, @Nullable String projectId, @NotNull String displayName, boolean requiredFirebaseMigration, boolean analyticsEnabled, boolean userEditable, @NotNull Collection<FirebaseClientSummary> firebaseClients) {
        this.myProjectNumber = projectNumber;
        this.myProjectId = projectId;
        this.myDisplayName = displayName;
        this.myRequiredFirebaseMigration = requiredFirebaseMigration;
        ImmutableMap.Builder clientBuilder = new ImmutableMap.Builder();
        firebaseClients.forEach(firebaseClientSummary -> {
            IosClientSummary iosClientSummary;
            AndroidClientSummary androidClientSummary = firebaseClientSummary.getAndroidClientSummary();
            if (androidClientSummary != null && !Strings.isNullOrEmpty((String)androidClientSummary.getPackageName())) {
                clientBuilder.put((Object)androidClientSummary.getPackageName(), firebaseClientSummary);
            }
            if ((iosClientSummary = firebaseClientSummary.getIosClientSummary()) != null && !Strings.isNullOrEmpty((String)iosClientSummary.getBundleId())) {
                ++this.myNumIosApps;
            }
        });
        this.myFirebaseClientsByAndroidPackageName = clientBuilder.build();
        this.myNumAndroidOAuth2Clients = this.myFirebaseClientsByAndroidPackageName.values().stream().map(FirebaseClientSummary::getAndroidClientSummary).filter(Objects::nonNull).map(AndroidClientSummary::getCertificateHash).filter(Objects::nonNull).mapToInt(List::size).sum();
        this.myAnalyticsEnabled = analyticsEnabled;
        this.myUserEditable = userEditable;
    }

    @NotNull
    public static OnlineProject fromFirebaseProject(@NotNull FirebaseProject firebaseProject) {
        boolean hasEditRights = OnlineProject.hasEditRights(firebaseProject);
        List clientSummary = firebaseProject.getClientSummary();
        if (clientSummary == null) {
            clientSummary = ImmutableList.of();
        }
        return new OnlineProject(firebaseProject.getProjectNumber(), firebaseProject.getProjectId(), firebaseProject.getDisplayName(), false, true, hasEditRights, clientSummary);
    }

    private static boolean hasEditRights(@NotNull FirebaseProject firebaseProject) {
        if (firebaseProject.getRole() == null) {
            return false;
        }
        Role role = Role.valueOf(firebaseProject.getRole());
        return role == Role.EDITOR || role == Role.OWNER;
    }

    @NotNull
    public static OnlineProject fromConsoleProject(@NotNull ConsoleProject consoleProject) {
        boolean hasAnalytics = consoleProject.getHasScion() != null ? consoleProject.getHasScion() : false;
        return new OnlineProject(consoleProject.getProjectNumber(), null, consoleProject.getProjectDisplayName() + " " + LEGACY_PROJECT_SUFFIX, true, hasAnalytics, true, (Collection<FirebaseClientSummary>)ImmutableList.of());
    }

    public boolean isEditable() {
        return this.myUserEditable;
    }

    @Nullable
    public FirebaseClientSummary getFirebaseClientSummary(@NotNull String packageName) {
        return this.myFirebaseClientsByAndroidPackageName.get(packageName);
    }

    @NotNull
    public String getProjectNumber() {
        return this.myProjectNumber;
    }

    @Nullable
    public String getProjectId() {
        return this.myProjectId;
    }

    public int getNumAndroidOAuth2Clients() {
        return this.myNumAndroidOAuth2Clients;
    }

    public int getNumIosApps() {
        return this.myNumIosApps;
    }

    @NotNull
    public Collection<FirebaseClientSummary> getAndroidFirebaseClientSummaries() {
        return this.myFirebaseClientsByAndroidPackageName.values();
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isAnalyticsEnabled() {
        return this.myAnalyticsEnabled;
    }

    @NotNull
    public Collection<String> getWarningMessages() {
        return ImmutableList.copyOf(this.myWarningMessages);
    }

    public void addWarningMessages(@NotNull Collection<String> warningMessages) {
        this.myWarningMessages.addAll(warningMessages);
    }

    public boolean isRequiredFirebaseMigration() {
        return this.myRequiredFirebaseMigration;
    }

    public boolean shouldShowProjectDataSharingSetting() {
        this.assertDataSharingDataLoaded();
        return this.isRequiredFirebaseMigration() && this.isAnalyticsEnabled() && DataSharingOption.MANAGED_AT_PROJECT != this.myProjectDataSharingOption;
    }

    void setProjectDataSharingOption(@NotNull DataSharingOption dataSharingOption) {
        this.myProjectDataSharingOption = dataSharingOption;
    }

    public boolean isProjectDataSharingEnabled() throws IllegalStateException {
        this.assertDataSharingDataLoaded();
        return DataSharingOption.MANAGED_AT_PROJECT == this.myProjectDataSharingOption;
    }

    private void assertDataSharingDataLoaded() {
        if (DataSharingOption.DATA_NOT_LOADED == this.myProjectDataSharingOption) {
            throw new IllegalStateException("Data sharing information not loaded");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnlineProject that = (OnlineProject)o;
        return this.myProjectNumber.equals(that.myProjectNumber);
    }

    public int hashCode() {
        return this.myProjectNumber.hashCode();
    }

    public static enum Role {
        ROLE_UNKNOWN,
        OWNER,
        EDITOR,
        VIEWER;

    }

    public static enum DataSharingOption {
        UNKNOWN_SETTING,
        MANAGED_PER_APP,
        MANAGED_AT_PROJECT,
        DATA_NOT_LOADED;

    }
}

