/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.assistant.view.UIUtils;
import com.google.common.base.Strings;
import com.google.services.firebase.DataSharingSetting;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.ConnectToOnlineProjectPanel;
import com.google.services.firebase.view.FirebaseDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReconnectDialog
extends FirebaseDialog {
    private final String EXTRA_CSS = "body { padding-bottom: 10px; background-color: " + UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor()) + "; width: 500px; }";
    private final JPanel myContentPanel = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
    private JBCheckBox myProjectDataSharingSetting;
    private ComboBox myProjectCountry;
    private static final int MAX_COPY_WIDTH = 500;

    public ReconnectDialog(@NotNull Project project, @NotNull FirebaseConfig firebaseConfig, @Nullable URL pendingTermsUrl) {
        super(project);
        String matchFoundMessage;
        this.setTitle(FirebaseBundle.message("connect.reconnect.dialog.title", new Object[0]));
        this.setOkLabel(FirebaseBundle.message("connect.reconnect.dialog.button.OKLabel", new Object[0]));
        this.myContentPanel.setBorder(BorderFactory.createEmptyBorder(0, SIDE_INSET, 0, SIDE_INSET));
        JTextPane matchFound = new JTextPane();
        matchFound.setBackground(UIUtils.getAsStandardBackgroundColor());
        OnlineProject resolvedProject = firebaseConfig.getResolvedProject();
        if (resolvedProject != null && !Strings.isNullOrEmpty((String)resolvedProject.getDisplayName())) {
            matchFoundMessage = FirebaseBundle.message("connect.reconnect.dialog.matchFoundWithName", resolvedProject.getDisplayName());
            Pair<AndroidClient, OnlineProject> matchedClientAndProject = firebaseConfig.getFirstMatchedClientAndProject();
            if (matchedClientAndProject != null && matchedClientAndProject.getFirst() != null) {
                AndroidClient matchedClient = (AndroidClient)matchedClientAndProject.getFirst();
                matchFoundMessage = matchFoundMessage + FirebaseBundle.message("connect.reconnect.dialog.matchFoundExtraInfo", matchedClient.getPackageName(), matchedClient.getSha1());
            }
        } else {
            matchFoundMessage = FirebaseBundle.message("connect.reconnect.dialog.matchFoundNoName", new Object[0]);
        }
        UIUtils.setHtml((JEditorPane)matchFound, (String)matchFoundMessage, (String)this.EXTRA_CSS);
        this.myContentPanel.add(matchFound);
        if (resolvedProject != null && resolvedProject.isRequiredFirebaseMigration()) {
            this.addExtraSection(FirebaseBundle.message("connect.reconnect.dialog.upgradeRequired", new Object[0]));
            if (pendingTermsUrl != null) {
                this.addExtraSection(FirebaseBundle.message("connect.reconnect.dialog.acceptTos", pendingTermsUrl.toString()));
            }
            JBLabel countryLabel = new JBLabel(FirebaseBundle.message("ui.connect.input.panel.label.country", new Object[0]));
            this.myContentPanel.add((Component)countryLabel);
            this.myProjectCountry = ConnectToOnlineProjectPanel.createCountryComboBox();
            JPanel countryWrapper = new JPanel(new BorderLayout(0, 0));
            countryWrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            countryWrapper.add((Component)this.myProjectCountry);
            this.myContentPanel.add(countryWrapper);
            if (resolvedProject.shouldShowProjectDataSharingSetting()) {
                JPanel dataSharing = new JPanel((LayoutManager)new HorizontalLayout(5, 1));
                this.myProjectDataSharingSetting = new JBCheckBox();
                this.myProjectDataSharingSetting.setSelected(true);
                JEditorPane checkboxLabel = new JEditorPane();
                UIUtils.setHtml((JEditorPane)checkboxLabel, (String)FirebaseBundle.message("ui.connect.dialog.dataSharing", new Object[0]), (String)("body { background-color: " + UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor()) + "; width: " + 500 + "px; }"));
                checkboxLabel.setOpaque(true);
                checkboxLabel.setBackground(UIUtils.getAsStandardBackgroundColor());
                dataSharing.add((Component)this.myProjectDataSharingSetting);
                dataSharing.add(checkboxLabel);
                this.myContentPanel.add(dataSharing);
            } else {
                this.addExtraSection(FirebaseBundle.message("ui.connect.dialog.smallPrint", new Object[0]));
            }
        }
        if (!firebaseConfig.getRegisterableAndroidClients().isEmpty()) {
            this.addExtraSection(FirebaseBundle.message("connect.reconnect.dialog.existingClientsRegistered", firebaseConfig.getRegisterableAndroidClients().size()));
        }
        this.addContentPanel(this.myContentPanel);
        this.init();
        FirebaseAnalyticsProvider.Logger analyticsLog = new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_RECONNECT_DIALOG_OPENED).withProject(project);
        if (resolvedProject != null) {
            analyticsLog.withOnlineProject(resolvedProject);
        }
        analyticsLog.log();
    }

    @Nullable
    public DataSharingSetting getProjectDataSharingEnabled() {
        return DataSharingSetting.fromCheckbox(this.myProjectDataSharingSetting);
    }

    private void addExtraSection(@NotNull String contents) {
        JTextPane extraText = new JTextPane();
        extraText.setBackground(UIUtils.getAsStandardBackgroundColor());
        UIUtils.setHtml((JEditorPane)extraText, (String)contents, (String)this.EXTRA_CSS);
        this.myContentPanel.add(extraText);
    }

    @NotNull
    public String getCountryCode() {
        if (this.myProjectCountry == null) {
            return "US";
        }
        return ConnectToOnlineProjectPanel.getCountryCode(this.myProjectCountry);
    }
}

