/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilRt {
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, FileUtilRt.getUserFileSizeLimit());
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        String string = FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName, char separatorChar) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        String string = fileName.replace('/', separatorChar).replace('\\', separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemIndependentName"));
        }
        String string = fileName.replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemIndependentName"));
        }
        return string;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        String string = ourCanonicalTempPathCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getTempDirectory"));
        }
        return string;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file;
        block4: {
            String string;
            file = new File(System.getProperty("java.io.tmpdir"));
            try {
                String canonical = file.getCanonicalPath();
                if (SystemInfoRt.isWindows && canonical.contains(" ")) break block4;
                string = canonical;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcCanonicalTempPath"));
            }
            return string;
        }
        String string = file.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcCanonicalTempPath"));
        }
        return string;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream, buffer);
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        return byArray;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        if (length == 0) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        return bytes;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "delete"));
        }
        if (NIOReflect.IS_AVAILABLE) {
            return FileUtilRt.deleteRecursivelyNIO(file);
        }
        return FileUtilRt.deleteRecursively(file);
    }

    protected static boolean deleteRecursivelyNIO(File file) {
        try {
            Object pathObject = NIOReflect.ourFileToPathMethod.invoke((Object)file, new Object[0]);
            NIOReflect.ourFilesWalkMethod.invoke(null, pathObject, NIOReflect.ourDeletionVisitor);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null || !NIOReflect.ourNoSuchFileExceptionClass.isInstance(cause)) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
            return false;
        }
        return true;
    }

    private static boolean deleteRecursively(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "deleteRecursively"));
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        if (ioTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioTask", "com/intellij/openapi/util/io/FileUtilRt", "doIOOperation"));
        }
        for (int i = 10; i > 0; --i) {
            T result = ioTask.execute(i == 1);
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "deleteFile"));
        }
        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file.delete() || !file.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "ensureCanCreateFile"));
        }
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "createIfNotExists"));
        }
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "createParentDirs"));
        }
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "createDirectory"));
        }
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        block10: {
            int read;
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
            }
            if (outputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block10;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = FileUtilRt.getThreadLocalBuffer();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }
    }

    @NotNull
    public static byte[] getThreadLocalBuffer() {
        byte[] byArray = BUFFER.get();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getThreadLocalBuffer"));
        }
        return byArray;
    }

    public static int getUserFileSizeLimit() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.intellisense.filesize")) * 1024;
        }
        catch (NumberFormatException e) {
            return 2560000;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }

    protected static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Object ourDeletionVisitor;
        private static Class ourNoSuchFileExceptionClass;
        private static Class ourAccessDeniedExceptionClass;

        static {
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                final Object Result_Continue = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("CONTINUE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (args.length == 2) {
                            Object second = args[1];
                            if (second instanceof Throwable) {
                                throw (Throwable)second;
                            }
                            String methodName = method.getName();
                            if (("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) && !this.performDelete(args[0])) {
                                throw new IOException("Failed to delete " + args[0]){

                                    public synchronized Throwable fillInStackTrace() {
                                        return this;
                                    }
                                };
                            }
                        }
                        return Result_Continue;
                    }

                    private boolean performDelete(final @NotNull Object fileObject) {
                        if (fileObject == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/openapi/util/io/FileUtilRt$NIOReflect$1", "performDelete"));
                        }
                        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

                            @Override
                            public Boolean execute(boolean lastAttempt) {
                                block8: {
                                    try {
                                        NIOReflect.access$000().invoke(null, fileObject);
                                        return Boolean.TRUE;
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable cause = e.getCause();
                                        if (!(cause instanceof IOException)) {
                                            return Boolean.FALSE;
                                        }
                                        if (!NIOReflect.access$100().isInstance(cause)) break block8;
                                        try {
                                            File file = (File)NIOReflect.access$200().invoke(fileObject, new Object[0]);
                                            if (file == null) {
                                                return Boolean.FALSE;
                                            }
                                            if (file.delete() || !file.exists()) {
                                                return Boolean.TRUE;
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            return Boolean.FALSE;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return lastAttempt ? Boolean.FALSE : null;
                            }
                        });
                        return Boolean.TRUE.equals(result);
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
                ourFileToPathMethod = null;
                ourFilesWalkMethod = null;
                ourFilesDeleteIfExistsMethod = null;
                ourDeletionVisitor = null;
                ourNoSuchFileExceptionClass = null;
            }
            IS_AVAILABLE = initSuccess;
        }
    }
}

