/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiReferenceBase<T extends PsiElement>
implements PsiReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiReferenceBase");
    protected final T myElement;
    private TextRange myRangeInElement;
    protected boolean mySoft;

    public PsiReferenceBase(T element, TextRange rangeInElement, boolean soft) {
        this.myElement = element;
        this.myRangeInElement = rangeInElement;
        this.mySoft = soft;
    }

    public PsiReferenceBase(T element, TextRange rangeInElement) {
        this(element);
        this.myRangeInElement = rangeInElement;
    }

    public PsiReferenceBase(T element, boolean soft) {
        this.myElement = element;
        this.mySoft = soft;
    }

    public PsiReferenceBase(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceBase", "<init>"));
        }
        this.myElement = element;
        this.mySoft = false;
    }

    public T getElement() {
        return this.myElement;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        return null;
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, PsiElement resolveTo) {
        return new Immediate<T>(element, true, resolveTo);
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, TextRange rangeInElement, PsiElement resolveTo) {
        return new Immediate<T>(element, rangeInElement, resolveTo);
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    public static class Immediate<T extends PsiElement>
    extends PsiReferenceBase<T> {
        private final PsiElement myResolveTo;

        public Immediate(T element, TextRange rangeInElement, boolean soft, PsiElement resolveTo) {
            super(element, rangeInElement, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element, TextRange rangeInElement, PsiElement resolveTo) {
            super(element, rangeInElement);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element, boolean soft, PsiElement resolveTo) {
            super(element, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(@NotNull T element, PsiElement resolveTo) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceBase$Immediate", "<init>"));
            }
            super(element);
            this.myResolveTo = resolveTo;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            return this.myResolveTo;
        }
    }

    public static abstract class Poly<T extends PsiElement>
    extends PsiReferenceBase<T>
    implements PsiPolyVariantReference {
        public Poly(T psiElement) {
            super(psiElement);
        }

        public Poly(T element, boolean soft) {
            super(element, soft);
        }

        public Poly(T element, TextRange rangeInElement, boolean soft) {
            super(element, rangeInElement, soft);
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }
    }
}

