/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiType
implements PsiAnnotationOwner {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = new ArrayFactory<PsiType>(){

        @NotNull
        public PsiType[] create(int count) {
            PsiType[] psiTypeArray = count == 0 ? EMPTY_ARRAY : new PsiType[count];
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType$1", "create"));
            }
            return psiTypeArray;
        }
    };
    private final TypeAnnotationProvider myAnnotationProvider;

    @NotNull
    public static PsiType[] createArray(int count) {
        PsiType[] psiTypeArray = ARRAY_FACTORY.create(count);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArray"));
        }
        return psiTypeArray;
    }

    protected PsiType(final @NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType", "<init>"));
        }
        this(annotations.length == 0 ? TypeAnnotationProvider.EMPTY : new TypeAnnotationProvider(){

            @Override
            @NotNull
            public PsiAnnotation[] getAnnotations() {
                if (annotations == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType$2", "getAnnotations"));
                }
                return annotations;
            }
        });
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType", "<init>"));
        }
        this.myAnnotationProvider = annotations;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        PsiArrayType psiArrayType = new PsiArrayType(this);
        if (psiArrayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArrayType"));
        }
        return psiArrayType;
    }

    @NotNull
    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType", "createArrayType"));
        }
        PsiArrayType psiArrayType = new PsiArrayType(this, annotations);
        if (psiArrayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArrayType"));
        }
        return psiArrayType;
    }

    @NonNls
    @NotNull
    public abstract String getPresentableText();

    @NonNls
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getCanonicalText"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public abstract String getCanonicalText();

    @NonNls
    @NotNull
    public abstract String getInternalCanonicalText();

    public abstract boolean isValid();

    public abstract boolean equalsToText(@NotNull @NonNls String var1);

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getDeepComponentType"));
        }
        return psiType;
    }

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        TypeAnnotationProvider typeAnnotationProvider = this.myAnnotationProvider;
        if (typeAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotationProvider"));
        }
        return typeAnnotationProvider;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myAnnotationProvider.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/PsiType", "findAnnotation"));
        }
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(@NotNull PsiAnnotation[] annotations) {
            if (annotations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType$Stub", "<init>"));
            }
            super(annotations);
        }

        public Stub(@NotNull TypeAnnotationProvider annotations) {
            if (annotations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType$Stub", "<init>"));
            }
            super(annotations);
        }

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType$Stub", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);
    }
}

