/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiElementFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiElementProcessor<T extends PsiElement> {
    public boolean execute(@NotNull T var1);

    public static class FindElement<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private volatile T myFoundElement = null;

        @Nullable
        public T getFoundElement() {
            return this.myFoundElement;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/PsiElementProcessor$FindElement", "execute"));
            }
            return this.setFound((PsiElement)element);
        }
    }

    public static class CollectFilteredElements<T extends PsiElement>
    extends CollectElements<T> {
        private final PsiElementFilter myFilter;

        public CollectFilteredElements(@NotNull PsiElementFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements", "<init>"));
            }
            this.myFilter = filter;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements", "execute"));
            }
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class CollectElements<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private final Collection<T> myCollection;

        public CollectElements() {
            this(new ArrayList());
        }

        public CollectElements(@NotNull Collection<T> collection) {
            if (collection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/psi/search/PsiElementProcessor$CollectElements", "<init>"));
            }
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        @NotNull
        public Collection<T> getCollection() {
            Collection<T> collection = this.myCollection;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/PsiElementProcessor$CollectElements", "getCollection"));
            }
            return collection;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/PsiElementProcessor$CollectElements", "execute"));
            }
            this.myCollection.add(element);
            return true;
        }
    }
}

