/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
    private static final Method getConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "getConstructorAccessor", new Class[0]);

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @Nullable(value="null means any type") Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        Field result = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        });
        if (result != null) {
            Field field = result;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findAssignableField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            field.setAccessible(true);
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result2 = ReflectionUtil.processFields(each, checker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods, @NonNls @NotNull String name, Class ... parameters) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass, false), name, parameters);
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        Method[] methods = aClass.getDeclaredMethods();
        List<Method> list = includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        return list;
    }

    @NotNull
    private static List<Method> filterRealMethods(@NotNull Method[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        ArrayList<Method> result = ContainerUtil.newArrayList();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result.add(method);
        }
        ArrayList<Method> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        return arrayList;
    }

    public static <T> T getStaticFieldValue(@NotNull Class objectClass, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return (T)field.get(null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }
}

