/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class DataProviderReference
extends PsiReferenceBase<PsiLiteral> {
    public DataProviderReference(PsiLiteral element) {
        super((PsiElement)element, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        return super.bindToElement(element);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass cls = TestNGUtil.getProviderClass(this.getElement(), PsiUtil.getTopLevelClass((PsiElement)this.getElement()));
        if (cls != null) {
            PsiMethod[] methods = cls.getAllMethods();
            String val = this.getValue();
            for (PsiMethod method : methods) {
                PsiAnnotation dataProviderAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{DataProvider.class.getName()});
                if (dataProviderAnnotation == null) continue;
                PsiAnnotationMemberValue dataProviderMethodName = dataProviderAnnotation.findDeclaredAttributeValue("name");
                if (dataProviderMethodName != null && val.equals(StringUtil.unquoteString((String)dataProviderMethodName.getText()))) {
                    return method;
                }
                if (!val.equals(method.getName())) continue;
                return method;
            }
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        boolean needToBeStatic;
        ArrayList<Object> list = new ArrayList<Object>();
        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)this.getElement());
        PsiClass cls = TestNGUtil.getProviderClass(this.getElement(), topLevelClass);
        boolean bl = needToBeStatic = cls != topLevelClass;
        if (cls != null) {
            PsiMethod[] methods;
            PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
            for (PsiMethod method : methods = cls.getAllMethods()) {
                PsiAnnotation dataProviderAnnotation;
                if (current != null && method.getName().equals(current.getName()) || (needToBeStatic ? !method.hasModifierProperty("static") : cls != method.getContainingClass() && method.hasModifierProperty("private")) || (dataProviderAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{DataProvider.class.getName()})) == null) continue;
                PsiAnnotationMemberValue memberValue = dataProviderAnnotation.findDeclaredAttributeValue("name");
                if (memberValue != null) {
                    list.add(LookupValueFactory.createLookupValue((String)StringUtil.unquoteString((String)memberValue.getText()), null));
                    continue;
                }
                list.add(LookupValueFactory.createLookupValue((String)method.getName(), null));
            }
        }
        return list.toArray();
    }
}

