/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.BaseInjectionPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLanguageInjectionSupport
extends LanguageInjectionSupport {
    @Override
    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return false;
    }

    @Override
    public boolean useDefaultInjector(PsiLanguageInjectionHost host) {
        return false;
    }

    @Override
    public boolean useDefaultCommentInjector() {
        return true;
    }

    @Override
    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<PsiElement> commentRef) {
        return InjectorUtils.findCommentInjection(host, "comment", commentRef);
    }

    @Override
    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public BaseInjection createInjection(Element element) {
        return new BaseInjection(this.getId());
    }

    @Override
    public void setupPresentation(BaseInjection injection, SimpleColoredText presentation, boolean isSelected) {
        presentation.append(injection.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Override
    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[0];
    }

    @Override
    public AnAction[] createAddActions(Project project, Consumer<BaseInjection> consumer) {
        return new AnAction[]{AbstractLanguageInjectionSupport.createDefaultAddAction(project, consumer, this)};
    }

    @Override
    public AnAction createEditAction(Project project, Factory<BaseInjection> producer) {
        return AbstractLanguageInjectionSupport.createDefaultEditAction(project, producer);
    }

    public static AnAction createDefaultEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection originalInjection = (BaseInjection)producer.create();
                BaseInjection newInjection = AbstractLanguageInjectionSupport.showDefaultInjectionUI(project, originalInjection.copy());
                if (newInjection != null) {
                    originalInjection.copyFrom(newInjection);
                }
            }
        };
    }

    public static AnAction createDefaultAddAction(final Project project, final Consumer<BaseInjection> consumer, final AbstractLanguageInjectionSupport support) {
        final String supportTitle = StringUtil.capitalize((String)support.getId());
        Icon icon = FileTypeManager.getInstance().getFileTypeByExtension(support.getId()).getIcon();
        return new AnAction("Generic " + supportTitle, null, icon){

            public void actionPerformed(AnActionEvent e) {
                BaseInjection injection = new BaseInjection(support.getId());
                injection.setDisplayName("New " + supportTitle + " Injection");
                BaseInjection newInjection = AbstractLanguageInjectionSupport.showDefaultInjectionUI(project, injection);
                if (newInjection != null) {
                    consumer.consume((Object)injection);
                }
            }
        };
    }

    @Nullable
    protected static BaseInjection showDefaultInjectionUI(Project project, BaseInjection injection) {
        BaseInjectionPanel panel = new BaseInjectionPanel(injection, project);
        panel.reset();
        DialogBuilder builder = new DialogBuilder(project);
        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(injection.getSupportId());
        if (support instanceof AbstractLanguageInjectionSupport) {
            builder.setHelpId(((AbstractLanguageInjectionSupport)support).getHelpId());
        }
        builder.addOkAction();
        builder.addCancelAction();
        builder.setDimensionServiceKey("#org.intellij.plugins.intelliLang.inject.config.ui.BaseInjectionDialog");
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(() -> {
            try {
                panel.apply();
                builder.getDialogWrapper().close(0);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String message = e.getMessage() + (cause != null ? "\n  " + cause.getMessage() : "");
                Messages.showErrorDialog((Project)project, (String)message, (String)"Unable to Save");
            }
        });
        if (builder.show() == 0) {
            return injection;
        }
        return null;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LanguageInjectionSupport && this.getId().equals(((LanguageInjectionSupport)obj).getId());
    }

    @Nullable
    public String getHelpId() {
        return null;
    }
}

