/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.SubstitutedExpressionEvaluationHelper;
import org.jetbrains.annotations.NotNull;

public class ContextComputationProcessor {
    private final SubstitutedExpressionEvaluationHelper myEvaluationHelper;

    private ContextComputationProcessor(Project project) {
        this.myEvaluationHelper = new SubstitutedExpressionEvaluationHelper(project);
    }

    @NotNull
    public static List<Object> collectOperands(@NotNull String prefix, String suffix, Ref<Boolean> unparsable, PsiElement[] operands) {
        ArrayList<Object> result = new ArrayList<Object>();
        ContextComputationProcessor processor = new ContextComputationProcessor(operands[0].getProject());
        ContextComputationProcessor.addStringFragment(prefix, result);
        PsiElement topParent = (PsiElement)ObjectUtils.assertNotNull((Object)PsiTreeUtil.findCommonParent((PsiElement[])operands));
        processor.collectOperands(ContextComputationProcessor.getTopLevelInjectionTarget(topParent), result, unparsable);
        ContextComputationProcessor.addStringFragment(suffix, result);
        return result;
    }

    private static void addStringFragment(String string, List<Object> result) {
        Object last;
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        int size = result.size();
        Object object = last = size > 0 ? result.get(size - 1) : null;
        if (last instanceof String) {
            result.set(size - 1, last + string);
        } else {
            result.add(string);
        }
    }

    public void collectOperands(PsiElement expression, List<Object> result, Ref<Boolean> unparsable) {
        if (expression instanceof PsiParenthesizedExpression) {
            this.collectOperands((PsiElement)((PsiParenthesizedExpression)expression).getExpression(), result, unparsable);
        } else if (expression instanceof PsiTypeCastExpression) {
            this.collectOperands((PsiElement)((PsiTypeCastExpression)expression).getOperand(), result, unparsable);
        } else if (expression instanceof PsiConditionalExpression) {
            unparsable.set((Object)Boolean.TRUE);
            this.collectOperands((PsiElement)((PsiConditionalExpression)expression).getThenExpression(), result, unparsable);
            ContextComputationProcessor.addStringFragment(" ", result);
            this.collectOperands((PsiElement)((PsiConditionalExpression)expression).getElseExpression(), result, unparsable);
        } else if (expression instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)expression).getOperationTokenType() == JavaTokenType.PLUS) {
            PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : binaryExpression.getOperands()) {
                this.collectOperands((PsiElement)operand, result, unparsable);
            }
        } else if (expression instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expression).getOperationTokenType() == JavaTokenType.PLUSEQ) {
            unparsable.set((Object)Boolean.TRUE);
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            this.collectOperands((PsiElement)assignmentExpression.getLExpression(), result, unparsable);
            this.collectOperands((PsiElement)assignmentExpression.getRExpression(), result, unparsable);
        } else if (PsiUtilEx.isStringOrCharacterLiteral(expression)) {
            result.add(expression);
        } else if (expression instanceof PsiExpression) {
            SmartList uncomputables = new SmartList();
            Object o = this.myEvaluationHelper.computeExpression((PsiExpression)expression, (List<PsiExpression>)uncomputables);
            ContextComputationProcessor.addStringFragment(o == null ? "missingValue" : String.valueOf(o), result);
            if (uncomputables.size() > 0) {
                unparsable.set((Object)Boolean.TRUE);
            }
        } else {
            unparsable.set((Object)Boolean.TRUE);
            result.add(expression);
        }
    }

    @NotNull
    public static PsiElement getTopLevelInjectionTarget(@NotNull PsiElement host) {
        PsiElement target = host;
        PsiElement parent = target.getParent();
        while (parent != null && (parent instanceof PsiPolyadicExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != target)) {
            target = parent;
            parent = target.getParent();
        }
        return target;
    }
}

