/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.JavaReferenceEditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilEx {
    private PsiUtilEx() {
    }

    public static boolean isInSourceContent(PsiElement e) {
        VirtualFile file = e.getContainingFile().getVirtualFile();
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)e.getProject()).getFileIndex();
        return index.isInContent(file);
    }

    @Nullable
    public static PsiParameter getParameterForArgument(PsiElement element) {
        PsiElement p = element.getParent();
        if (!(p instanceof PsiExpressionList)) {
            return null;
        }
        PsiExpressionList list = (PsiExpressionList)p;
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiCallExpression)) {
            return null;
        }
        PsiExpression[] arguments = list.getExpressions();
        for (int i = 0; i < arguments.length; ++i) {
            PsiParameter lastParam;
            PsiExpression argument = arguments[i];
            if (argument != element) continue;
            PsiCallExpression call = (PsiCallExpression)parent;
            PsiMethod method = call.resolveMethod();
            if (method == null) break;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length > i) {
                return parameters[i];
            }
            if (parameters.length <= 0 || !((lastParam = parameters[parameters.length - 1]).getType() instanceof PsiEllipsisType)) break;
            return lastParam;
        }
        return null;
    }

    public static boolean isStringOrCharacterLiteral(PsiElement place) {
        IElementType tokenType;
        PsiElement child;
        return place instanceof PsiLiteralExpression && (child = place.getFirstChild()) != null && child instanceof PsiJavaToken && ((tokenType = ((PsiJavaToken)child).getTokenType()) == JavaTokenType.STRING_LITERAL || tokenType == JavaTokenType.CHARACTER_LITERAL);
    }

    public static boolean isString(@NotNull PsiType type) {
        String shortName;
        if (type instanceof PsiClassType && !Comparing.equal((String)(shortName = ((PsiClassType)type).getClassName()), (String)"String")) {
            return false;
        }
        return "java.lang.String".equals(type.getCanonicalText(false));
    }

    public static boolean isStringOrStringArray(@NotNull PsiType type) {
        if (type instanceof PsiArrayType) {
            return PsiUtilEx.isString(((PsiArrayType)type).getComponentType());
        }
        return PsiUtilEx.isString(type);
    }

    public static Document createDocument(String s, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() || project.isDefault()) {
            return new DocumentImpl(s);
        }
        return JavaReferenceEditorUtil.createTypeDocument((String)s, (Project)project);
    }

    public static boolean isLanguageAnnotationTarget(PsiModifierListOwner owner) {
        if (owner instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)owner).getReturnType();
            if (returnType == null || !PsiUtilEx.isStringOrStringArray(returnType)) {
                return false;
            }
        } else if (owner instanceof PsiVariable) {
            PsiType type = ((PsiVariable)owner).getType();
            if (!PsiUtilEx.isStringOrStringArray(type)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

