/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class PsiModificationTrackerImpl
implements PsiTreeChangePreprocessor,
PsiModificationTracker {
    private final AtomicLong myModificationCount = new AtomicLong(0L);
    private final AtomicLong myOutOfCodeBlockModificationCount = new AtomicLong(0L);
    private final AtomicLong myJavaStructureModificationCount = new AtomicLong(0L);
    private final PsiModificationTracker.Listener myPublisher;
    private final ModificationTracker myOutOfCodeBlockModificationTracker = new ModificationTracker(){

        @Override
        public long getModificationCount() {
            return PsiModificationTrackerImpl.this.getOutOfCodeBlockModificationCount();
        }
    };
    private final ModificationTracker myJavaStructureModificationTracker = new ModificationTracker(){

        @Override
        public long getModificationCount() {
            return PsiModificationTrackerImpl.this.getJavaStructureModificationCount();
        }
    };

    public PsiModificationTrackerImpl(Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            private void doIncCounter() {
                ApplicationManager.getApplication().runWriteAction(() -> PsiModificationTrackerImpl.this.incCounter());
            }

            public void enteredDumbMode() {
                this.doIncCounter();
            }

            public void exitDumbMode() {
                this.doIncCounter();
            }
        });
    }

    public void incCounter() {
        this.myModificationCount.getAndIncrement();
        this.myJavaStructureModificationCount.getAndIncrement();
        this.myOutOfCodeBlockModificationCount.getAndIncrement();
        this.fireEvent();
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.myModificationCount.getAndIncrement();
        this.myOutOfCodeBlockModificationCount.getAndIncrement();
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiModificationTrackerImpl", "treeChanged"));
        }
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        boolean outOfCodeBlock = code == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED ? event.getPropertyName() == "propUnloadedPsi" : (code == PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED ? event.getOldParent() instanceof PsiDirectory || event.getNewParent() instanceof PsiDirectory : event.getParent() instanceof PsiDirectory);
        this.myModificationCount.getAndIncrement();
        if (outOfCodeBlock) {
            this.myJavaStructureModificationCount.getAndIncrement();
            this.myOutOfCodeBlockModificationCount.getAndIncrement();
        }
        this.fireEvent();
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiModificationTrackerImpl", "canAffectPsi"));
        }
        return !"writable".equals(event.getPropertyName());
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @Override
    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationCount.get();
    }

    @Override
    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker() {
        ModificationTracker modificationTracker2 = this.myOutOfCodeBlockModificationTracker;
        if (modificationTracker2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiModificationTrackerImpl", "getOutOfCodeBlockModificationTracker"));
        }
        return modificationTracker2;
    }

    @Override
    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationCount.get();
    }

    @Override
    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        ModificationTracker modificationTracker2 = this.myJavaStructureModificationTracker;
        if (modificationTracker2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiModificationTrackerImpl", "getJavaStructureModificationTracker"));
        }
        return modificationTracker2;
    }
}

