/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClassFileStubBuilder");
    public static final int STUB_VERSION = 19;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/compiled/ClassFileStubBuilder", "acceptsFile"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StubElement buildStubTree(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/psi/impl/compiled/ClassFileStubBuilder", "buildStubTree"));
        }
        VirtualFile file = fileContent.getFile();
        byte[] content = fileContent.getContent();
        try {
            file.setPreloadedContentHint(content);
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file);
            if (decompiler instanceof ClassFileDecompilers.Full) {
                PsiFileStub<?> psiFileStub = ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
                file.setPreloadedContentHint(null);
                return psiFileStub;
            }
        }
        catch (ClsFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(file.getPath(), e);
            }
            LOG.info(file.getPath() + ": " + e.getMessage());
        }
        try {
            PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file, content);
            if (stub != null) return stub;
            if (fileContent.getFileName().indexOf(36) >= 0) return stub;
            LOG.info("No stub built for file " + fileContent);
            return stub;
        }
        catch (ClsFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(file.getPath(), e);
            } else {
                LOG.info(file.getPath() + ": " + e.getMessage());
            }
            file.setPreloadedContentHint(null);
            return null;
        }
    }

    @Override
    public int getStubVersion() {
        int version = 19;
        ArrayList<ClassFileDecompilers.Decompiler> decompilers = ContainerUtil.newArrayList(ClassFileDecompilers.EP_NAME.getExtensions());
        decompilers.sort(CLASS_NAME_COMPARATOR);
        for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
            if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
            version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
        }
        return version;
    }
}

