/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.serialization.JvmStringTable;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet(AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class));
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put(Visibilities.PRIVATE, 2).put(Visibilities.PRIVATE_TO_THIS, 2).put(Visibilities.PROTECTED, 4).put(JavaVisibilities.PROTECTED_STATIC_VISIBILITY, 4).put(JavaVisibilities.PROTECTED_AND_PACKAGE, 4).put(Visibilities.PUBLIC, 1).put(Visibilities.INTERNAL, 1).put(Visibilities.LOCAL, 0).put(JavaVisibilities.PACKAGE_VISIBILITY, 0).build();
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String RECEIVER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(0);
        }
        Type type3 = (jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort())) != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : type2;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(1);
        }
        return type3;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType;
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(2);
        }
        if ((primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType)) == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type2 = primitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(3);
        }
        return type2;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(4);
        }
        return primitiveTypeByBoxedType.get(boxedType);
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(5);
        }
        if (unboxedType == null) {
            AsmUtil.$$$reportNull$$$0(6);
        }
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(7);
        }
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        Type type3 = Type.getType(internalName.substring(1));
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(8);
        }
        return type3;
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        if (componentType == null) {
            AsmUtil.$$$reportNull$$$0(9);
        }
        Type type2 = Type.getType("[" + componentType.getDescriptor());
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(10);
        }
        return type2;
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name, @NotNull Type returnType, Type ... parameterTypes) {
        if (name == null) {
            AsmUtil.$$$reportNull$$$0(11);
        }
        if (returnType == null) {
            AsmUtil.$$$reportNull$$$0(12);
        }
        if (parameterTypes == null) {
            AsmUtil.$$$reportNull$$$0(13);
        }
        Method method = new Method(name, Type.getMethodDescriptor(returnType, parameterTypes));
        if (method == null) {
            AsmUtil.$$$reportNull$$$0(14);
        }
        return method;
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind, GenerationState state2) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor.getContainingDeclaration()) && !state2.isJvm8TargetWithDefaults()) && !AsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return AsmUtil.isStaticKind(kind) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || CodegenUtilKt.isJvmStaticInObjectOrClass(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.DEFAULT_IMPLS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, GenerationState state2) {
        DeclarationDescriptor containingDeclaration;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(functionDescriptor.getOriginal())) continue;
            flags |= flagAnnotation.getJvmFlag();
        }
        if (functionDescriptor.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor.getModality() != Modality.FINAL || functionDescriptor instanceof ConstructorDescriptor || (containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, kind, state2)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor) || AnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor) {
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor);
        flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        if (DeprecationUtilKt.isDeprecatedHidden(functionDescriptor, LanguageVersionSettingsImpl.DEFAULT) || functionDescriptor instanceof PropertyAccessorDescriptor && DeprecationUtilKt.isDeprecatedHidden(((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty(), LanguageVersionSettingsImpl.DEFAULT)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        Integer specialCase;
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(15);
        }
        if ((specialCase = AsmUtil.specialCaseVisibility(descriptor2)) != null) {
            return specialCase;
        }
        Visibility visibility = descriptor2.getVisibility();
        Integer defaultMapping = visibilityToAccessFlag.get(visibility);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(16);
        }
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.PROTECTED || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(17);
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(18);
        }
        int visibility = innerClass instanceof SyntheticClassDescriptorForLambda ? AsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(19);
        }
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality = innerClass.getModality();
        if (modality == Modality.FINAL) {
            return 16;
        }
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(20);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor) {
        PropertyDescriptor property;
        if (memberDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(21);
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt.isEffectivelyInlineOnly(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return AsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor = method = memberDescriptor == property.getGetter() ? ((SyntheticJavaPropertyDescriptor)property).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property;
            return AsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == Visibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)memberDescriptor).isSuspend()) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor) {
            if (DescriptorUtils.isEnumEntry(containingDeclaration)) {
                return 0;
            }
            if (DescriptorUtils.isEnumClass(containingDeclaration)) {
                return 4;
            }
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(22);
        }
        if (exception == null) {
            AsmUtil.$$$reportNull$$$0(23);
        }
        v.anew(Type.getObjectType(exception));
        v.dup();
        if (message != null) {
            v.aconst(message);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v, KotlinTypeMapper typeMapper) {
        KotlinType captureReceiverType;
        if (closure == null) {
            AsmUtil.$$$reportNull$$$0(24);
        }
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            allFields.add(Pair.create(CAPTURED_THIS_FIELD, typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            allFields.add(Pair.create(CAPTURED_RECEIVER_FIELD, typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field.first, ((Type)field.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv) {
        return AsmUtil.genAssignInstanceFieldFromParam(info, index2, iv, 0);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv, int ownerIndex) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        iv.load(ownerIndex, info.getOwnerType());
        iv.load(index2, fieldType);
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(InstructionAdapter v, Type type2) {
        type2 = AsmUtil.stringBuilderAppendType(type2);
        v.invokevirtual("java/lang/StringBuilder", "append", "(" + type2.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(StackValue receiver, Type receiverType) {
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, v -> {
            Type type2 = AsmUtil.stringValueOfType(receiverType);
            receiver.put(type2, (InstructionAdapter)v);
            v.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        });
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    public static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left, @NotNull StackValue right) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(25);
        }
        if (left == null) {
            AsmUtil.$$$reportNull$$$0(26);
        }
        if (right == null) {
            AsmUtil.$$$reportNull$$$0(27);
        }
        Type leftType = left.type;
        Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            StackValue stackValue = StackValue.cmp(opToken, leftType, left, right);
            if (stackValue == null) {
                AsmUtil.$$$reportNull$$$0(28);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, v -> {
            if (left == null) {
                AsmUtil.$$$reportNull$$$0(83);
            }
            if (right == null) {
                AsmUtil.$$$reportNull$$$0(84);
            }
            if (opToken == null) {
                AsmUtil.$$$reportNull$$$0(85);
            }
            left.put(leftType, (InstructionAdapter)v);
            right.put(rightType, (InstructionAdapter)v);
            AsmUtil.genAreEqualCall(v);
            if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
                AsmUtil.genInvertBoolean(v);
            }
            return Unit.INSTANCE;
        });
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(29);
        }
        return stackValue;
    }

    public static void genAreEqualCall(InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v, Type left, Type right) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left.getDescriptor() + right.getDescriptor() + ")Z", false);
    }

    public static void numConst(int value, Type type2, InstructionAdapter v) {
        if (type2 == Type.FLOAT_TYPE) {
            v.fconst(value);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.dconst(value);
        } else if (type2 == Type.LONG_TYPE) {
            v.lconst(value);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v.iconst(value);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void genIncrement(Type baseType, int myDelta, InstructionAdapter v) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType);
        AsmUtil.numConst(myDelta, operationType, v);
        v.add(operationType);
        StackValue.coerce(operationType, baseType, v);
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    public static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state2, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(30);
        }
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(31);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(32);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(33);
        }
        if (state2.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state2.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                AsmUtil.genParamAssertion(v, state2.getTypeMapper(), frameMap, receiverParameter, RECEIVER_NAME);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            AsmUtil.genParamAssertion(v, state2.getTypeMapper(), frameMap, receiverParameter, RECEIVER_NAME);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v, state2.getTypeMapper(), frameMap, parameter, parameter.getName().asString());
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v, @NotNull KotlinTypeMapper typeMapper, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name) {
        KotlinType type2;
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(34);
        }
        if (typeMapper == null) {
            AsmUtil.$$$reportNull$$$0(35);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(36);
        }
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            AsmUtil.$$$reportNull$$$0(38);
        }
        if (TypeUtils.isNullableType(type2 = parameter.getType())) {
            return;
        }
        int index2 = frameMap.getIndex(parameter);
        Type asmType = typeMapper.mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            v.load(index2, asmType);
            v.visitLdcInsn(name);
            String checkMethod = "checkParameterIsNotNull";
            v.invokestatic("kotlin/jvm/internal/Intrinsics", checkMethod, "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(@NotNull GenerationState state2, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state2 == null) {
            AsmUtil.$$$reportNull$$$0(39);
        }
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(40);
        }
        if (state2.isCallAssertionsDisabled()) {
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                AsmUtil.$$$reportNull$$$0(41);
            }
            return stackValue2;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            StackValue stackValue3 = stackValue;
            if (stackValue3 == null) {
                AsmUtil.$$$reportNull$$$0(42);
            }
            return stackValue3;
        }
        StackValue stackValue4 = new StackValue(stackValue.type){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    1.$$$reportNull$$$0(1);
                }
                Type innerType = stackValue.type;
                stackValue.put(innerType, v);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v.dup();
                    v.visitLdcInsn(runtimeAssertionInfo.getMessage());
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkExpressionValueIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, type2, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/AsmUtil$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (stackValue4 == null) {
            AsmUtil.$$$reportNull$$$0(43);
        }
        return stackValue4;
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(44);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(45);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(46);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(47);
        }
        if (type2.getSort() == 6) {
            v.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v.lconst(0L);
        } else {
            v.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(48);
        }
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(49);
        }
        boolean bl = isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(50);
        }
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(51);
        }
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return propertyDescriptor.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && DescriptorUtils.isInterface(propertyContainer.getContainingDeclaration()) && AsmUtil.getVisibilityForBackingField(propertyDescriptor, false) == 1;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType2) {
        if (expectedType2 == null) {
            AsmUtil.$$$reportNull$$$0(52);
        }
        if (expectedType2 == Type.SHORT_TYPE || expectedType2 == Type.BYTE_TYPE || expectedType2 == Type.CHAR_TYPE) {
            Type type2 = Type.INT_TYPE;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(53);
            }
            return type2;
        }
        Type type3 = expectedType2;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(54);
        }
        return type3;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(55);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(56);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(57);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(58);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
            v.visitInsn(88);
        } else {
            v.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(59);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(60);
        }
        AsmUtil.dup(v, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(61);
        }
        if (size == 2) {
            v.dup2();
        } else if (size == 1) {
            v.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(62);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(63);
        }
        AsmUtil.dupx(v, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(64);
        }
        if (size == 2) {
            v.dup2X2();
        } else if (size == 1) {
            v.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(65);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(66);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(67);
        }
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v, 2);
            } else {
                v.dup2X1();
                v.pop2();
                v.dupX2();
                v.dupX2();
                v.pop();
                v.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer, @NotNull MessageLite message) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(68);
        }
        if (serializer == null) {
            AsmUtil.$$$reportNull$$$0(69);
        }
        if (message == null) {
            AsmUtil.$$$reportNull$$$0(70);
        }
        byte[] bytes = serializer.serialize(message);
        AnnotationVisitor data2 = av.visitArray("d1");
        for (String string : BitEncoding.encodeBytes(bytes)) {
            data2.visit(null, string);
        }
        data2.visitEnd();
        AnnotationVisitor strings = av.visitArray("d2");
        for (String string : ((JvmStringTable)serializer.getStringTable()).getStrings()) {
            strings.visit(null, string);
        }
        strings.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(71);
        }
        Type type2 = Type.getObjectType(AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(72);
        }
        return type2;
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            AsmUtil.$$$reportNull$$$0(73);
        }
        Type type2 = Type.getObjectType(classId.asString().replace('.', '$'));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(74);
        }
        return type2;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(75);
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(76);
        }
        return string;
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(77);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(78);
        }
        if (AsmUtil.isPrimitive(type2)) {
            v.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst(type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(79);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(80);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor(AsmTypes.K_CLASS_ARRAY_TYPE, AsmTypes.getType(Class[].class)), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind;
        if (context == null) {
            AsmUtil.$$$reportNull$$$0(81);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(82);
        }
        return (kind = context.getContextKind()) != OwnerKind.DEFAULT_IMPLS && AsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder<Integer, JvmPrimitiveType> typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Type, Type> typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType(primitiveType.getDesc());
            typeBySortBuilder.put(asmType.getSort(), primitiveType);
            typeByWrapperBuilder.put(AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 28: 
            case 29: 
            case 41: 
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 72: 
            case 74: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 28: 
            case 29: 
            case 41: 
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 72: 
            case 74: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 28: 
            case 29: 
            case 41: 
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 72: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxedType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 11: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 32: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 22: 
            case 30: 
            case 34: 
            case 45: 
            case 47: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 77: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 25: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 26: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 27: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStack";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterTop";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "correctElementType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "method";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "genNotNullAssertions";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "numberFunctionOperandType";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByClassId";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 28: 
            case 29: 
            case 41: 
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 72: 
            case 74: 
            case 76: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unboxType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unboxPrimitiveTypeOrNull";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedTypeOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "correctElementType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "method";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlag";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForAnonymous";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calculateInnerClassAccessFlags";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "innerAccessFlagsForModalityAndKind";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedAccessFlag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "specialCaseVisibility";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "genThrow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "genClosureFields";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertionsForParameters";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "genParamAssertion";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertions";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultValueOnStack";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultPrimitiveValueOnStack";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isInstancePropertyWithStaticBackingField";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityForBackingField";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "descriptorForVisibility";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithBackingFieldCopyInOuterClass";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "numberFunctionOperandType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "pop";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "pop2";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "dupx";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByClassId";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "putJavaLangClassInstance";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassIntoKClass";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassesIntoKClasses";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverIndex";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "lambda$genEqualsForExpressionsOnStack$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 28: 
            case 29: 
            case 41: 
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 72: 
            case 74: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

