/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.searchservice;

import com.google.devrel.cluestick.searchservice.CluestickSearch;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class EventLog {
    private static final long LOG_DELAY_SEC = 30L;
    private final CluestickSearch cluestick;
    private final Map<PendingEvent, Integer> pending;
    private final Timer timer;

    public EventLog(CluestickSearch cluestick) {
        this.cluestick = cluestick;
        this.timer = new Timer(true);
        this.pending = new HashMap<PendingEvent, Integer>();
    }

    public void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(@Nullable String action, @Nullable String resultKey, int signal) {
        boolean scheduleTask;
        Map<PendingEvent, Integer> map = this.pending;
        synchronized (map) {
            scheduleTask = this.pending.isEmpty();
            PendingEvent eventKey = new PendingEvent(action, resultKey);
            Integer signalObject = this.pending.get(eventKey);
            signalObject = signalObject == null ? new Integer(signal) : new Integer(signalObject + signal);
            this.pending.put(eventKey, signalObject);
        }
        if (scheduleTask) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EventLog.this.submitEvents();
                }
            }, TimeUnit.SECONDS.toMillis(30L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitEvents() {
        HashMap<PendingEvent, Integer> active;
        Map<PendingEvent, Integer> map = this.pending;
        synchronized (map) {
            active = new HashMap<PendingEvent, Integer>(this.pending);
            this.pending.clear();
        }
        for (Map.Entry entry : active.entrySet()) {
            PendingEvent eventKey = (PendingEvent)entry.getKey();
            this.cluestick.logEvent(eventKey.action, eventKey.resultKey, (Integer)entry.getValue());
        }
    }

    private static class PendingEvent {
        final String action;
        final String resultKey;

        PendingEvent(String action, String resultKey) {
            this.action = action;
            this.resultKey = resultKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PendingEvent)) {
                return false;
            }
            PendingEvent other = (PendingEvent)o;
            return PendingEvent.equals(this.action, other.action) && PendingEvent.equals(this.resultKey, other.resultKey);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.action, this.resultKey});
        }

        private static boolean equals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

