/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.SkippableLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class JarDependency
implements JavaLibrary,
SkippableLibrary {
    public static final String LOCAL_JAR_GROUPID = "__local_jars__";
    private final File mJarFile;
    private final boolean mIsProvided;
    private final String mProjectPath;
    private final List<JarDependency> mDependencies;
    private final MavenCoordinates mResolvedCoordinates;
    private final AtomicBoolean skipped = new AtomicBoolean(false);

    public JarDependency(File jarFile, List<JarDependency> dependencies, MavenCoordinates resolvedCoordinates, String projectPath, boolean isProvided) {
        Preconditions.checkNotNull((Object)jarFile);
        this.mJarFile = jarFile;
        this.mIsProvided = isProvided;
        this.mDependencies = ImmutableList.copyOf(dependencies);
        this.mResolvedCoordinates = resolvedCoordinates;
        this.mProjectPath = projectPath;
    }

    public JarDependency(File jarFile) {
        this(jarFile, (List<JarDependency>)ImmutableList.of(), JarDependency.getCoordForLocalJar(jarFile), null, false);
    }

    public static MavenCoordinatesImpl getCoordForLocalJar(File jarFile) {
        return new MavenCoordinatesImpl(LOCAL_JAR_GROUPID, jarFile.getPath(), "unspecified");
    }

    public String getProject() {
        return this.mProjectPath;
    }

    public String getName() {
        return this.mResolvedCoordinates.toString();
    }

    public File getJarFile() {
        return this.mJarFile;
    }

    public boolean isSkipped() {
        return this.skipped.get();
    }

    @Override
    public void skip() {
        this.skipped.set(true);
    }

    public boolean isProvided() {
        return this.mIsProvided;
    }

    public List<? extends JavaLibrary> getDependencies() {
        return this.mDependencies;
    }

    public MavenCoordinates getRequestedCoordinates() {
        return null;
    }

    public MavenCoordinates getResolvedCoordinates() {
        return this.mResolvedCoordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarDependency that = (JarDependency)o;
        return this.mIsProvided == that.mIsProvided && Objects.equal((Object)this.mJarFile, (Object)that.mJarFile) && Objects.equal((Object)this.mProjectPath, (Object)that.mProjectPath) && Objects.equal(this.mDependencies, that.mDependencies) && Objects.equal((Object)this.mResolvedCoordinates, (Object)that.mResolvedCoordinates) && Objects.equal((Object)this.isSkipped(), (Object)that.isSkipped());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mJarFile, this.mIsProvided, this.mProjectPath, this.mDependencies, this.mResolvedCoordinates, this.isSkipped()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mJarFile", (Object)this.mJarFile).add("mIsProvided", this.mIsProvided).add("mProjectPath", (Object)this.mProjectPath).add("mDependencies", this.mDependencies).add("mResolvedCoordinates", (Object)this.mResolvedCoordinates).add("skipped", (Object)this.skipped).toString();
    }
}

