/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.StoredEntryType;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.ide.common.res2.FileStatus;
import com.android.utils.FileUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class IncrementalRelativeFileSets {
    private IncrementalRelativeFileSets() {
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromDirectory(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        Set files = RelativeFiles.fromDirectory(directory);
        files = Sets.filter(files, (Predicate)Predicates.compose((Predicate)Files.isFile(), RelativeFile.EXTRACT_FILE));
        Map map = Maps.asMap((Set)files, (Function)Functions.constant((Object)FileStatus.NEW));
        return ImmutableMap.copyOf((Map)map);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip) throws IOException {
        return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip, FileStatus status) throws IOException {
        Preconditions.checkArgument((boolean)zip.isFile(), (Object)"!zip.isFile()");
        HashSet files = Sets.newHashSet();
        try (Closer closer = Closer.create();){
            ZFile zipReader = (ZFile)closer.register((Closeable)new ZFile(zip));
            for (StoredEntry entry : zipReader.entries()) {
                if (entry.getType() != StoredEntryType.FILE) continue;
                File file = new File(zip, FileUtils.toSystemDependentPath((String)entry.getCentralDirectoryHeader().getName()));
                files.add(new RelativeFile(zip, file));
            }
        }
        Map map = Maps.asMap((Set)files, (Function)Functions.constant((Object)status));
        return ImmutableMap.copyOf((Map)map);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip, FileCacheByPath cache) throws IOException {
        Preconditions.checkArgument((boolean)zip.isFile(), (Object)"!zip.isFile()");
        File oldFile = cache.get(zip);
        if (oldFile == null) {
            return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
        }
        HashMap result = Maps.newHashMap();
        try (Closer closer = Closer.create();){
            File file;
            String path;
            ZFile newZipReader = (ZFile)closer.register((Closeable)new ZFile(zip));
            ZFile oldZipReader = (ZFile)closer.register((Closeable)new ZFile(oldFile));
            for (StoredEntry entry : newZipReader.entries()) {
                path = entry.getCentralDirectoryHeader().getName();
                if (entry.getType() != StoredEntryType.FILE) continue;
                file = new File(zip, FileUtils.toSystemDependentPath((String)path));
                RelativeFile newRelative = new RelativeFile(zip, file);
                StoredEntry oldEntry = oldZipReader.get(path);
                if (oldEntry == null || oldEntry.getType() != StoredEntryType.FILE) {
                    result.put(newRelative, FileStatus.NEW);
                    continue;
                }
                if (oldEntry.getCentralDirectoryHeader().getCrc32() == entry.getCentralDirectoryHeader().getCrc32() && oldEntry.getCentralDirectoryHeader().getUncompressedSize() == entry.getCentralDirectoryHeader().getUncompressedSize()) continue;
                result.put(newRelative, FileStatus.CHANGED);
            }
            for (StoredEntry entry : oldZipReader.entries()) {
                path = entry.getCentralDirectoryHeader().getName();
                file = new File(zip, FileUtils.toSystemDependentPath((String)path));
                RelativeFile oldRelative = new RelativeFile(zip, file);
                StoredEntry newEntry = newZipReader.get(path);
                if (newEntry != null && newEntry.getType() == StoredEntryType.FILE) continue;
                result.put(oldRelative, FileStatus.REMOVED);
            }
        }
        return ImmutableMap.copyOf((Map)result);
    }

    public static ImmutableMap<RelativeFile, FileStatus> union(Iterable<ImmutableMap<RelativeFile, FileStatus>> sets) {
        HashMap map = Maps.newHashMap();
        for (ImmutableMap<RelativeFile, FileStatus> set : sets) {
            map.putAll(set);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    public static int getBaseDirectoryCount(ImmutableMap<RelativeFile, FileStatus> set) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)set.keySet(), RelativeFile.EXTRACT_BASE), (Predicate)Files.isDirectory())).size();
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZipsAndDirectories(Iterable<File> files) throws IOException {
        HashSet sets = Sets.newHashSet();
        for (File f : files) {
            if (f.isFile()) {
                sets.add(IncrementalRelativeFileSets.fromZip(f));
                continue;
            }
            sets.add(IncrementalRelativeFileSets.fromDirectory(f));
        }
        return IncrementalRelativeFileSets.union(sets);
    }

    public static ImmutableMap<RelativeFile, FileStatus> makeFromBaseFiles(Collection<File> baseFiles, Map<File, FileStatus> updates, FileCacheByPath cache) throws IOException {
        for (File f : baseFiles) {
            Preconditions.checkArgument((boolean)f.exists(), (Object)"!f.exists()");
        }
        HashMap relativeUpdates = Maps.newHashMap();
        block6: for (Map.Entry<File, FileStatus> fileUpdate : updates.entrySet()) {
            File file = fileUpdate.getKey();
            FileStatus status = fileUpdate.getValue();
            if (baseFiles.contains(file)) {
                switch (status) {
                    case CHANGED: {
                        relativeUpdates.putAll(IncrementalRelativeFileSets.fromZip(file, cache));
                        break;
                    }
                    case NEW: {
                        relativeUpdates.putAll(IncrementalRelativeFileSets.fromZip(file, FileStatus.NEW));
                        break;
                    }
                    case REMOVED: {
                        relativeUpdates.putAll(IncrementalRelativeFileSets.fromZip(file, FileStatus.REMOVED));
                    }
                }
                continue;
            }
            for (File possibleBaseDirectory = file.getParentFile(); possibleBaseDirectory != null; possibleBaseDirectory = possibleBaseDirectory.getParentFile()) {
                if (!baseFiles.contains(possibleBaseDirectory)) continue;
                relativeUpdates.put(new RelativeFile(possibleBaseDirectory, file), status);
                continue block6;
            }
        }
        return ImmutableMap.copyOf((Map)relativeUpdates);
    }
}

