/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;

public final class ClassFieldImpl
implements ClassField,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String value;
    private final Set<String> annotations;
    private final String documentation;

    public ClassFieldImpl(String type, String name, String value) {
        this(type, name, value, (Set<String>)ImmutableSet.of(), "");
    }

    public ClassFieldImpl(String type, String name, String value, Set<String> annotations, String documentation) {
        if (type == null || name == null || value == null || annotations == null || documentation == null) {
            throw new NullPointerException("Build Config field cannot have a null parameter");
        }
        this.type = type;
        this.name = name;
        this.value = value;
        this.annotations = ImmutableSet.copyOf(annotations);
        this.documentation = documentation;
    }

    public ClassFieldImpl(ClassField classField) {
        this(classField.getType(), classField.getName(), classField.getValue(), classField.getAnnotations(), classField.getDocumentation());
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassFieldImpl that = (ClassFieldImpl)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        if (!this.annotations.equals(that.annotations)) {
            return false;
        }
        return this.documentation.equals(that.documentation);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + this.documentation.hashCode();
        return result;
    }
}

