/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.sign;

import com.android.builder.internal.packaging.sign.v2.ApkSignerV2;
import com.android.builder.internal.packaging.sign.v2.ByteArrayDigestSource;
import com.android.builder.internal.packaging.sign.v2.SignatureAlgorithm;
import com.android.builder.internal.packaging.sign.v2.ZFileDigestSource;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZFileExtension;
import com.android.builder.internal.utils.IOExceptionRunnable;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;

public class FullApkSignExtension {
    private final ZFile mFile;
    private final X509Certificate mCertificate;
    private final PrivateKey mPrivateKey;
    private final List<SignatureAlgorithm> mV2SignatureAlgorithms;
    private boolean mNeedsSignatureUpdate = true;
    private ZFileExtension mExtension;

    public FullApkSignExtension(ZFile file, int minSdkVersion, X509Certificate certificate, PrivateKey privateKey) throws InvalidKeyException {
        this.mFile = file;
        this.mCertificate = certificate;
        this.mPrivateKey = privateKey;
        this.mV2SignatureAlgorithms = ApkSignerV2.getSuggestedSignatureAlgorithms(certificate.getPublicKey(), minSdkVersion);
    }

    public void register() {
        Preconditions.checkState((this.mExtension == null ? 1 : 0) != 0, (Object)"register() has already been invoked.");
        this.mExtension = new ZFileExtension(){

            @Override
            public IOExceptionRunnable beforeUpdate() throws IOException {
                FullApkSignExtension.this.mFile.setExtraDirectoryOffset(0L);
                return null;
            }

            @Override
            public IOExceptionRunnable added(StoredEntry entry, StoredEntry replaced) {
                FullApkSignExtension.this.onZipChanged();
                return null;
            }

            @Override
            public IOExceptionRunnable removed(StoredEntry entry) {
                FullApkSignExtension.this.onZipChanged();
                return null;
            }

            @Override
            public void entriesWritten() throws IOException {
                FullApkSignExtension.this.onEntriesWritten();
            }
        };
        this.mFile.addZFileExtension(this.mExtension);
    }

    private void onZipChanged() {
        this.mNeedsSignatureUpdate = true;
    }

    private void onEntriesWritten() throws IOException {
        if (!this.mNeedsSignatureUpdate) {
            return;
        }
        this.mNeedsSignatureUpdate = false;
        byte[] apkSigningBlock = this.generateApkSigningBlock();
        Verify.verify((apkSigningBlock.length > 0 ? 1 : 0) != 0, (String)"apkSigningBlock.length == 0", (Object[])new Object[0]);
        this.mFile.setExtraDirectoryOffset(apkSigningBlock.length);
        long apkSigningBlockOffset = this.mFile.getCentralDirectoryOffset() - this.mFile.getExtraDirectoryOffset();
        this.mFile.directWrite(apkSigningBlockOffset, apkSigningBlock);
    }

    private byte[] generateApkSigningBlock() throws IOException {
        byte[] centralDirectoryData = this.mFile.getCentralDirectoryBytes();
        byte[] eocdData = this.mFile.getEocdBytes();
        ApkSignerV2.SignerConfig signerConfig = new ApkSignerV2.SignerConfig();
        signerConfig.privateKey = this.mPrivateKey;
        signerConfig.certificates = ImmutableList.of((Object)this.mCertificate);
        signerConfig.signatureAlgorithms = this.mV2SignatureAlgorithms;
        ByteArrayDigestSource centralDir = new ByteArrayDigestSource(centralDirectoryData);
        ByteArrayDigestSource eocd = new ByteArrayDigestSource(eocdData);
        ZFileDigestSource zipEntries = new ZFileDigestSource(this.mFile, 0L, this.mFile.getCentralDirectoryOffset() - this.mFile.getExtraDirectoryOffset());
        try {
            return ApkSignerV2.generateApkSigningBlock(zipEntries, centralDir, eocd, (List<ApkSignerV2.SignerConfig>)ImmutableList.of((Object)signerConfig));
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IOException("Failed to sign APK using APK Signature Scheme v2", e);
        }
    }
}

