/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.AlignmentRule;
import com.android.builder.internal.packaging.zip.CentralDirectory;
import com.android.builder.internal.packaging.zip.CentralDirectoryHeader;
import com.android.builder.internal.packaging.zip.CentralDirectoryHeaderCompressInfo;
import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.CompressionResult;
import com.android.builder.internal.packaging.zip.Compressor;
import com.android.builder.internal.packaging.zip.DataDescriptorType;
import com.android.builder.internal.packaging.zip.EncodeUtils;
import com.android.builder.internal.packaging.zip.Eocd;
import com.android.builder.internal.packaging.zip.FileUseMap;
import com.android.builder.internal.packaging.zip.FileUseMapEntry;
import com.android.builder.internal.packaging.zip.GPFlags;
import com.android.builder.internal.packaging.zip.InflaterByteSource;
import com.android.builder.internal.packaging.zip.LazyDelegateByteSource;
import com.android.builder.internal.packaging.zip.ProcessedAndRawByteSources;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFileExtension;
import com.android.builder.internal.packaging.zip.ZFileOptions;
import com.android.builder.internal.packaging.zip.ZipFileState;
import com.android.builder.internal.packaging.zip.utils.ByteTracker;
import com.android.builder.internal.packaging.zip.utils.CloseableByteSource;
import com.android.builder.internal.packaging.zip.utils.CloseableDelegateByteSource;
import com.android.builder.internal.packaging.zip.utils.LittleEndianUtils;
import com.android.builder.internal.packaging.zip.utils.RandomAccessFileUtils;
import com.android.builder.internal.utils.CachedFileContents;
import com.android.builder.internal.utils.IOExceptionFunction;
import com.android.builder.internal.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;

public class ZFile
implements Closeable {
    public static final char SEPARATOR = '/';
    private static final int MIN_EOCD_SIZE = 22;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int LAST_BYTES_TO_READ = 65557;
    private static final int ZIP64_EOCD_LOCATOR_SIGNATURE = 117853008;
    private static final int IO_BUFFER_SIZE = 0x100000;
    private static final int MAXIMUM_EXTENSION_CYCLE_COUNT = 10;
    private static final int MINIMUM_EXTRA_FIELD_SIZE = 6;
    private static final int ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = 55605;
    private static final int MAX_LOCAL_EXTRA_FIELD_CONTENTS_SIZE = Short.MAX_VALUE;
    private final File mFile;
    private RandomAccessFile mRaf;
    private final FileUseMap mMap;
    private FileUseMapEntry<Eocd> mEocdEntry;
    private FileUseMapEntry<CentralDirectory> mDirectoryEntry;
    private final Map<String, FileUseMapEntry<StoredEntry>> mEntries;
    private final List<StoredEntry> mUncompressedEntries;
    private ZipFileState mState;
    private boolean mDirty;
    private CachedFileContents<Object> mClosedControl;
    private final AlignmentRule mAlignmentRule;
    private final List<ZFileExtension> mExtensions;
    private final List<IOExceptionRunnable> mToRun;
    private boolean mIsNotifying;
    private long mExtraDirectoryOffset;
    private boolean mNoTimestamps;
    private Compressor mCompressor;
    private final ByteTracker mTracker;
    private boolean mCoverEmptySpaceUsingExtraField;
    private boolean mAutoSortFiles;

    public ZFile(File file) throws IOException {
        this(file, new ZFileOptions());
    }

    public ZFile(File file, ZFileOptions options) throws IOException {
        this.mFile = file;
        this.mMap = new FileUseMap(0L, options.getCoverEmptySpaceUsingExtraField() ? 6 : 0);
        this.mDirty = false;
        this.mClosedControl = null;
        this.mAlignmentRule = options.getAlignmentRule();
        this.mExtensions = Lists.newArrayList();
        this.mToRun = Lists.newArrayList();
        this.mNoTimestamps = options.getNoTimestamps();
        this.mTracker = options.getTracker();
        this.mCompressor = options.getCompressor();
        this.mCoverEmptySpaceUsingExtraField = options.getCoverEmptySpaceUsingExtraField();
        this.mAutoSortFiles = options.getAutoSortFiles();
        this.mState = ZipFileState.CLOSED;
        this.mRaf = null;
        if (file.exists()) {
            this.openReadOnly();
        } else {
            this.mDirty = true;
        }
        this.mEntries = Maps.newHashMap();
        this.mUncompressedEntries = Lists.newArrayList();
        this.mExtraDirectoryOffset = 0L;
        try {
            if (this.mState != ZipFileState.CLOSED) {
                long rafSize = this.mRaf.length();
                if (rafSize > Integer.MAX_VALUE) {
                    throw new IOException("File exceeds size limit of 2147483647.");
                }
                this.mMap.extend(Ints.checkedCast((long)rafSize));
                this.readData();
                this.notify(ZFileExtension::open);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read zip file '" + file.getAbsolutePath() + "'.", e);
        }
    }

    public Set<StoredEntry> entries() {
        HashMap entries = Maps.newHashMap();
        for (FileUseMapEntry<StoredEntry> mapEntry : this.mEntries.values()) {
            StoredEntry entry = mapEntry.getStore();
            assert (entry != null);
            entries.put(entry.getCentralDirectoryHeader().getName(), entry);
        }
        for (StoredEntry uncompressed : this.mUncompressedEntries) {
            entries.put(uncompressed.getCentralDirectoryHeader().getName(), uncompressed);
        }
        return Sets.newHashSet(entries.values());
    }

    public StoredEntry get(String path) {
        for (StoredEntry stillUncompressed : Lists.reverse(this.mUncompressedEntries)) {
            if (!stillUncompressed.getCentralDirectoryHeader().getName().equals(path)) continue;
            return stillUncompressed;
        }
        FileUseMapEntry<StoredEntry> found = this.mEntries.get(path);
        if (found == null) {
            return null;
        }
        return found.getStore();
    }

    private void readData() throws IOException {
        long directoryStartOffset;
        long entryEndOffset;
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        this.readEocd();
        this.readCentralDirectory();
        if (this.mDirectoryEntry != null) {
            CentralDirectory directory = this.mDirectoryEntry.getStore();
            assert (directory != null);
            entryEndOffset = 0L;
            for (StoredEntry entry : directory.getEntries().values()) {
                long start = entry.getCentralDirectoryHeader().getOffset();
                long end = start + entry.getInFileSize();
                FileUseMapEntry<StoredEntry> mapEntry = this.mMap.add(start, end, entry);
                this.mEntries.put(entry.getCentralDirectoryHeader().getName(), mapEntry);
                if (end <= entryEndOffset) continue;
                entryEndOffset = end;
            }
            directoryStartOffset = this.mDirectoryEntry.getStart();
        } else {
            Verify.verifyNotNull(this.mEocdEntry);
            assert (this.mEocdEntry != null);
            directoryStartOffset = this.mEocdEntry.getStart();
            entryEndOffset = 0L;
        }
        long extraOffset = directoryStartOffset - entryEndOffset;
        Verify.verify((extraOffset >= 0L ? 1 : 0) != 0, (String)"extraOffset (%s) < 0", (Object[])new Object[]{extraOffset});
        this.setExtraDirectoryOffset(extraOffset);
    }

    private void readEocd() throws IOException {
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        int lastToRead = 65557;
        if ((long)lastToRead > this.mRaf.length()) {
            lastToRead = Ints.checkedCast((long)this.mRaf.length());
        }
        byte[] last = new byte[lastToRead];
        this.directFullyRead(this.mRaf.length() - (long)lastToRead, last);
        byte[] eocdSignature = new byte[]{6, 5, 75, 80};
        Eocd eocd = null;
        int foundEocdSignature = -1;
        IOException errorFindingSignature = null;
        int eocdStart = -1;
        for (int endIdx = last.length - 22; endIdx >= 0 && foundEocdSignature == -1; --endIdx) {
            if (last[endIdx] != eocdSignature[3] || last[endIdx + 1] != eocdSignature[2] || last[endIdx + 2] != eocdSignature[1] || last[endIdx + 3] != eocdSignature[0]) continue;
            foundEocdSignature = endIdx;
            ByteBuffer eocdBytes = ByteBuffer.wrap(last, foundEocdSignature, last.length - foundEocdSignature);
            try {
                eocd = new Eocd(eocdBytes);
                eocdStart = Ints.checkedCast((long)(this.mRaf.length() - (long)lastToRead + (long)foundEocdSignature));
                if ((long)eocdStart + eocd.getEocdSize() == this.mRaf.length()) continue;
                throw new IOException("EOCD starts at " + eocdStart + " and has " + eocd.getEocdSize() + " bytes, but file ends at " + this.mRaf.length() + ".");
            }
            catch (IOException e) {
                if (errorFindingSignature != null) {
                    e.addSuppressed(errorFindingSignature);
                }
                errorFindingSignature = e;
                foundEocdSignature = -1;
                eocd = null;
            }
        }
        if (foundEocdSignature == -1) {
            throw new IOException("EOCD signature not found in the last " + lastToRead + " bytes of the file.", errorFindingSignature);
        }
        Verify.verify((eocdStart >= 0 ? 1 : 0) != 0);
        int zip64LocatorStart = eocdStart - 20;
        if (zip64LocatorStart >= 0) {
            byte[] possibleZip64Locator = new byte[4];
            this.directFullyRead(zip64LocatorStart, possibleZip64Locator);
            if (LittleEndianUtils.readUnsigned4Le(ByteBuffer.wrap(possibleZip64Locator)) == 117853008L) {
                throw new IOException("Zip64 EOCD locator found but Zip64 format is not supported.");
            }
        }
        this.mEocdEntry = this.mMap.add(eocdStart, (long)eocdStart + eocd.getEocdSize(), eocd);
    }

    private void readCentralDirectory() throws IOException {
        Preconditions.checkNotNull(this.mEocdEntry, (Object)"mEocdEntry == null");
        Preconditions.checkNotNull((Object)this.mEocdEntry.getStore(), (Object)"mEocdEntry.getStore() == null");
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry != null");
        Eocd eocd = this.mEocdEntry.getStore();
        long dirSize = eocd.getDirectorySize();
        if (dirSize > Integer.MAX_VALUE) {
            throw new IOException("Cannot read central directory with size " + dirSize + ".");
        }
        if (eocd.getDirectoryOffset() + dirSize != this.mEocdEntry.getStart()) {
            throw new IOException("Central directory is stored in [" + eocd.getDirectoryOffset() + " - " + (eocd.getDirectoryOffset() + dirSize) + "] and EOCD starts at " + this.mEocdEntry.getStart() + ".");
        }
        byte[] directoryData = new byte[Ints.checkedCast((long)dirSize)];
        this.directFullyRead(eocd.getDirectoryOffset(), directoryData);
        CentralDirectory directory = CentralDirectory.makeFromData(ByteBuffer.wrap(directoryData), eocd.getTotalRecords(), this);
        if (eocd.getDirectorySize() > 0L) {
            this.mDirectoryEntry = this.mMap.add(eocd.getDirectoryOffset(), eocd.getDirectoryOffset() + eocd.getDirectorySize(), directory);
        }
    }

    public InputStream directOpen(final long start, final long end) throws IOException {
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"end < start");
        Preconditions.checkArgument((end <= this.mRaf.length() ? 1 : 0) != 0, (Object)"end > mRaf.length()");
        return new InputStream(){
            private long mCurr;
            {
                this.mCurr = start;
            }

            @Override
            public int read() throws IOException {
                if (this.mCurr == end) {
                    return -1;
                }
                byte[] b = new byte[1];
                int r = ZFile.this.directRead(this.mCurr, b);
                if (r > 0) {
                    ++this.mCurr;
                    return b[0];
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Preconditions.checkNotNull((Object)b, (Object)"b == null");
                Preconditions.checkArgument((off >= 0 ? 1 : 0) != 0, (Object)"off < 0");
                Preconditions.checkArgument((off <= b.length ? 1 : 0) != 0, (Object)"off > b.length");
                Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (Object)"len < 0");
                Preconditions.checkArgument((off + len <= b.length ? 1 : 0) != 0, (Object)"off + len > b.length");
                long availableToRead = end - this.mCurr;
                long toRead = Math.min((long)len, availableToRead);
                if (toRead == 0L) {
                    return -1;
                }
                if (toRead > Integer.MAX_VALUE) {
                    throw new IOException("Cannot read " + toRead + " bytes.");
                }
                int r = ZFile.this.directRead(this.mCurr, b, off, Ints.checkedCast((long)toRead));
                if (r > 0) {
                    this.mCurr += (long)r;
                }
                return r;
            }
        };
    }

    void delete(StoredEntry entry, boolean notify) throws IOException {
        String path = entry.getCentralDirectoryHeader().getName();
        FileUseMapEntry<StoredEntry> mapEntry = this.mEntries.get(path);
        Preconditions.checkNotNull(mapEntry, (Object)"mapEntry == null");
        Preconditions.checkArgument((entry == mapEntry.getStore() ? 1 : 0) != 0, (Object)"entry != mapEntry.getStore()");
        this.mDirty = true;
        this.mMap.remove(mapEntry);
        this.mEntries.remove(path);
        if (notify) {
            this.notify(ext -> ext.removed(entry));
        }
    }

    public void update() throws IOException {
        boolean bl;
        this.processAllReadyEntriesWithWait();
        this.notify(ZFileExtension::beforeUpdate);
        this.processAllReadyEntriesWithWait();
        if (!this.mDirty) {
            return;
        }
        this.reopenRw();
        if (this.mAutoSortFiles) {
            this.sortZipContents();
        } else {
            this.packIfNecessary();
        }
        this.deleteDirectoryAndEocd();
        this.mMap.truncate();
        if (this.mCoverEmptySpaceUsingExtraField) {
            for (FileUseMapEntry<StoredEntry> fileUseMapEntry : new HashSet<FileUseMapEntry<StoredEntry>>(this.mEntries.values())) {
                StoredEntry storedEntry = fileUseMapEntry.getStore();
                assert (storedEntry != null);
                FileUseMapEntry<?> before = this.mMap.before(fileUseMapEntry);
                if (before == null || !before.isFree()) continue;
                int localExtraSize = storedEntry.getLocalExtra().length + Ints.checkedCast((long)before.getSize());
                Verify.verify((localExtraSize <= Short.MAX_VALUE ? 1 : 0) != 0);
                storedEntry.loadSourceIntoMemory();
                long newStart = before.getStart();
                long newSize = fileUseMapEntry.getSize() + before.getSize();
                String name = storedEntry.getCentralDirectoryHeader().getName();
                this.mMap.remove(fileUseMapEntry);
                Verify.verify((fileUseMapEntry == this.mEntries.remove(name) ? 1 : 0) != 0);
                storedEntry.setLocalExtra(ZFile.makeExtraAlignmentBlock(localExtraSize, this.chooseAlignment(storedEntry)));
                this.mEntries.put(name, this.mMap.add(newStart, newStart + newSize, storedEntry));
                storedEntry.getCentralDirectoryHeader().setOffset(-1L);
            }
        }
        TreeMap toWriteToStore = new TreeMap(FileUseMapEntry.COMPARE_BY_START);
        for (FileUseMapEntry<StoredEntry> entry : this.mEntries.values()) {
            StoredEntry entryStore = entry.getStore();
            assert (entryStore != null);
            if (entryStore.getCentralDirectoryHeader().getOffset() != -1L) continue;
            toWriteToStore.put(entry, entryStore);
        }
        for (FileUseMapEntry<?> freeArea : this.mMap.getFreeAreas()) {
            toWriteToStore.put(freeArea, null);
        }
        for (FileUseMapEntry<?> fileUseMapEntry : toWriteToStore.keySet()) {
            StoredEntry entry = (StoredEntry)toWriteToStore.get(fileUseMapEntry);
            if (entry == null) {
                int size = Ints.checkedCast((long)fileUseMapEntry.getSize());
                this.directWrite(fileUseMapEntry.getStart(), new byte[size]);
                continue;
            }
            this.writeEntry(entry, fileUseMapEntry.getStart());
        }
        int extensionBugDetector = 10;
        do {
            this.computeCentralDirectory();
            this.computeEocd();
            bl = this.mDirectoryEntry != null;
            this.notify(ext -> {
                ext.entriesWritten();
                return null;
            });
            if (--extensionBugDetector != 0) continue;
            throw new IOException("Extensions keep resetting the central directory. This is probably a bug.");
        } while (bl && this.mDirectoryEntry == null);
        this.appendCentralDirectory();
        this.appendEocd();
        Verify.verifyNotNull((Object)this.mRaf);
        this.mRaf.setLength(this.mMap.size());
        this.mDirty = false;
        this.notify(ext -> {
            ext.updated();
            return null;
        });
    }

    private void packIfNecessary() throws IOException {
        if (!this.mCoverEmptySpaceUsingExtraField) {
            return;
        }
        TreeSet entriesByLocation = new TreeSet(FileUseMapEntry.COMPARE_BY_START);
        entriesByLocation.addAll(this.mEntries.values());
        for (FileUseMapEntry fileUseMapEntry : entriesByLocation) {
            int localExtraSize;
            StoredEntry storedEntry = (StoredEntry)fileUseMapEntry.getStore();
            assert (storedEntry != null);
            FileUseMapEntry<?> before = this.mMap.before(fileUseMapEntry);
            if (before == null || !before.isFree() || (localExtraSize = storedEntry.getLocalExtra().length + Ints.checkedCast((long)before.getSize())) <= Short.MAX_VALUE) continue;
            this.reAdd(storedEntry, PositionHint.LOWEST_OFFSET);
        }
    }

    private void reAdd(StoredEntry entry, PositionHint positionHint) throws IOException {
        String name = entry.getCentralDirectoryHeader().getName();
        FileUseMapEntry<StoredEntry> mapEntry = this.mEntries.get(name);
        Preconditions.checkNotNull(mapEntry);
        Preconditions.checkState((mapEntry.getStore() == entry ? 1 : 0) != 0);
        entry.loadSourceIntoMemory();
        this.mMap.remove(mapEntry);
        this.mEntries.remove(name);
        FileUseMapEntry<StoredEntry> positioned = this.positionInFile(entry, positionHint);
        this.mEntries.put(name, positioned);
        this.mDirty = true;
    }

    void localHeaderChanged(StoredEntry entry, boolean resized) throws IOException {
        this.mDirty = true;
        if (resized) {
            this.reAdd(entry, PositionHint.ANYWHERE);
        }
    }

    void centralDirectoryChanged() {
        this.mDirty = true;
        this.deleteDirectoryAndEocd();
    }

    @Override
    public void close() throws IOException {
        try (Closeable ignored = this::innerClose;){
            this.update();
        }
        this.notify(ext -> {
            ext.closed();
            return null;
        });
    }

    private void deleteDirectoryAndEocd() {
        if (this.mDirectoryEntry != null) {
            this.mMap.remove(this.mDirectoryEntry);
            this.mDirectoryEntry = null;
        }
        if (this.mEocdEntry != null) {
            this.mMap.remove(this.mEocdEntry);
            this.mEocdEntry = null;
        }
    }

    private void writeEntry(StoredEntry entry, long offset) throws IOException {
        int r;
        Preconditions.checkArgument((entry.getDataDescriptorType() == DataDescriptorType.NO_DATA_DESCRIPTOR ? 1 : 0) != 0, (Object)"Cannot write entries with a data descriptor.");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        byte[] headerData = entry.toHeaderData();
        this.directWrite(offset, headerData);
        ProcessedAndRawByteSources source = entry.getSource();
        CloseableByteSource rawContents = source.getRawByteSource();
        byte[] chunk = new byte[0x100000];
        long writeOffset = offset + (long)headerData.length;
        InputStream is = rawContents.openStream();
        while ((r = is.read(chunk)) >= 0) {
            this.directWrite(writeOffset, chunk, 0, r);
            writeOffset += (long)r;
        }
        is.close();
        entry.replaceSourceFromZip(offset);
    }

    private void computeCentralDirectory() throws IOException {
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry == null");
        HashSet newStored = Sets.newHashSet();
        for (FileUseMapEntry<StoredEntry> mapEntry : this.mEntries.values()) {
            newStored.add(mapEntry.getStore());
        }
        this.mMap.truncate();
        CentralDirectory newDirectory = CentralDirectory.makeFromEntries(newStored, this);
        byte[] newDirectoryBytes = newDirectory.toBytes();
        long directoryOffset = this.mMap.size() + this.mExtraDirectoryOffset;
        this.mMap.extend(directoryOffset + (long)newDirectoryBytes.length);
        if (newDirectoryBytes.length > 0) {
            this.mDirectoryEntry = this.mMap.add(directoryOffset, directoryOffset + (long)newDirectoryBytes.length, newDirectory);
        }
    }

    private void appendCentralDirectory() throws IOException {
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        if (this.mEntries.isEmpty()) {
            Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry != null");
            return;
        }
        Preconditions.checkNotNull(this.mDirectoryEntry, (Object)"mDirectoryEntry != null");
        CentralDirectory newDirectory = this.mDirectoryEntry.getStore();
        Preconditions.checkNotNull((Object)newDirectory, (Object)"newDirectory != null");
        byte[] newDirectoryBytes = newDirectory.toBytes();
        long directoryOffset = this.mDirectoryEntry.getStart();
        this.directWrite(directoryOffset, newDirectoryBytes);
    }

    public byte[] getCentralDirectoryBytes() throws IOException {
        if (this.mEntries.isEmpty()) {
            Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry != null");
            return new byte[0];
        }
        Preconditions.checkNotNull(this.mDirectoryEntry, (Object)"mDirectoryEntry == null");
        CentralDirectory cd = this.mDirectoryEntry.getStore();
        Preconditions.checkNotNull((Object)cd, (Object)"cd == null");
        return cd.toBytes();
    }

    private void computeEocd() throws IOException {
        long dirStart;
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        if (this.mDirectoryEntry == null) {
            Preconditions.checkState((boolean)this.mEntries.isEmpty(), (Object)"mDirectoryEntry == null && !mEntries.isEmpty()");
        }
        long dirSize = 0L;
        if (this.mDirectoryEntry != null) {
            CentralDirectory directory = this.mDirectoryEntry.getStore();
            assert (directory != null);
            dirStart = this.mDirectoryEntry.getStart();
            dirSize = this.mDirectoryEntry.getSize();
            Verify.verify((directory.getEntries().size() == this.mEntries.size() ? 1 : 0) != 0);
        } else {
            dirStart = this.mExtraDirectoryOffset;
        }
        Eocd eocd = new Eocd(this.mEntries.size(), dirStart, dirSize);
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.mMap.size();
        this.mMap.extend(eocdOffset + (long)eocdBytes.length);
        this.mEocdEntry = this.mMap.add(eocdOffset, eocdOffset + (long)eocdBytes.length, eocd);
    }

    private void appendEocd() throws IOException {
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        Preconditions.checkNotNull(this.mEocdEntry, (Object)"mEocdEntry == null");
        Eocd eocd = this.mEocdEntry.getStore();
        Preconditions.checkNotNull((Object)eocd, (Object)"eocd == null");
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.mEocdEntry.getStart();
        this.directWrite(eocdOffset, eocdBytes);
    }

    public byte[] getEocdBytes() throws IOException {
        Preconditions.checkNotNull(this.mEocdEntry, (Object)"mEocdEntry == null");
        Eocd eocd = this.mEocdEntry.getStore();
        Preconditions.checkNotNull((Object)eocd, (Object)"eocd == null");
        return eocd.toBytes();
    }

    private void innerClose() throws IOException {
        if (this.mState == ZipFileState.CLOSED) {
            return;
        }
        Verify.verifyNotNull((Object)this.mRaf, (String)"mRaf == null", (Object[])new Object[0]);
        this.mRaf.close();
        this.mRaf = null;
        this.mState = ZipFileState.CLOSED;
        if (this.mClosedControl == null) {
            this.mClosedControl = new CachedFileContents(this.mFile);
        }
        this.mClosedControl.closed(null);
    }

    public void openReadOnly() throws IOException {
        if (this.mState != ZipFileState.CLOSED) {
            return;
        }
        this.mState = ZipFileState.OPEN_RO;
        this.mRaf = new RandomAccessFile(this.mFile, "r");
    }

    private void reopenRw() throws IOException {
        boolean wasClosed;
        if (this.mState == ZipFileState.OPEN_RW) {
            return;
        }
        if (this.mState == ZipFileState.OPEN_RO) {
            this.innerClose();
            wasClosed = false;
        } else {
            wasClosed = true;
        }
        Verify.verify((this.mState == ZipFileState.CLOSED ? 1 : 0) != 0, (String)"mState != ZpiFileState.CLOSED", (Object[])new Object[0]);
        Verify.verify((this.mRaf == null ? 1 : 0) != 0, (String)"mRaf != null", (Object[])new Object[0]);
        if (this.mClosedControl != null && !this.mClosedControl.isValid()) {
            throw new IOException("File '" + this.mFile.getAbsolutePath() + "' has been modified " + "by an external application.");
        }
        this.mRaf = new RandomAccessFile(this.mFile, "rw");
        this.mState = ZipFileState.OPEN_RW;
        if (wasClosed) {
            this.notify(ZFileExtension::open);
        }
    }

    public void add(String name, InputStream stream) throws IOException {
        this.add(name, stream, true);
    }

    private StoredEntry makeStoredEntry(String name, InputStream stream, boolean mayCompress) throws IOException {
        CloseableDelegateByteSource source = this.mTracker.fromStream(stream);
        long crc32 = source.hash(Hashing.crc32()).padToLong();
        boolean encodeWithUtf8 = !EncodeUtils.canAsciiEncode(name);
        SettableFuture compressInfo = SettableFuture.create();
        CentralDirectoryHeader newFileData = new CentralDirectoryHeader(name, source.size(), (Future<CentralDirectoryHeaderCompressInfo>)compressInfo, GPFlags.make(encodeWithUtf8));
        newFileData.setCrc32(crc32);
        Verify.verify((newFileData.getOffset() == -1L ? 1 : 0) != 0);
        return new StoredEntry(newFileData, this, this.createSources(mayCompress, source, (SettableFuture<CentralDirectoryHeaderCompressInfo>)compressInfo, newFileData));
    }

    private ProcessedAndRawByteSources createSources(boolean mayCompress, CloseableByteSource source, final SettableFuture<CentralDirectoryHeaderCompressInfo> compressInfo, final CentralDirectoryHeader newFileData) throws IOException {
        if (mayCompress) {
            ListenableFuture<CompressionResult> result = this.mCompressor.compress(source);
            Futures.addCallback(result, (FutureCallback)new FutureCallback<CompressionResult>(){

                public void onSuccess(CompressionResult result) {
                    compressInfo.set((Object)new CentralDirectoryHeaderCompressInfo(newFileData, result.getCompressionMethod(), result.getSize()));
                }

                public void onFailure(Throwable t) {
                    compressInfo.setException(t);
                }
            });
            ListenableFuture compressedByteSourceFuture = Futures.transform(result, CompressionResult::getSource);
            LazyDelegateByteSource compressedByteSource = new LazyDelegateByteSource((ListenableFuture<CloseableByteSource>)compressedByteSourceFuture);
            return new ProcessedAndRawByteSources(source, compressedByteSource);
        }
        compressInfo.set((Object)new CentralDirectoryHeaderCompressInfo(newFileData, CompressionMethod.STORE, source.size()));
        return new ProcessedAndRawByteSources(source, source);
    }

    public void add(String name, InputStream stream, boolean mayCompress) throws IOException {
        this.processAllReadyEntries();
        this.add(this.makeStoredEntry(name, stream, mayCompress));
    }

    private void add(StoredEntry newEntry) throws IOException {
        this.mUncompressedEntries.add(newEntry);
        this.processAllReadyEntries();
    }

    private void processAllReadyEntries() throws IOException {
        while (!this.mUncompressedEntries.isEmpty()) {
            StoredEntry next = this.mUncompressedEntries.get(0);
            CentralDirectoryHeader cdh = next.getCentralDirectoryHeader();
            Future<CentralDirectoryHeaderCompressInfo> compressionInfo = cdh.getCompressionInfo();
            if (!compressionInfo.isDone()) {
                return;
            }
            this.mUncompressedEntries.remove(0);
            try {
                compressionInfo.get();
            }
            catch (InterruptedException e) {
                throw new IOException("Impossible I/O exception: get for already computed future throws InterruptedException", e);
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to obtain compression information for entry", e);
            }
            this.addToEntries(next);
        }
    }

    private void processAllReadyEntriesWithWait() throws IOException {
        this.processAllReadyEntries();
        while (!this.mUncompressedEntries.isEmpty()) {
            StoredEntry first = this.mUncompressedEntries.get(0);
            CentralDirectoryHeader cdh = first.getCentralDirectoryHeader();
            cdh.getCompressionInfoWithWait();
            this.processAllReadyEntries();
        }
    }

    private void addToEntries(StoredEntry newEntry) throws IOException {
        StoredEntry replaceStore;
        Preconditions.checkArgument((newEntry.getDataDescriptorType() == DataDescriptorType.NO_DATA_DESCRIPTOR ? 1 : 0) != 0, (Object)"newEntry has data descriptor");
        FileUseMapEntry<StoredEntry> toReplace = this.mEntries.get(newEntry.getCentralDirectoryHeader().getName());
        if (toReplace != null) {
            replaceStore = toReplace.getStore();
            assert (replaceStore != null);
            replaceStore.delete(false);
        } else {
            replaceStore = null;
        }
        FileUseMapEntry<StoredEntry> fileUseMapEntry = this.positionInFile(newEntry, PositionHint.ANYWHERE);
        this.mEntries.put(newEntry.getCentralDirectoryHeader().getName(), fileUseMapEntry);
        this.mDirty = true;
        this.notify(ext -> ext.added(newEntry, replaceStore));
    }

    private FileUseMapEntry<StoredEntry> positionInFile(StoredEntry entry, PositionHint positionHint) throws IOException {
        FileUseMap.PositionAlgorithm algorithm;
        this.deleteDirectoryAndEocd();
        long size = entry.getInFileSize();
        int localHeaderSize = entry.getLocalHeaderSize();
        int alignment = this.chooseAlignment(entry);
        switch (positionHint) {
            case LOWEST_OFFSET: {
                algorithm = FileUseMap.PositionAlgorithm.FIRST_FIT;
                break;
            }
            case ANYWHERE: {
                algorithm = FileUseMap.PositionAlgorithm.BEST_FIT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long newOffset = this.mMap.locateFree(size, localHeaderSize, alignment, algorithm);
        long newEnd = newOffset + entry.getInFileSize();
        if (newEnd > this.mMap.size()) {
            this.mMap.extend(newEnd);
        }
        return this.mMap.add(newOffset, newEnd, entry);
    }

    private int chooseAlignment(StoredEntry entry) throws IOException {
        boolean isCompressed;
        CentralDirectoryHeader cdh = entry.getCentralDirectoryHeader();
        CentralDirectoryHeaderCompressInfo compressionInfo = cdh.getCompressionInfoWithWait();
        boolean bl = isCompressed = compressionInfo.getMethod() != CompressionMethod.STORE;
        if (isCompressed) {
            return 1;
        }
        return this.mAlignmentRule.alignment(cdh.getName());
    }

    public void mergeFrom(ZFile src, Predicate<String> ignoreFilter) throws IOException {
        for (StoredEntry fromEntry : src.entries()) {
            int r;
            CentralDirectoryHeader newFileData;
            if (ignoreFilter.test(fromEntry.getCentralDirectoryHeader().getName())) continue;
            boolean replaceCurrent = true;
            String path = fromEntry.getCentralDirectoryHeader().getName();
            FileUseMapEntry<StoredEntry> currentEntry = this.mEntries.get(path);
            if (currentEntry != null) {
                long fromSize = fromEntry.getCentralDirectoryHeader().getUncompressedSize();
                long fromCrc = fromEntry.getCentralDirectoryHeader().getCrc32();
                StoredEntry currentStore = currentEntry.getStore();
                assert (currentStore != null);
                long currentSize = currentStore.getCentralDirectoryHeader().getUncompressedSize();
                long currentCrc = currentStore.getCentralDirectoryHeader().getCrc32();
                if (fromSize == currentSize && fromCrc == currentCrc) {
                    replaceCurrent = false;
                }
            }
            if (!replaceCurrent) continue;
            CentralDirectoryHeader fromCdr = fromEntry.getCentralDirectoryHeader();
            CentralDirectoryHeaderCompressInfo fromCompressInfo = fromCdr.getCompressionInfoWithWait();
            try {
                newFileData = fromCdr.clone();
                newFileData.setOffset(-1L);
                newFileData.resetDeferredCrc();
            }
            catch (CloneNotSupportedException e) {
                throw new IOException("Failed to clone CDR.", e);
            }
            ProcessedAndRawByteSources fromSource = fromEntry.getSource();
            InputStream fromInput = fromSource.getRawByteSource().openStream();
            long sourceSize = fromSource.getRawByteSource().size();
            if (sourceSize > Integer.MAX_VALUE) {
                throw new IOException("Cannot read source with " + sourceSize + " bytes.");
            }
            byte[] data = new byte[Ints.checkedCast((long)sourceSize)];
            for (int read = 0; read < data.length; read += r) {
                r = fromInput.read(data, read, data.length - read);
                Verify.verify((r >= 0 ? 1 : 0) != 0, (String)"There should be at least 'size' bytes in the stream.", (Object[])new Object[0]);
            }
            CloseableDelegateByteSource rawContents = this.mTracker.fromSource(fromSource.getRawByteSource());
            CloseableByteSource processedContents = fromCompressInfo.getMethod() == CompressionMethod.DEFLATE ? new InflaterByteSource(rawContents) : rawContents;
            ProcessedAndRawByteSources newSource = new ProcessedAndRawByteSources(processedContents, rawContents);
            StoredEntry newEntry = new StoredEntry(newFileData, this, newSource);
            this.add(newEntry);
        }
    }

    public void touch() {
        this.mDirty = true;
    }

    public void finishAllBackgroundTasks() throws IOException {
        this.processAllReadyEntriesWithWait();
    }

    public boolean realign() throws IOException {
        boolean anyChanges = false;
        for (StoredEntry entry : this.entries()) {
            anyChanges |= entry.realign();
        }
        return anyChanges;
    }

    boolean realign(StoredEntry entry) throws IOException {
        CentralDirectoryHeader clonedCdh;
        FileUseMapEntry<StoredEntry> mapEntry = this.mEntries.get(entry.getCentralDirectoryHeader().getName());
        Verify.verify((entry == mapEntry.getStore() ? 1 : 0) != 0);
        long currentDataOffset = mapEntry.getStart() + (long)entry.getLocalHeaderSize();
        int expectedAlignment = this.chooseAlignment(entry);
        long misalignment = currentDataOffset % (long)expectedAlignment;
        if (misalignment == 0L) {
            return false;
        }
        if (entry.getCentralDirectoryHeader().getOffset() == -1L) {
            this.mMap.remove(mapEntry);
            long newStart = this.mMap.locateFree(mapEntry.getSize(), entry.getLocalHeaderSize(), expectedAlignment, FileUseMap.PositionAlgorithm.BEST_FIT);
            mapEntry = this.mMap.add(newStart, newStart + entry.getInFileSize(), entry);
            this.mEntries.put(entry.getCentralDirectoryHeader().getName(), mapEntry);
            Verify.verify((boolean)this.mDirty);
            return false;
        }
        CentralDirectoryHeaderCompressInfo compressInfo = entry.getCentralDirectoryHeader().getCompressionInfoWithWait();
        ProcessedAndRawByteSources source = entry.getSource();
        try {
            clonedCdh = entry.getCentralDirectoryHeader().clone();
        }
        catch (CloneNotSupportedException e) {
            Verify.verify((boolean)false);
            return false;
        }
        clonedCdh.setOffset(-1L);
        clonedCdh.resetDeferredCrc();
        CloseableDelegateByteSource rawContents = this.mTracker.fromSource(source.getRawByteSource());
        CloseableByteSource processedContents = compressInfo.getMethod() == CompressionMethod.DEFLATE ? new InflaterByteSource(rawContents) : rawContents;
        ProcessedAndRawByteSources newSource = new ProcessedAndRawByteSources(processedContents, rawContents);
        StoredEntry newEntry = new StoredEntry(clonedCdh, this, newSource);
        this.add(newEntry);
        return true;
    }

    public void addZFileExtension(ZFileExtension extension) {
        this.mExtensions.add(extension);
    }

    public void removeZFileExtension(ZFileExtension extension) {
        this.mExtensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(IOExceptionFunction<ZFileExtension, IOExceptionRunnable> function) throws IOException {
        for (ZFileExtension fl : Lists.newArrayList(this.mExtensions)) {
            IOExceptionRunnable r = function.apply(fl);
            if (r == null) continue;
            this.mToRun.add(r);
        }
        if (!this.mIsNotifying) {
            this.mIsNotifying = true;
            try {
                while (!this.mToRun.isEmpty()) {
                    IOExceptionRunnable r = this.mToRun.remove(0);
                    r.run();
                }
            }
            finally {
                this.mIsNotifying = false;
            }
        }
    }

    public void directWrite(long offset, byte[] data, int start, int count) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start >= 0");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count >= 0");
        if (data.length == 0) {
            return;
        }
        Preconditions.checkArgument((start <= data.length ? 1 : 0) != 0, (Object)"start > data.length");
        Preconditions.checkArgument((start + count <= data.length ? 1 : 0) != 0, (Object)"start + count > data.length");
        this.reopenRw();
        assert (this.mRaf != null);
        this.mRaf.seek(offset);
        this.mRaf.write(data, start, count);
    }

    public void directWrite(long offset, byte[] data) throws IOException {
        this.directWrite(offset, data, 0, data.length);
    }

    public int directRead(long offset, byte[] data, int start, int count) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start >= 0");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count >= 0");
        if (data.length == 0) {
            return 0;
        }
        Preconditions.checkArgument((start <= data.length ? 1 : 0) != 0, (Object)"start > data.length");
        Preconditions.checkArgument((start + count <= data.length ? 1 : 0) != 0, (Object)"start + count > data.length");
        if (this.mRaf == null) {
            this.reopenRw();
            assert (this.mRaf != null);
        }
        this.mRaf.seek(offset);
        return this.mRaf.read(data, start, count);
    }

    public int directRead(long offset, byte[] data) throws IOException {
        return this.directRead(offset, data, 0, data.length);
    }

    public void directFullyRead(long offset, byte[] data) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"File is closed");
        this.mRaf.seek(offset);
        RandomAccessFileUtils.fullyRead(this.mRaf, data);
    }

    public void addAllRecursively(File file) throws IOException {
        this.addAllRecursively(file, f -> true);
    }

    public void addAllRecursively(File file, Function<? super File, Boolean> mayCompress) throws IOException {
        if (file.isFile()) {
            boolean mayCompressFile = (Boolean)Verify.verifyNotNull((Object)mayCompress.apply(file), (String)"mayCompress.apply() returned null", (Object[])new Object[0]);
            try (Closer closer = Closer.create();){
                FileInputStream fileInput = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
                this.add(file.getName(), fileInput, mayCompressFile);
            }
            return;
        }
        for (File f : Files.fileTreeTraverser().preOrderTraversal((Object)file).skip(1)) {
            String path = FileUtils.relativePath((File)f, (File)file);
            path = FileUtils.toSystemIndependentPath((String)path);
            Closer closer = Closer.create();
            Throwable throwable = null;
            try {
                boolean mayCompressFile;
                InputStream stream;
                if (f.isDirectory()) {
                    stream = (InputStream)closer.register((Closeable)new ByteArrayInputStream(new byte[0]));
                    mayCompressFile = false;
                } else {
                    stream = (InputStream)closer.register((Closeable)new FileInputStream(f));
                    mayCompressFile = (Boolean)Verify.verifyNotNull((Object)mayCompress.apply(f), (String)"mayCompress.apply() returned null", (Object[])new Object[0]);
                }
                this.add(path, stream, mayCompressFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closer == null) continue;
                if (throwable != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                closer.close();
            }
        }
    }

    public long getCentralDirectoryOffset() {
        if (this.mDirectoryEntry != null) {
            return this.mDirectoryEntry.getStart();
        }
        if (this.mEntries.isEmpty()) {
            return this.mExtraDirectoryOffset;
        }
        return this.mMap.usedSize() + this.mExtraDirectoryOffset;
    }

    public long getCentralDirectorySize() {
        if (this.mDirectoryEntry != null) {
            return this.mDirectoryEntry.getSize();
        }
        if (this.mEntries.isEmpty()) {
            return 0L;
        }
        return 1L;
    }

    public long getEocdOffset() {
        if (this.mEocdEntry == null) {
            return -1L;
        }
        return this.mEocdEntry.getStart();
    }

    public long getEocdSize() {
        if (this.mEocdEntry == null) {
            return -1L;
        }
        return this.mEocdEntry.getSize();
    }

    public void setExtraDirectoryOffset(long offset) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        if (this.mExtraDirectoryOffset != offset) {
            this.mExtraDirectoryOffset = offset;
            this.deleteDirectoryAndEocd();
            this.mDirty = true;
        }
    }

    public long getExtraDirectoryOffset() {
        return this.mExtraDirectoryOffset;
    }

    public boolean areTimestampsIgnored() {
        return this.mNoTimestamps;
    }

    public void sortZipContents() throws IOException {
        this.reopenRw();
        this.processAllReadyEntriesWithWait();
        Verify.verify((boolean)this.mUncompressedEntries.isEmpty());
        TreeSet sortedEntries = Sets.newTreeSet(StoredEntry.COMPARE_BY_NAME);
        for (FileUseMapEntry<StoredEntry> fmEntry : this.mEntries.values()) {
            StoredEntry entry = fmEntry.getStore();
            Preconditions.checkNotNull((Object)entry);
            sortedEntries.add(entry);
            entry.loadSourceIntoMemory();
            this.mMap.remove(fmEntry);
        }
        this.mEntries.clear();
        for (StoredEntry entry : sortedEntries) {
            String name = entry.getCentralDirectoryHeader().getName();
            FileUseMapEntry<StoredEntry> positioned = this.positionInFile(entry, PositionHint.LOWEST_OFFSET);
            this.mEntries.put(name, positioned);
        }
        this.mDirty = true;
    }

    public File getFile() {
        return this.mFile;
    }

    private static byte[] makeExtraAlignmentBlock(int blockSize, int alignment) throws IOException {
        Preconditions.checkArgument((blockSize >= 6 ? 1 : 0) != 0, (Object)("blockSize (" + blockSize + ") < MINIMUM_EXTRA_FIELD_SIZE"));
        byte[] data = new byte[blockSize];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        LittleEndianUtils.writeUnsigned2Le(buffer, 55605);
        LittleEndianUtils.writeUnsigned2Le(buffer, blockSize - 4);
        LittleEndianUtils.writeUnsigned2Le(buffer, alignment);
        return data;
    }

    static enum PositionHint {
        ANYWHERE,
        LOWEST_OFFSET;

    }
}

